/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck.application;

import io.opentracing.Span;
import io.opentracing.Tracer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.microprofile.opentracing.ClientTracingRegistrar;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.opentracing.tck.application.ApplicationUtils;
import org.eclipse.microprofile.opentracing.tck.application.TestAnnotatedClass;
import org.eclipse.microprofile.opentracing.tck.application.TestAnnotatedMethods;
import org.eclipse.microprofile.opentracing.tck.application.TestDisabledAnnotatedClass;

@Path(value="testServices")
public class TestServerWebServices {
    public static final String REST_TEST_SERVICE_PATH = "testServices";
    public static final String REST_SIMPLE_TEST = "simpleTest";
    public static final String REST_LOCAL_SPAN = "localSpan";
    public static final String REST_SKIP_SIMPLE = "skipSimple";
    public static final String REST_ASYNC_LOCAL_SPAN = "asyncLocalSpan";
    public static final String REST_ERROR = "error";
    public static final String REST_EXCEPTION = "exception";
    public static final String REST_ANNOTATIONS = "annotations";
    public static final String REST_ANNOTATION_EXCEPTION = "annotationException";
    public static final String PARAM_UNIQUE_ID = "data";
    public static final String PARAM_FAIL_NEST = "failNest";
    public static final String PARAM_ASYNC = "async";
    public static final String REST_NESTED = "nested";
    public static final String PARAM_NEST_DEPTH = "nestDepth";
    public static final String PARAM_NEST_BREADTH = "nestBreadth";
    public static final String LOCAL_SPAN_TAG_KEY = "localSpanKey";
    public static final String LOCAL_SPAN_TAG_VALUE = "localSpanValue";
    public static final String REST_NOT_TRACED = "notTraced";
    public static final String REST_OPERATION_NAME = "operationName";
    @Inject
    private Tracer tracer;
    @Context
    private UriInfo uri;
    @Inject
    private TestAnnotatedClass testAnnotatedClass;
    @Inject
    private TestDisabledAnnotatedClass testDisabledAnnotatedClass;
    @Inject
    private TestAnnotatedMethods testAnnotatedMethods;

    @GET
    @Path(value="simpleTest")
    @Produces(value={"text/plain"})
    public Response simpleTest() {
        return Response.ok().build();
    }

    @GET
    @Path(value="localSpan")
    @Produces(value={"text/plain"})
    public Response localSpan() {
        this.finishChildSpan(this.startChildSpan(REST_LOCAL_SPAN));
        return Response.ok().build();
    }

    @GET
    @Path(value="asyncLocalSpan")
    @Produces(value={"text/plain"})
    public void asyncLocalSpan(@Suspended AsyncResponse asyncResponse) {
        this.finishChildSpan(this.startChildSpan(REST_LOCAL_SPAN));
        asyncResponse.resume((Object)Response.ok().build());
    }

    @GET
    @Path(value="error")
    @Produces(value={"text/plain"})
    public Response error() {
        return Response.serverError().build();
    }

    @GET
    @Path(value="exception")
    @Produces(value={"text/plain"})
    public Response exception() {
        throw ApplicationUtils.createExampleRuntimeException();
    }

    @GET
    @Path(value="annotations")
    @Produces(value={"text/plain"})
    public Response annotations() {
        this.testAnnotatedClass.annotatedClassMethodImplicitlyTraced();
        this.testAnnotatedClass.annotatedClassMethodExplicitlyNotTraced();
        this.testAnnotatedClass.annotatedClassMethodExplicitlyTraced();
        this.testAnnotatedClass.annotatedClassMethodExplicitlyNotTracedWithOpName();
        this.testAnnotatedMethods.annotatedMethodExplicitlyTraced();
        this.testAnnotatedMethods.annotatedMethodExplicitlyNotTraced();
        this.testAnnotatedMethods.annotatedMethodExplicitlyTracedWithOpName();
        this.testAnnotatedMethods.annotatedMethodExplicitlyNotTracedWithOpName();
        this.testDisabledAnnotatedClass.annotatedClassMethodExplicitlyTraced();
        this.testDisabledAnnotatedClass.annotatedClassMethodImplicitlyNotTraced();
        this.testDisabledAnnotatedClass.annotatedClassMethodExplicitlyTracedWithOperationName();
        return Response.ok().build();
    }

    @GET
    @Path(value="annotationException")
    @Produces(value={"text/plain"})
    public Response annotationException() {
        try {
            this.testAnnotatedClass.annotatedClassMethodImplicitlyTracedWithException();
        }
        catch (Throwable t) {
            System.out.println("annotationException expected exception caught");
        }
        return Response.ok().build();
    }

    @Traced(value=false)
    @GET
    @Path(value="notTraced")
    @Produces(value={"text/plain"})
    public Response notTraced() {
        return Response.ok().build();
    }

    @Traced(operationName="operationName")
    @GET
    @Path(value="operationName")
    @Produces(value={"text/plain"})
    public Response operationName() {
        return Response.ok().build();
    }

    @GET
    @Path(value="nested")
    @Produces(value={"text/plain"})
    public Response nested(@QueryParam(value="nestDepth") int nestDepth, @QueryParam(value="nestBreadth") int nestBreadth, @QueryParam(value="data") String uniqueID, @QueryParam(value="failNest") boolean failNest, @QueryParam(value="async") boolean async) throws InterruptedException, ExecutionException {
        if (nestDepth > 0) {
            String target;
            HashMap<String, Object> nestParameters = new HashMap<String, Object>();
            if (failNest) {
                target = REST_ERROR;
            } else {
                target = REST_NESTED;
                nestParameters.put(PARAM_NEST_DEPTH, nestDepth - 1);
                nestParameters.put(PARAM_NEST_BREADTH, 1);
                nestParameters.put(PARAM_UNIQUE_ID, uniqueID);
                nestParameters.put(PARAM_FAIL_NEST, false);
                nestParameters.put(PARAM_ASYNC, async);
            }
            String requestUrl = this.getRequestPath(REST_TEST_SERVICE_PATH, target, nestParameters);
            ArrayList<Future<Response>> futures = new ArrayList<Future<Response>>();
            for (int i = 0; i < nestBreadth; ++i) {
                if (async) {
                    futures.add(this.executeNestedAsync(requestUrl));
                    continue;
                }
                this.executeNested(requestUrl);
            }
            for (Future future : futures) {
                ((Response)future.get()).close();
            }
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="skipSimple")
    @Produces(value={"text/plain"})
    public Response skipSimple() {
        boolean isActiveSpan = this.tracer.activeSpan() != null;
        return Response.ok().status(isActiveSpan ? Response.Status.OK.getStatusCode() : Response.Status.NO_CONTENT.getStatusCode()).build();
    }

    private void executeNested(String requestUrl) {
        Client restClient = ClientTracingRegistrar.configure((ClientBuilder)ClientBuilder.newBuilder()).build();
        WebTarget target = restClient.target(requestUrl);
        Response nestedResponse = target.request().get();
        nestedResponse.close();
    }

    private Future<Response> executeNestedAsync(String requestUrl) {
        Client restClient = ClientTracingRegistrar.configure((ClientBuilder)ClientBuilder.newBuilder()).build();
        WebTarget target = restClient.target(requestUrl);
        return target.request().async().get();
    }

    public String getRequestPath(String servicePath, String endpointPath, Map<String, Object> requestParameters) {
        URL incomingURL;
        String incomingUrl = this.uri.getAbsolutePath().toString();
        int i = incomingUrl.indexOf("rest");
        if (i == -1) {
            throw new RuntimeException("Expecting rest in " + incomingUrl);
        }
        try {
            incomingURL = new URL(incomingUrl.substring(0, i));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String result = ApplicationUtils.getWebServiceURL(incomingURL, servicePath, endpointPath);
        if (requestParameters != null && !requestParameters.isEmpty()) {
            result = result + ApplicationUtils.getQueryString(requestParameters);
        }
        return result;
    }

    private Span startChildSpan(String operationName) {
        Span activeSpan = this.tracer.activeSpan();
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName);
        if (activeSpan != null) {
            spanBuilder.asChildOf(activeSpan.context());
        }
        Span childSpan = spanBuilder.start();
        childSpan.setTag(LOCAL_SPAN_TAG_KEY, LOCAL_SPAN_TAG_VALUE);
        return childSpan;
    }

    private void finishChildSpan(Span span) {
        span.finish();
    }
}

