/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck.application;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.microprofile.opentracing.ClientTracingRegistrar;

@Path(value="testRegistrarServices")
public class TestClientRegistrarWebServices {
    public static final String REST_SERVICE_PATH = "testRegistrarServices";
    public static final String REST_OK = "ok";
    public static final String REST_CLIENT_BUILDER = "clientBuilder";
    public static final String REST_CLIENT_BUILDER_EXECUTOR = "clientBuilderExecutor";
    @Context
    private UriInfo uri;

    @GET
    @Path(value="ok")
    @Produces(value={"text/plain"})
    public Response ok() {
        return Response.ok().build();
    }

    @GET
    @Path(value="clientBuilder")
    @Produces(value={"text/plain"})
    public Response clientRegistrar(@QueryParam(value="async") boolean async) throws ExecutionException, InterruptedException {
        return this.executeSimpleEndpoint(this.instrumentedClient(), async);
    }

    @GET
    @Path(value="clientBuilderExecutor")
    @Produces(value={"text/plain"})
    public Response clientRegistrarExecutor(@QueryParam(value="async") boolean async) throws ExecutionException, InterruptedException {
        return this.executeSimpleEndpoint(this.instrumentedClientExecutor(), async);
    }

    private Response executeSimpleEndpoint(Client client, boolean async) throws ExecutionException, InterruptedException {
        Invocation.Builder requestBuilder = client.target(this.uri.getBaseUri()).path(REST_SERVICE_PATH).path(REST_OK).request();
        Response response = async ? (Response)requestBuilder.async().get().get() : requestBuilder.get();
        response.close();
        client.close();
        return Response.status((int)response.getStatus()).build();
    }

    private Client instrumentedClient() {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        ClientTracingRegistrar.configure((ClientBuilder)clientBuilder);
        return clientBuilder.build();
    }

    private Client instrumentedClientExecutor() {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        ClientTracingRegistrar.configure((ClientBuilder)clientBuilder, (ExecutorService)Executors.newFixedThreadPool(10));
        return clientBuilder.build();
    }
}

