/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.eclipse.microprofile.openapi.tck.AppTestBase;
import org.eclipse.microprofile.openapi.tck.utils.TCKMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsMapWithSize;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PetStoreAppTest
extends AppTestBase {
    @Deployment(name="petstore", testable=false)
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"petstore.war")).addPackages(true, new String[]{"org.eclipse.microprofile.openapi.apps.petstore"});
    }

    @Test(dataProvider="formatProvider")
    public void testSchema(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/pet/findByTags'.get.parameters.find{ it.name == 'tags' }.schema.default", Matchers.equalTo((Object)"Dog"), new Object[0]);
        vr.body("paths.'/pet/findByTags'.get.parameters.find{ it.name == 'tags' }.schema.enum", Matchers.hasItems((Object[])new String[]{"Cat", "Dog", "Lizard"}), new Object[0]);
        vr.body("paths.'/pet/findByTags'.get.parameters.find{ it.name == 'tags' }.schema.externalDocs.description", Matchers.equalTo((Object)"Pet Types"), new Object[0]);
        vr.body("paths.'/pet/findByTags'.get.parameters.find{ it.name == 'tags' }.schema.deprecated", Matchers.equalTo((Object)true), new Object[0]);
        vr.body("paths.'/store/order/{orderId}'.get.responses.'599'.schema", Matchers.nullValue(), new Object[0]);
        vr.body("paths.'/pet/{petId}'.get.parameters.find{ it.name == 'petId' }.schema.maximum", TCKMatchers.comparesEqualToNumber(101.0), new Object[0]);
        vr.body("paths.'/pet/{petId}'.get.parameters.find{ it.name == 'petId' }.schema.exclusiveMaximum", Matchers.equalTo((Object)true), new Object[0]);
        vr.body("paths.'/pet/{petId}'.get.parameters.find{ it.name == 'petId' }.schema.minimum", TCKMatchers.comparesEqualToNumber(9), new Object[0]);
        vr.body("paths.'/pet/{petId}'.get.parameters.find{ it.name == 'petId' }.schema.exclusiveMinimum", Matchers.equalTo((Object)true), new Object[0]);
        vr.body("paths.'/pet/{petId}'.get.parameters.find{ it.name == 'petId' }.schema.multipleOf", TCKMatchers.comparesEqualToNumber(10), new Object[0]);
        vr.body("paths.'/pet/{petId}'.delete.parameters.find{ it.name == 'apiKey' }.schema.maxLength", Matchers.equalTo((Object)256), new Object[0]);
        vr.body("paths.'/pet/{petId}'.delete.parameters.find{ it.name == 'apiKey' }.schema.minLength", Matchers.equalTo((Object)32), new Object[0]);
    }

    @Test(dataProvider="formatProvider")
    public void testSecurityRequirement(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/pet'.put.security.petsHttp[0][0]", Matchers.equalTo(null), new Object[0]);
        vr.body("paths.'/pet'.post.security.petsApiKey[0][0]", Matchers.equalTo(null), new Object[0]);
        vr.body("paths.'/pet/{petId}'.delete.security.petsOAuth2[0][0]", Matchers.equalTo((Object)"write:pets"), new Object[0]);
        vr.body("paths.'/store/inventory'.get.security.storeOpenIdConnect[0]", Matchers.hasSize((int)2), new Object[0]);
        vr.body("paths.'/store/inventory'.get.security.storeOpenIdConnect[0][0]", Matchers.equalTo((Object)"write:store"), new Object[0]);
        vr.body("paths.'/store/inventory'.get.security.storeOpenIdConnect[0][1]", Matchers.equalTo((Object)"read:store"), new Object[0]);
        vr.body("paths.'/store/inventory'.get.security.storeHttp[0]", Matchers.equalTo(null), new Object[0]);
        vr.body("paths.'/store/order/{orderId}'.get.security.storeOpenIdConnect", Matchers.hasSize((int)2), new Object[0]);
        vr.body("paths.'/store/order/{orderId}'.get.security.storeOpenIdConnect[0][0]", Matchers.equalTo((Object)"write:store"), new Object[0]);
        vr.body("paths.'/store/order/{orderId}'.get.security.storeOpenIdConnect[0][1]", Matchers.equalTo((Object)"read:store"), new Object[0]);
        vr.body("paths.'/store/order/{orderId}'.get.security.find { it.storeHttp != null }.storeHttp", IsEmptyCollection.empty(), new Object[0]);
        vr.body("paths.'/user'.post.security.find { it.userApiKey != null }.userApiKey", IsEmptyCollection.empty(), new Object[0]);
        vr.body("paths.'/user'.post.security.find { it.userBasicHttp != null }.userBasicHttp", IsEmptyCollection.empty(), new Object[0]);
        vr.body("paths.'/user'.post.security.find { it.userBearerHttp != null }.userBearerHttp", IsEmptyCollection.empty(), new Object[0]);
    }

    @Test(dataProvider="formatProvider")
    public void testSecuritySchemes(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String s = "components.securitySchemes";
        vr.body(s, Matchers.hasKey((Object)"petsOAuth2"), new Object[0]);
        vr.body(s, Matchers.hasKey((Object)"userApiKey"), new Object[0]);
        vr.body(s, Matchers.hasKey((Object)"userBearerHttp"), new Object[0]);
        vr.body(s, Matchers.hasKey((Object)"petsApiKey"), new Object[0]);
        vr.body(s, Matchers.hasKey((Object)"storeOpenIdConnect"), new Object[0]);
        vr.body(s, Matchers.hasKey((Object)"userBasicHttp"), new Object[0]);
        vr.body(s, Matchers.hasKey((Object)"storeHttp"), new Object[0]);
        vr.body(s, Matchers.hasKey((Object)"petsHttp"), new Object[0]);
    }

    @Test(dataProvider="formatProvider")
    public void testSecurityScheme(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String petsApiKey = "components.securitySchemes.petsApiKey.";
        vr.body(petsApiKey + "type", Matchers.equalTo((Object)"apiKey"), new Object[0]);
        vr.body(petsApiKey + "description", Matchers.equalTo((Object)"authentication needed to create a new pet profile for the store"), new Object[0]);
        vr.body(petsApiKey + "name", Matchers.equalTo((Object)"createPetProfile"), new Object[0]);
        vr.body(petsApiKey + "in", Matchers.equalTo((Object)"header"), new Object[0]);
        String userApiKey = "components.securitySchemes.userApiKey.";
        vr.body(userApiKey + "type", Matchers.equalTo((Object)"apiKey"), new Object[0]);
        vr.body(userApiKey + "description", Matchers.equalTo((Object)"authentication needed to create a new user profile for the store"), new Object[0]);
        vr.body(userApiKey + "name", Matchers.equalTo((Object)"createOrUpdateUserProfile1"), new Object[0]);
        vr.body(userApiKey + "in", Matchers.equalTo((Object)"header"), new Object[0]);
        String userBearerHttp = "components.securitySchemes.userBearerHttp.";
        vr.body(userBearerHttp + "type", Matchers.equalTo((Object)"http"), new Object[0]);
        vr.body(userBearerHttp + "description", Matchers.equalTo((Object)"authentication needed to create a new user profile for the store"), new Object[0]);
        vr.body(userBearerHttp + "scheme", Matchers.equalTo((Object)"bearer"), new Object[0]);
        vr.body(userBearerHttp + "bearerFormat", Matchers.equalTo((Object)"JWT"), new Object[0]);
        String petsOAuth2 = "components.securitySchemes.petsOAuth2.";
        vr.body(petsOAuth2 + "type", Matchers.equalTo((Object)"oauth2"), new Object[0]);
        vr.body(petsOAuth2 + "description", Matchers.equalTo((Object)"authentication needed to delete a pet profile"), new Object[0]);
        String userBasicHttp = "components.securitySchemes.userBasicHttp.";
        vr.body(userBasicHttp + "type", Matchers.equalTo((Object)"http"), new Object[0]);
        vr.body(userBasicHttp + "description", Matchers.equalTo((Object)"authentication needed to create a new user profile for the store"), new Object[0]);
        vr.body(userBasicHttp + "scheme", Matchers.equalTo((Object)"basic"), new Object[0]);
        String storeHttp = "components.securitySchemes.storeHttp.";
        vr.body(storeHttp + "type", Matchers.equalTo((Object)"http"), new Object[0]);
        vr.body(storeHttp + "description", Matchers.equalTo((Object)"Basic http authentication to access the pet store resource"), new Object[0]);
        vr.body(storeHttp + "scheme", Matchers.equalTo((Object)"basic"), new Object[0]);
        String petsHttp = "components.securitySchemes.petsHttp.";
        vr.body(petsHttp + "type", Matchers.equalTo((Object)"http"), new Object[0]);
        vr.body(petsHttp + "description", Matchers.equalTo((Object)"authentication needed to update an exsiting record of a pet in the store"), new Object[0]);
        vr.body(petsHttp + "scheme", Matchers.equalTo((Object)"bearer"), new Object[0]);
        vr.body(petsHttp + "bearerFormat", Matchers.equalTo((Object)"jwt"), new Object[0]);
        String storeOpenIdConnect = "components.securitySchemes.storeOpenIdConnect.";
        vr.body(storeOpenIdConnect + "type", Matchers.equalTo((Object)"openIdConnect"), new Object[0]);
        vr.body(storeOpenIdConnect + "description", Matchers.equalTo((Object)"openId Connect authentication to access the pet store resource"), new Object[0]);
        vr.body(storeOpenIdConnect + "openIdConnectUrl", Matchers.equalTo((Object)"https://petstoreauth.com:4433/oidc/petstore/oidcprovider/authorize"), new Object[0]);
    }

    @Test(dataProvider="formatProvider")
    public void testOAuthFlows(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String t = "components.securitySchemes.petsOAuth2.flows";
        vr.body(t, Matchers.hasKey((Object)"implicit"), new Object[0]);
        vr.body(t, Matchers.hasKey((Object)"authorizationCode"), new Object[0]);
    }

    @Test(dataProvider="formatProvider")
    public void testOAuthFlow(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String implicit = "components.securitySchemes.petsOAuth2.flows.implicit.";
        vr.body(implicit + "authorizationUrl", Matchers.equalTo((Object)"https://example.com/api/oauth/dialog"), new Object[0]);
        String authCode = "components.securitySchemes.petsOAuth2.flows.authorizationCode.";
        vr.body(authCode + "authorizationUrl", Matchers.equalTo((Object)"https://example.com/api/oauth/dialog"), new Object[0]);
        vr.body(authCode + "tokenUrl", Matchers.equalTo((Object)"https://example.com/api/oauth/token"), new Object[0]);
    }

    @Test
    public void testDefaultResponseType() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().filter(AppTestBase.YAML_FILTER).when().get("/openapi", new Object[0])).then()).assertThat()).statusCode(200)).and()).body("openapi", Matchers.startsWith((String)"3.0."), new Object[0]);
    }

    @Test(dataProvider="formatProvider")
    public void testRequestBodySchema(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String path = PetStoreAppTest.dereference(vr, "paths.'/pet/{petId}'.post.requestBody");
        vr.body(path, Matchers.notNullValue(), new Object[0]);
        String schemaPath = PetStoreAppTest.dereference(vr, path) + ".content.'text/csv'.schema";
        vr.body(schemaPath, Matchers.notNullValue(), new Object[0]);
        String schemaObject = PetStoreAppTest.dereference(vr, schemaPath);
        vr.body(schemaObject, Matchers.allOf((Matcher)IsMapWithSize.aMapWithSize((int)3), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"required"), (Matcher)Matchers.notNullValue()), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"type"), (Matcher)Matchers.equalTo((Object)"object")), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"properties"), (Matcher)Matchers.notNullValue())), new Object[0]);
    }

    @Test(dataProvider="formatProvider")
    public void testAPIResponseSchema(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String path = PetStoreAppTest.dereference(vr, "paths.'/pet/{petId}'.post.responses.'204'");
        vr.body(path, Matchers.notNullValue(), new Object[0]);
        vr.body(path, Matchers.hasEntry((Object)"description", (Object)"No Content"), new Object[0]);
        String schemaPath = PetStoreAppTest.dereference(vr, path) + ".content.'text/csv'.schema";
        vr.body(schemaPath, Matchers.notNullValue(), new Object[0]);
        String schemaObject = PetStoreAppTest.dereference(vr, schemaPath);
        vr.body(schemaObject, Matchers.allOf((Matcher)IsMapWithSize.aMapWithSize((int)3), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"required"), (Matcher)Matchers.notNullValue()), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"type"), (Matcher)Matchers.equalTo((Object)"object")), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"properties"), (Matcher)Matchers.notNullValue())), new Object[0]);
    }

    @Test(dataProvider="formatProvider")
    public void testAPIResponseSchemaDefaultResponseCode(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String path = PetStoreAppTest.dereference(vr, "paths.'/pet/findByTags'.get.responses.'200'");
        Assert.assertNotNull((Object)path);
        vr.body(path, Matchers.notNullValue(), new Object[0]);
        vr.body(path, Matchers.hasEntry((Object)"description", (Object)"OK"), new Object[0]);
        String schemaPath = PetStoreAppTest.dereference(vr, path) + ".content.'application/json'.schema";
        vr.body(schemaPath, Matchers.notNullValue(), new Object[0]);
        String arraySchemaObject = PetStoreAppTest.dereference(vr, schemaPath);
        vr.body(arraySchemaObject, Matchers.allOf((Matcher)IsMapWithSize.aMapWithSize((int)2), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"type"), (Matcher)Matchers.equalTo((Object)"array")), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"items"), (Matcher)Matchers.notNullValue())), new Object[0]);
        String schemaObject = PetStoreAppTest.dereference(vr, arraySchemaObject + ".items");
        vr.body(schemaObject, Matchers.allOf((Matcher)IsMapWithSize.aMapWithSize((int)3), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"required"), (Matcher)Matchers.notNullValue()), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"type"), (Matcher)Matchers.equalTo((Object)"object")), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"properties"), (Matcher)Matchers.notNullValue())), new Object[0]);
    }

    @Test(dataProvider="formatProvider")
    public void testExtensionPlacement(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String X_OPERATION_EXT = "x-operation-ext";
        String TEST_OPERATION_EXT = "test-operation-ext";
        String opPath = "paths.'/store/inventory'.get";
        vr.body(opPath, Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"x-operation-ext"), (Matcher)Matchers.equalTo((Object)"test-operation-ext")), new Object[0]);
        vr.body(opPath + ".responses", Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"x-responses-ext"), (Matcher)Matchers.equalTo((Object)"test-responses-ext")), new Object[0]);
        vr.body(opPath + ".responses.'200'", Matchers.not((Matcher)Matchers.hasKey((Object)"x-operation-ext")), new Object[0]);
        vr.body(opPath + ".responses.'200'", Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"x-response-ext"), (Matcher)Matchers.equalTo((Object)"test-response-ext")), new Object[0]);
        vr.body(opPath + ".responses.'500'", Matchers.not((Matcher)Matchers.hasKey((Object)"x-operation-ext")), new Object[0]);
        vr.body(opPath + ".responses.'503'", Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"x-operation-ext"), (Matcher)Matchers.equalTo((Object)"test-operation-ext")), new Object[0]);
        vr.body(opPath + ".responses.'503'.content.'application/json'", Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"x-notavailable-ext"), (Matcher)Matchers.equalTo((Object)"true")), new Object[0]);
        vr.body(opPath + ".responses.'503'.content.'application/xml'", Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"x-notavailable-ext"), (Matcher)Matchers.equalTo((Object)"true")), new Object[0]);
    }
}

