/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import jakarta.inject.Inject;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.tck.util.TestUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TimerTest {
    @Inject
    private MetricRegistry registry;
    private static Timer globalTimer = null;
    private static boolean isInitialized = false;
    static final long[] SAMPLE_LONG_DATA = new long[]{0L, 10L, 20L, 20L, 20L, 30L, 30L, 30L, 30L, 30L, 40L, 50L, 50L, 60L, 70L, 70L, 70L, 80L, 90L, 90L, 100L, 110L, 110L, 120L, 120L, 120L, 120L, 130L, 130L, 130L, 130L, 140L, 140L, 150L, 150L, 170L, 180L, 180L, 200L, 200L, 200L, 210L, 220L, 220L, 220L, 240L, 240L, 250L, 250L, 270L, 270L, 270L, 270L, 270L, 270L, 270L, 280L, 280L, 290L, 300L, 310L, 310L, 320L, 320L, 330L, 330L, 360L, 360L, 360L, 360L, 370L, 380L, 380L, 380L, 390L, 400L, 400L, 410L, 420L, 420L, 420L, 430L, 440L, 440L, 440L, 450L, 450L, 450L, 460L, 460L, 460L, 460L, 470L, 470L, 470L, 470L, 470L, 470L, 480L, 480L, 490L, 490L, 500L, 510L, 520L, 520L, 520L, 530L, 540L, 540L, 550L, 560L, 560L, 570L, 570L, 590L, 590L, 600L, 610L, 610L, 620L, 620L, 630L, 640L, 640L, 640L, 650L, 660L, 660L, 660L, 670L, 670L, 680L, 680L, 700L, 710L, 710L, 710L, 710L, 720L, 720L, 720L, 720L, 730L, 730L, 740L, 740L, 740L, 750L, 750L, 760L, 760L, 760L, 770L, 780L, 780L, 780L, 800L, 800L, 810L, 820L, 820L, 820L, 830L, 830L, 840L, 840L, 850L, 870L, 870L, 880L, 880L, 880L, 890L, 890L, 890L, 890L, 900L, 910L, 920L, 920L, 920L, 930L, 940L, 950L, 950L, 950L, 960L, 960L, 960L, 960L, 970L, 970L, 970L, 970L, 980L, 980L, 980L, 990L, 990L};

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(TestUtils.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
    }

    @Before
    public void initData() {
        if (isInitialized) {
            return;
        }
        globalTimer = this.registry.timer("test.longData.timer");
        for (long i : SAMPLE_LONG_DATA) {
            globalTimer.update(Duration.ofNanos(i));
        }
        isInitialized = true;
    }

    @Test
    @InSequence(value=1)
    public void testTime() throws Exception {
        Timer timer = this.registry.timer("testTime");
        double beforeStartTime = System.nanoTime();
        Timer.Context context = timer.time();
        double afterStartTime = System.nanoTime();
        Thread.sleep(1000L);
        double beforeStopTime = System.nanoTime();
        double time = context.stop();
        double afterStopTime = System.nanoTime();
        double delta = afterStartTime - beforeStartTime + (afterStopTime - beforeStopTime);
        Assert.assertEquals((double)(beforeStopTime - beforeStartTime), (double)time, (double)delta);
    }

    @Test
    @InSequence(value=2)
    public void testTimerRegistry() throws Exception {
        String timerLongName = "test.longData.timer";
        String timerTimeName = "testTime";
        MetricID timerLongNameMetricID = new MetricID(timerLongName);
        MetricID timerTimeNameMetricID = new MetricID(timerTimeName);
        Timer timerLong = this.registry.getTimer(timerLongNameMetricID);
        Timer timerTime = this.registry.getTimer(timerTimeNameMetricID);
        Assert.assertNotNull((Object)timerLong);
        Assert.assertNotNull((Object)timerTime);
        Snapshot.PercentileValue globalTimerPercentileValue = TimerTest.getPercentileValueAt(globalTimer, 0.5);
        TestUtils.assertEqualsWithTolerance(480.0, globalTimerPercentileValue.getValue());
    }

    @Test
    @InSequence(value=3)
    public void timesCallableInstances() throws Exception {
        Timer timer = this.registry.timer("testCallable");
        String value = (String)timer.time(() -> "one");
        Assert.assertEquals((long)timer.getCount(), (long)1L);
        Assert.assertEquals((Object)value, (Object)"one");
    }

    @Test
    @InSequence(value=4)
    public void timesRunnableInstances() throws Exception {
        Timer timer = this.registry.timer("testRunnable");
        AtomicBoolean called = new AtomicBoolean();
        timer.time(() -> called.set(true));
        Assert.assertEquals((long)timer.getCount(), (long)1L);
        Assert.assertEquals((Object)called.get(), (Object)true);
    }

    @Test
    public void testSnapshotPercentileValuesPresent() throws Exception {
        Snapshot.PercentileValue[] percentileValues = globalTimer.getSnapshot().percentileValues();
        Assert.assertTrue((percentileValues.length == 6 ? 1 : 0) != 0);
        int countDown = 6;
        for (Snapshot.PercentileValue pv : percentileValues) {
            double percentile = pv.getPercentile();
            if (percentile != 0.5 && percentile != 0.75 && percentile != 0.95 && percentile != 0.98 && percentile != 0.99 && percentile != 0.999) continue;
            --countDown;
        }
        Assert.assertTrue((countDown == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSnapshot50thPercentile() throws Exception {
        Snapshot.PercentileValue globalTimerPercentileValue = TimerTest.getPercentileValueAt(globalTimer, 0.5);
        TestUtils.assertEqualsWithTolerance(480.0, globalTimerPercentileValue.getValue());
    }

    @Test
    public void testSnapshot75thPercentile() throws Exception {
        Snapshot.PercentileValue globalTimerPercentileValue = TimerTest.getPercentileValueAt(globalTimer, 0.75);
        TestUtils.assertEqualsWithTolerance(750.0, globalTimerPercentileValue.getValue());
    }

    @Test
    public void testSnapshot95thPercentile() throws Exception {
        Snapshot.PercentileValue globalTimerPercentileValue = TimerTest.getPercentileValueAt(globalTimer, 0.95);
        TestUtils.assertEqualsWithTolerance(960.0, globalTimerPercentileValue.getValue());
    }

    @Test
    public void testSnapshot98thPercentile() throws Exception {
        Snapshot.PercentileValue globalTimerPercentileValue = TimerTest.getPercentileValueAt(globalTimer, 0.98);
        TestUtils.assertEqualsWithTolerance(980.0, globalTimerPercentileValue.getValue());
    }

    @Test
    public void testSnapshot99thPercentile() throws Exception {
        Snapshot.PercentileValue globalTimerPercentileValue = TimerTest.getPercentileValueAt(globalTimer, 0.99);
        TestUtils.assertEqualsWithTolerance(980.0, globalTimerPercentileValue.getValue());
    }

    @Test
    public void testSnapshot999thPercentile() throws Exception {
        Snapshot.PercentileValue globalTimerPercentileValue = TimerTest.getPercentileValueAt(globalTimer, 0.999);
        TestUtils.assertEqualsWithTolerance(990.0, globalTimerPercentileValue.getValue());
    }

    @Test
    public void testSnapshotMax() throws Exception {
        Assert.assertEquals((double)990.0, (double)globalTimer.getSnapshot().getMax(), (double)0.0);
    }

    @Test
    public void testSnapshotMean() throws Exception {
        TestUtils.assertEqualsWithTolerance(506.3, globalTimer.getSnapshot().getMean());
    }

    @Test
    public void testSnapshotSize() throws Exception {
        Assert.assertEquals((long)200L, (long)globalTimer.getSnapshot().size());
    }

    private static Snapshot.PercentileValue getPercentileValueAt(Timer timer, double percentile) {
        Snapshot snapshot = timer.getSnapshot();
        Snapshot.PercentileValue percentileValue = null;
        for (Snapshot.PercentileValue pv : snapshot.percentileValues()) {
            if (pv.getPercentile() != percentile) continue;
            percentileValue = pv;
            break;
        }
        Assert.assertNotNull(percentileValue);
        return percentileValue;
    }
}

