/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.util;

import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TokenUtilsExtraTest {
    @Test(groups={"utils-extra"}, description="Used to generate a 2048 bit length key testing pair")
    public void testKeyPairGeneration2048Length() throws Exception {
        KeyPair keyPair = TokenUtils.generateKeyPair((int)2048);
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        Assert.assertEquals((int)privateKey.getModulus().bitLength(), (int)2048);
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        Assert.assertEquals((int)publicKey.getModulus().bitLength(), (int)2048);
    }

    @Test(groups={"utils-extra"}, description="Used to generate a 1024 bit length key testing pair")
    public void testKeyPairGeneration1024Length() throws Exception {
        KeyPair keyPair = TokenUtils.generateKeyPair((int)1024);
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        Assert.assertEquals((int)privateKey.getModulus().bitLength(), (int)1024);
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        Assert.assertEquals((int)publicKey.getModulus().bitLength(), (int)1024);
    }

    @Test(groups={"utils-extra"}, description="Test initial key validation")
    public void testReadPrivateKey() throws Exception {
        RSAPrivateKey privateKey = TokenUtils.readPrivateKey((String)"/privateKey.pem");
        Assert.assertEquals((int)privateKey.getModulus().bitLength(), (int)2048);
    }

    @Test(groups={"utils-extra"}, description="Test initial key validation")
    public void testReadPublicKey() throws Exception {
        RSAPublicKey publicKey = TokenUtils.readPublicKey((String)"/publicKey.pem");
        Assert.assertEquals((int)publicKey.getModulus().bitLength(), (int)2048);
    }

    @Test(groups={"utils-extra"}, description="Test initial key validation")
    public void testReadJwkPublicKey() throws Exception {
        RSAPublicKey publicKey = (RSAPublicKey)TokenUtils.readJwkPublicKey((String)"/encryptorPublicKey.jwk");
        Assert.assertEquals((int)publicKey.getModulus().bitLength(), (int)2048);
    }

    @Test(groups={"utils-extra"}, description="Test initial key validation")
    public void testReadJwkPrivateKey() throws Exception {
        RSAPrivateKey privateKey = (RSAPrivateKey)TokenUtils.readJwkPrivateKey((String)"/decryptorPrivateKey.jwk");
        Assert.assertEquals((int)privateKey.getModulus().bitLength(), (int)2048);
    }
}

