/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.security.Principal;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.microprofile.jwt.JsonWebToken;

@Path(value="/endp")
@RequestScoped
@RolesAllowed(value={"Tester"})
public class PrincipalInjectionEndpoint {
    @Inject
    private Principal principal;
    @Context
    private SecurityContext context;

    @GET
    @Path(value="/verifyInjectedPrincipal")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedPrincipal() {
        String msg;
        boolean pass = false;
        Principal jwtPrincipal = this.context.getUserPrincipal();
        if (jwtPrincipal == null) {
            msg = "SecurityContext#principal value is null, FAIL";
        } else if (jwtPrincipal instanceof JsonWebToken) {
            msg = "SecurityContext#getUserPrincipal is JsonWebToken, PASS";
            pass = true;
        } else {
            msg = String.format("principal: JsonWebToken != %s", jwtPrincipal.getClass().getCanonicalName());
        }
        if (pass) {
            pass = false;
            if (this.principal == null) {
                msg = "Injected principal value is null, FAIL";
            } else if (!this.principal.getName().equals(jwtPrincipal.getName())) {
                msg = "Injected principal#name != jwtPrincipal#name, FAIL";
            } else {
                msg = msg + "\nInjected Principal#getName matches, PASS";
                pass = true;
            }
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }
}

