/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;

@Path(value="/endp")
@RolesAllowed(value={"Echoer", "Tester"})
@RequestScoped
public class JsonValuejectionEndpoint {
    @Inject
    @Claim(value="raw_token")
    private JsonString rawToken;
    @Inject
    @Claim(value="iss")
    private JsonString issuer;
    @Inject
    @Claim(value="jti")
    private JsonString jti;
    @Inject
    @Claim(value="aud")
    private JsonArray aud;
    @Inject
    @Claim(value="roles")
    private JsonArray roles;
    @Inject
    @Claim(value="iat")
    private JsonNumber issuedAt;
    @Inject
    @Claim(value="auth_time")
    private JsonNumber authTime;
    @Inject
    @Claim(value="customString")
    private JsonString customString;
    @Inject
    @Claim(value="customInteger")
    private JsonNumber customInteger;
    @Inject
    @Claim(value="customDouble")
    private JsonNumber customDouble;
    @Inject
    @Claim(value="customObject")
    private JsonObject customObject;
    @Inject
    @Claim(value="customStringArray")
    private JsonArray customStringArray;
    @Inject
    @Claim(value="customIntegerArray")
    private JsonArray customIntegerArray;
    @Inject
    @Claim(value="customDoubleArray")
    private JsonArray customDoubleArray;

    @GET
    @Path(value="/verifyInjectedIssuer")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedIssuer(@QueryParam(value="iss") String iss) {
        String msg;
        boolean pass = false;
        String issValue = this.issuer.getString();
        if (issValue == null || issValue.length() == 0) {
            msg = Claims.iss.name() + "value is null or empty, FAIL";
        } else if (issValue.equals(iss)) {
            msg = Claims.iss.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iss.name(), issValue, iss);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedRawToken")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedRawToken(@QueryParam(value="raw_token") String rt) {
        String msg;
        boolean pass = false;
        String rawTokenValue = this.rawToken.getString();
        if (rawTokenValue == null || rawTokenValue.length() == 0) {
            msg = Claims.raw_token.name() + "value is null or empty, FAIL";
        } else if (rawTokenValue.equals(rt)) {
            msg = Claims.raw_token.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.raw_token.name(), rawTokenValue, rt);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedJTI")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedJTI(@QueryParam(value="jti") String jwtID) {
        String msg;
        boolean pass = false;
        String jtiValue = this.jti.getString();
        if (jtiValue == null || jtiValue.length() == 0) {
            msg = Claims.jti.name() + "value is null or empty, FAIL";
        } else if (jtiValue.equals(jwtID)) {
            msg = Claims.jti.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.jti.name(), jtiValue, jwtID);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedAudience")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedAudience(@QueryParam(value="aud") String audience) {
        String msg;
        boolean pass = false;
        List audValue = this.aud.getValuesAs(JsonString.class);
        if (audValue == null || audValue.size() == 0) {
            msg = Claims.aud.name() + "value is null or empty, FAIL";
        } else if (((JsonString)audValue.get(0)).getString().equals(audience)) {
            msg = Claims.aud.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.aud.name(), audValue, audience);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedIssuedAt")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedIssuedAt(@QueryParam(value="iat") Long iat) {
        String msg;
        boolean pass = false;
        Long iatValue = this.issuedAt.longValue();
        if (iatValue == null || iatValue.intValue() == 0) {
            msg = Claims.iat.name() + "value is null or empty, FAIL";
        } else if (iatValue.equals(iat)) {
            msg = Claims.iat.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iat.name(), iatValue, iat);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedAuthTime")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedAuthTime(@QueryParam(value="auth_time") Long authTime) {
        String msg;
        boolean pass = false;
        Long authTimeValue = this.authTime.longValue();
        if (authTimeValue == null) {
            msg = Claims.auth_time.name() + " value is null or missing, FAIL";
        } else if (authTimeValue.equals(authTime)) {
            msg = Claims.auth_time.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.auth_time.name(), authTimeValue, authTime);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomString")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedCustomString(@QueryParam(value="value") String value) {
        String msg;
        boolean pass = false;
        String customValue = this.customString.getString();
        if (customValue == null || customValue.length() == 0) {
            msg = "customString value is null or empty, FAIL";
        } else if (customValue.equals(value)) {
            msg = "customString PASS";
            pass = true;
        } else {
            msg = String.format("customString: %s != %s", customValue, value);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomInteger")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedCustomInteger(@QueryParam(value="value") Long value) {
        String msg;
        boolean pass = false;
        Long customValue = this.customInteger.longValue();
        if (customValue.equals(value)) {
            msg = "customInteger PASS";
            pass = true;
        } else {
            msg = String.format("customInteger: %d != %d", customValue, value);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomDouble")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedCustomDouble(@QueryParam(value="value") Double value) {
        String msg;
        boolean pass = false;
        Double customValue = this.customDouble.doubleValue();
        if (Math.abs(customValue - value) < 1.0E-7) {
            msg = "customDouble PASS";
            pass = true;
        } else {
            msg = String.format("customDouble: %s != %.8f", customValue, value);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomStringArray")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedCustomStringArray(@QueryParam(value="value") List<String> array) {
        boolean pass = false;
        HashSet<String> expected = new HashSet<String>();
        for (String value : array) {
            expected.add(value);
        }
        StringBuilder msg = new StringBuilder();
        if (this.customStringArray == null || this.customStringArray.size() == 0) {
            msg.append("customStringArray value is null or empty, FAIL");
        } else if (this.customStringArray.size() != array.size()) {
            msg.append(String.format("customStringArray.size(%d) != expected.size(%d)", this.customStringArray.size(), array.size()));
        } else {
            for (int n = 0; n < this.customStringArray.size(); ++n) {
                JsonString js = this.customStringArray.getJsonString(n);
                if (expected.remove(js.getString())) continue;
                msg.append(String.format("%s not found in expected", js.getString()));
            }
            pass = expected.size() == 0;
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg.toString()).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomIntegerArray")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedCustomIntegerArray(@QueryParam(value="value") List<Long> array) {
        boolean pass = false;
        HashSet<Long> expected = new HashSet<Long>();
        for (Long value : array) {
            expected.add(value);
        }
        StringBuilder msg = new StringBuilder();
        if (this.customIntegerArray == null || this.customIntegerArray.size() == 0) {
            msg.append("customStringArray value is null or empty, FAIL");
        } else if (this.customIntegerArray.size() != array.size()) {
            msg.append(String.format("customStringArray.size(%d) != expected.size(%d)", this.customIntegerArray.size(), array.size()));
        } else {
            for (int n = 0; n < this.customIntegerArray.size(); ++n) {
                Long value = this.customIntegerArray.getJsonNumber(n).longValue();
                if (expected.remove(value)) continue;
                msg.append(String.format("%s not found in expected", value));
            }
            pass = expected.size() == 0;
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg.toString()).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomDoubleArray")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyInjectedCustomDoubleArray(@QueryParam(value="value") List<Double> array) {
        boolean pass = false;
        HashSet<BigDecimal> expected = new HashSet<BigDecimal>();
        for (Double value : array) {
            expected.add(BigDecimal.valueOf(value));
        }
        StringBuilder msg = new StringBuilder();
        if (this.customDoubleArray == null || this.customDoubleArray.size() == 0) {
            msg.append("customStringArray value is null or empty, FAIL");
        } else if (this.customDoubleArray.size() != array.size()) {
            msg.append(String.format("customStringArray.size(%d) != expected.size(%d)", this.customDoubleArray.size(), array.size()));
        } else {
            for (int n = 0; n < this.customDoubleArray.size(); ++n) {
                BigDecimal value = this.customDoubleArray.getJsonNumber(n).bigDecimalValue();
                if (expected.remove(value)) continue;
                msg.append(String.format("%s not found in expected", value));
            }
            pass = expected.size() == 0;
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg.toString()).build();
        return result;
    }
}

