/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.cds;

import com.ibm.oti.shared.SharedClassURLHelper;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.osgi.internal.cds.CDSBundleEntry;
import org.eclipse.osgi.internal.cds.CDSHookConfigurator;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;

public class CDSBundleFile
extends BundleFileWrapper {
    private static final String classFileExt = ".class";
    private final URL url;
    private SharedClassURLHelper urlHelper;
    private boolean primed = false;
    private final Debug debug;

    public CDSBundleFile(BundleFile wrapped, Debug debug) {
        super(wrapped);
        this.debug = debug;
        URL content = null;
        try {
            content = new URL("file", "", wrapped.getBaseFile().getAbsolutePath());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.url = content;
    }

    public CDSBundleFile(BundleFile bundleFile, Debug debug, SharedClassURLHelper urlHelper) {
        this(bundleFile, debug);
        this.urlHelper = urlHelper;
    }

    @Override
    public BundleEntry getEntry(String path) {
        if (!this.primed || !path.endsWith(classFileExt)) {
            return super.getEntry(path);
        }
        byte[] classbytes = this.getClassBytes(path.substring(0, path.length() - classFileExt.length()));
        if (classbytes == null) {
            BundleEntry fromSuper = super.getEntry(path);
            if (fromSuper != null) {
                CDSHookConfigurator.print(this.debug, () -> "Defining class from original bytes: " + this.url + ' ' + fromSuper.getName());
            }
            return fromSuper;
        }
        CDSBundleEntry be = new CDSBundleEntry(path, classbytes, this);
        return be;
    }

    BundleEntry getWrappedEntry(String path) {
        return super.getEntry(path);
    }

    URL getURL() {
        return this.url;
    }

    SharedClassURLHelper getURLHelper() {
        return this.urlHelper;
    }

    void setURLHelper(SharedClassURLHelper urlHelper) {
        this.urlHelper = urlHelper;
        this.primed = false;
    }

    void setPrimed(boolean primed) {
        this.primed = primed;
    }

    private byte[] getClassBytes(String name) {
        if (this.urlHelper == null || this.url == null) {
            return null;
        }
        byte[] results = this.urlHelper.findSharedClass(null, this.url, name);
        CDSHookConfigurator.print(this.debug, () -> results != null ? "Found shared class bytes for: " + name + ' ' + this.url : "No shared class bytes found for: " + name + ' ' + this.url);
        return results;
    }

    public boolean getPrimed() {
        return this.primed;
    }
}

