/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.codeaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4mp.commons.CodeActionResolveData;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4mp.jdt.core.java.corrections.proposal.InsertAnnotationProposal;

public abstract class InsertAnnotationMissingQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(InsertAnnotationMissingQuickFix.class.getName());
    private static final String ANNOTATION_KEY = "annotation";
    private final String[] annotations;
    private final boolean generateOnlyOneCodeAction;

    public InsertAnnotationMissingQuickFix(String ... annotations) {
        this(false, annotations);
    }

    public InsertAnnotationMissingQuickFix(boolean generateOnlyOneCodeAction, String ... annotations) {
        this.generateOnlyOneCodeAction = generateOnlyOneCodeAction;
        this.annotations = annotations;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        this.insertAnnotations(diagnostic, context, codeActions);
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        CodeActionResolveData data = (CodeActionResolveData)toResolve.getData();
        List resolveAnnotations = (List)data.getExtendedDataEntry(ANNOTATION_KEY);
        String[] resolveAnnotationsArray = (String[])resolveAnnotations.toArray(String[]::new);
        String name = InsertAnnotationMissingQuickFix.getLabel(resolveAnnotationsArray);
        ASTNode node = context.getCoveringNode();
        IBinding parentType = this.getBinding(node);
        InsertAnnotationProposal proposal = new InsertAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, resolveAnnotationsArray);
        try {
            WorkspaceEdit we = context.convertToWorkspaceEdit(proposal);
            toResolve.setEdit(we);
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Unable to create workspace edit for code action to insert missing annotation", e);
        }
        return toResolve;
    }

    protected IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof VariableDeclarationFragment) {
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }

    protected String[] getAnnotations() {
        return this.annotations;
    }

    protected void insertAnnotations(Diagnostic diagnostic, JavaCodeActionContext context, List<CodeAction> codeActions) throws CoreException {
        if (this.generateOnlyOneCodeAction) {
            this.insertAnnotation(diagnostic, context, codeActions, this.annotations);
        } else {
            String[] stringArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                String annotation = stringArray[n2];
                this.insertAnnotation(diagnostic, context, codeActions, annotation);
                ++n2;
            }
        }
    }

    protected void insertAnnotation(Diagnostic diagnostic, JavaCodeActionContext context, List<CodeAction> codeActions, String ... annotations) throws CoreException {
        String name = InsertAnnotationMissingQuickFix.getLabel(annotations);
        ExtendedCodeAction codeAction = new ExtendedCodeAction(name);
        codeAction.setRelevance(0);
        codeAction.setDiagnostics(Collections.singletonList(diagnostic));
        codeAction.setKind("quickfix");
        HashMap<String, Object> extendedData = new HashMap<String, Object>();
        extendedData.put(ANNOTATION_KEY, Arrays.asList(annotations));
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), extendedData, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported()));
        codeActions.add(codeAction);
    }

    private static String getLabel(String[] annotations) {
        StringBuilder name = new StringBuilder("Insert ");
        int i = 0;
        while (i < annotations.length) {
            String annotation = annotations[i];
            String annotationName = annotation.substring(annotation.lastIndexOf(46) + 1, annotation.length());
            if (i > 0) {
                name.append(", ");
            }
            name.append("@");
            name.append(annotationName);
            ++i;
        }
        return name.toString();
    }

    protected boolean isGenerateOnlyOneCodeAction() {
        return this.generateOnlyOneCodeAction;
    }
}

