/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.codeaction;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4mp.jdt.core.java.corrections.proposal.InsertAnnotationAttributeProposal;

public class InsertAnnotationAttributeQuickFix
implements IJavaCodeActionParticipant {
    private static final String CODE_ACTION_LABEL = "Insert ''{0}'' attribute";
    private final String attributeName;

    public InsertAnnotationAttributeQuickFix(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ASTNode selectedNode = context.getCoveringNode();
        Annotation annotation = (Annotation)selectedNode.getParent().getParent();
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        InsertAnnotationAttributeQuickFix.insertAnnotationAttribute(annotation, this.attributeName, diagnostic, codeActions, context);
        return codeActions;
    }

    protected static void insertAnnotationAttribute(Annotation annotation, String attributeName, Diagnostic diagnostic, List<CodeAction> codeActions, JavaCodeActionContext context) throws CoreException {
        String name = InsertAnnotationAttributeQuickFix.getLabel(attributeName);
        InsertAnnotationAttributeProposal proposal = new InsertAnnotationAttributeProposal(name, context.getCompilationUnit(), annotation, 0, attributeName);
        CodeAction codeAction = context.convertToCodeAction(proposal, diagnostic);
        if (codeAction != null) {
            codeActions.add(codeAction);
        }
    }

    private static String getLabel(String memberName) {
        return MessageFormat.format(CODE_ACTION_LABEL, memberName);
    }
}

