/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.jaxrs.java;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.jdt.core.java.codelens.IJavaCodeLensParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codelens.JavaCodeLensContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.HttpMethod;
import org.eclipse.lsp4mp.jdt.core.jaxrs.IJaxRsInfoProvider;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsMethodInfo;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.core.java.JavaFeaturesRegistry;

public class JaxRsCodeLensParticipant
implements IJavaCodeLensParticipant {
    private static final Logger LOGGER = Logger.getLogger(JaxRsCodeLensParticipant.class.getName());
    private static final String LOCALHOST = "localhost";
    private static final int PING_TIMEOUT = 2000;

    @Override
    public boolean isAdaptedForCodeLens(JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        MicroProfileJavaCodeLensParams params = context.getParams();
        if (!params.isUrlCodeLensEnabled()) {
            return false;
        }
        ITypeRoot typeRoot = context.getTypeRoot();
        return JaxRsCodeLensParticipant.getProviderForType(typeRoot, monitor) != null;
    }

    @Override
    public void beginCodeLens(JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        JaxRsContext.getJaxRsContext(context).getApplicationPath(monitor);
    }

    @Override
    public List<CodeLens> collectCodeLens(JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        JaxRsContext jaxrsContext = JaxRsContext.getJaxRsContext(context);
        IJDTUtils utils = context.getUtils();
        if (context.getParams().isCheckServerAvailable() && !JaxRsCodeLensParticipant.isServerAvailable(LOCALHOST, jaxrsContext.getServerPort(), 2000)) {
            return Collections.emptyList();
        }
        IJaxRsInfoProvider provider = JaxRsCodeLensParticipant.getProviderForType(typeRoot, monitor);
        if (provider == null) {
            return Collections.emptyList();
        }
        List<JaxRsMethodInfo> infos = provider.getJaxRsMethodInfo(typeRoot, jaxrsContext, utils, monitor);
        MicroProfileJavaCodeLensParams params = context.getParams();
        return infos.stream().map(methodInfo -> {
            try {
                return JaxRsCodeLensParticipant.createCodeLens(methodInfo, params.getOpenURICommand(), utils);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "failed to create codelens for jax-rs method", e);
                return null;
            }
        }).filter(lens -> lens != null).collect(Collectors.toList());
    }

    private static boolean isServerAvailable(String host, int port, int timeout) {
        block12: {
            Throwable throwable = null;
            Object var4_5 = null;
            Socket socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(host, port), timeout);
                if (socket == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            socket.close();
        }
        return true;
    }

    private static IJaxRsInfoProvider getProviderForType(ITypeRoot typeRoot, IProgressMonitor monitor) {
        for (IJaxRsInfoProvider provider : JavaFeaturesRegistry.getInstance().getJaxRsInfoProviders()) {
            if (!provider.canProvideJaxRsMethodInfoForClass(typeRoot, monitor)) continue;
            return provider;
        }
        LOGGER.severe("Attempted to collect JAX-RS info for " + typeRoot.getElementName() + ", but no participant was suitable, despite the fact that an earlier check found a suitable participant");
        return null;
    }

    private static CodeLens createCodeLens(JaxRsMethodInfo methodInfo, String openUriCommandId, IJDTUtils utils) throws JavaModelException {
        CodeLens lens = new CodeLens();
        IMethod method = methodInfo.getJavaMethod();
        IAnnotation[] annotations = method.getAnnotations();
        if (annotations != null && annotations.length > 0) {
            ISourceRange r = annotations[annotations.length - 1].getSourceRange();
            Range range = utils.toRange(method.getOpenable(), r.getOffset(), r.getLength());
            Position codeLensPosition = new Position(range.getEnd().getLine() + 1, range.getEnd().getCharacter());
            range.setStart(codeLensPosition);
            range.setEnd(codeLensPosition);
            lens.setRange(range);
        } else {
            ISourceRange r = method.getNameRange();
            Range range = utils.toRange(method.getOpenable(), r.getOffset(), r.getLength());
            lens.setRange(range);
        }
        lens.setCommand(new Command(methodInfo.getUrl(), JaxRsCodeLensParticipant.isHttpMethodClickable(methodInfo.getHttpMethod()) && openUriCommandId != null ? openUriCommandId : "", Collections.singletonList(methodInfo.getUrl())));
        return lens;
    }

    private static boolean isHttpMethodClickable(HttpMethod httpMethod) {
        return HttpMethod.GET.equals((Object)httpMethod);
    }
}

