/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.SimpleDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.text.edits.CopySourceEdit;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ISourceModifier;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;

public class TextEditConverter
extends TextEditVisitor {
    private static final Logger LOGGER = Logger.getLogger(TextEditConverter.class.getName());
    private final TextEdit source;
    protected ICompilationUnit compilationUnit;
    protected List<org.eclipse.lsp4j.TextEdit> converted;
    private final String uri;
    private final IJDTUtils utils;

    public TextEditConverter(ICompilationUnit unit, TextEdit edit, String uri, IJDTUtils utils) {
        this.source = edit;
        this.converted = new ArrayList<org.eclipse.lsp4j.TextEdit>();
        if (unit == null) {
            throw new IllegalArgumentException("Compilation unit can not be null");
        }
        this.compilationUnit = unit;
        this.uri = uri;
        this.utils = utils;
    }

    public List<org.eclipse.lsp4j.TextEdit> convert() {
        if (this.source != null) {
            this.source.accept((TextEditVisitor)this);
        }
        return this.converted;
    }

    public TextDocumentEdit convertToTextDocumentEdit(int version) {
        VersionedTextDocumentIdentifier identifier = new VersionedTextDocumentIdentifier(Integer.valueOf(version));
        identifier.setUri(this.uri);
        return new TextDocumentEdit(identifier, this.convert());
    }

    public boolean visit(InsertEdit edit) {
        try {
            org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
            te.setNewText(edit.getText());
            te.setRange(this.utils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
            this.converted.add(te);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error converting TextEdits", e);
        }
        return super.visit(edit);
    }

    public boolean visit(CopySourceEdit edit) {
        try {
            if (edit.getTargetEdit() != null) {
                org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
                te.setRange(this.utils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
                Document doc = new Document(this.compilationUnit.getSource());
                edit.apply((IDocument)doc, 2);
                String content = doc.get(edit.getOffset(), edit.getLength());
                if (edit.getSourceModifier() != null) {
                    content = this.applySourceModifier(content, edit.getSourceModifier());
                }
                te.setNewText(content);
                this.converted.add(te);
            }
            return false;
        }
        catch (JavaModelException | BadLocationException | MalformedTreeException e) {
            LOGGER.log(Level.SEVERE, "Error converting TextEdits", e);
            return super.visit(edit);
        }
    }

    public boolean visit(DeleteEdit edit) {
        try {
            org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
            te.setNewText("");
            te.setRange(this.utils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
            this.converted.add(te);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error converting TextEdits", e);
        }
        return super.visit(edit);
    }

    public boolean visit(MultiTextEdit edit) {
        try {
            org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
            te.setRange(this.utils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
            Document doc = new Document(this.compilationUnit.getSource());
            edit.apply((IDocument)doc, 2);
            String content = doc.get(edit.getOffset(), edit.getLength());
            te.setNewText(content);
            this.converted.add(te);
            return false;
        }
        catch (JavaModelException | BadLocationException | MalformedTreeException e) {
            LOGGER.log(Level.SEVERE, "Error converting TextEdits", e);
            return false;
        }
    }

    public boolean visit(ReplaceEdit edit) {
        try {
            org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
            te.setNewText(edit.getText());
            te.setRange(this.utils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
            this.converted.add(te);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error converting TextEdits", e);
        }
        return super.visit(edit);
    }

    public boolean visit(CopyTargetEdit edit) {
        try {
            if (edit.getSourceEdit() != null) {
                org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
                te.setRange(this.utils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
                Document doc = new Document(this.compilationUnit.getSource());
                edit.apply((IDocument)doc, 2);
                String content = doc.get(edit.getSourceEdit().getOffset(), edit.getSourceEdit().getLength());
                if (edit.getSourceEdit().getSourceModifier() != null) {
                    content = this.applySourceModifier(content, edit.getSourceEdit().getSourceModifier());
                }
                te.setNewText(content);
                this.converted.add(te);
            }
            return false;
        }
        catch (CoreException | BadLocationException | MalformedTreeException e) {
            LOGGER.log(Level.SEVERE, "Error converting TextEdits", e);
            return super.visit(edit);
        }
    }

    public boolean visit(MoveSourceEdit edit) {
        try {
            if (edit.getParent() != null && edit.getTargetEdit() != null && edit.getParent().equals((Object)edit.getTargetEdit().getParent())) {
                org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
                te.setNewText("");
                te.setRange(this.utils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
                this.converted.add(te);
                return false;
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error converting TextEdits", e);
        }
        return super.visit(edit);
    }

    public boolean visit(MoveTargetEdit edit) {
        try {
            if (edit.getSourceEdit() != null) {
                org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
                te.setRange(this.utils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
                Document doc = new Document(this.compilationUnit.getSource());
                edit.apply((IDocument)doc, 2);
                String content = doc.get(edit.getSourceEdit().getOffset(), edit.getSourceEdit().getLength());
                if (edit.getSourceEdit().getSourceModifier() != null) {
                    content = this.applySourceModifier(content, edit.getSourceEdit().getSourceModifier());
                }
                te.setNewText(content);
                this.converted.add(te);
                return false;
            }
        }
        catch (CoreException | BadLocationException | MalformedTreeException e) {
            LOGGER.log(Level.SEVERE, "Error converting TextEdits", e);
        }
        return super.visit(edit);
    }

    private String applySourceModifier(String content, ISourceModifier modifier) {
        ReplaceEdit[] replaces;
        if (StringUtils.isBlank((CharSequence)content) || modifier == null) {
            return content;
        }
        SimpleDocument subDocument = new SimpleDocument(content);
        MultiTextEdit newEdit = new MultiTextEdit(0, subDocument.getLength());
        ReplaceEdit[] replaceEditArray = replaces = modifier.getModifications(content);
        int n = replaces.length;
        int n2 = 0;
        while (n2 < n) {
            ReplaceEdit replace = replaceEditArray[n2];
            newEdit.addChild((TextEdit)replace);
            ++n2;
        }
        try {
            newEdit.apply((IDocument)subDocument, 0);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Error applying edit to document", e);
        }
        return subDocument.get();
    }
}

