/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.core.java;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.Signature;

public class Primitive {
    private static final Map<String, Class<?>> wrappers;

    static {
        HashMap<String, Class> types = new HashMap<String, Class>();
        types.put("Long", Integer.class);
        types.put("Short", Short.class);
        types.put("Long", Long.class);
        types.put("Float", Float.class);
        types.put("Double", Double.class);
        types.put("Byte", Byte.class);
        types.put("Character", Character.class);
        types.put("Boolean", Boolean.class);
        wrappers = Collections.unmodifiableMap(types);
    }

    public static boolean isPrimitive(String typeName) {
        return wrappers.containsKey(typeName);
    }

    public static boolean isPrimitive(ILocalVariable variable) {
        String signature = variable.getTypeSignature();
        int signatureKind = Signature.getTypeSignatureKind((String)signature);
        if (signatureKind == 2) {
            return true;
        }
        return Primitive.isPrimitive(Signature.toString((String)signature));
    }
}

