/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodInvocation;

public class ASTUtils {
    public static ASTNode getASTNode(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setKind(8);
        parser.setSource(unit);
        parser.setResolveBindings(true);
        return parser.createAST(null);
    }

    public static List<MethodInvocation> getMethodInvocations(ICompilationUnit unit) {
        ASTNode node = ASTUtils.getASTNode(unit);
        MethodInvocationVisitor visitor = new ASTUtils().new MethodInvocationVisitor();
        node.accept((ASTVisitor)visitor);
        return visitor.getMethodInvocations();
    }

    public class MethodInvocationVisitor
    extends ASTVisitor {
        private final List<MethodInvocation> invocations = new ArrayList<MethodInvocation>();

        public boolean visit(MethodInvocation m) {
            this.invocations.add(m);
            return super.visit(m);
        }

        public List<MethodInvocation> getMethodInvocations() {
            return Collections.unmodifiableList(this.invocations);
        }
    }
}

