/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.internal.ThrowingConsumer;
import org.eclipse.lsp4e.internal.ThrowingPredicate;

public class ArrayUtil {
    public static final byte[] NO_BYTES = new byte[0];
    public static final char[] NO_CHARS = new char[0];
    public static final Object[] NO_OBJECTS = new Object[0];
    public static final String[] NO_STRINGS = new String[0];

    public static <T, X extends Throwable> boolean anyMatch(T @Nullable [] array, ThrowingPredicate<? super T, X> filter) throws X {
        if (array == null || array.length == 0) {
            return false;
        }
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            if (filter.testOrThrow(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @SafeVarargs
    public static <T> ArrayList<T> asArrayList(T ... array) {
        ArrayList list = new ArrayList(array.length);
        Collections.addAll(list, array);
        return list;
    }

    @SafeVarargs
    public static <T> HashSet<T> asHashSet(T ... array) {
        HashSet set = new HashSet();
        Collections.addAll(set, array);
        return set;
    }

    public static <T> boolean contains(T @Nullable [] array, T searchFor) {
        if (array == null || array.length == 0) {
            return false;
        }
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            if (Objects.equals(e, searchFor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T, X extends Throwable> T[] filter(T[] array, ThrowingPredicate<? super T, X> filter) throws X {
        if (array.length == 0) {
            return array;
        }
        ArrayList<T> result = new ArrayList<T>();
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (filter.testOrThrow(item)) {
                result.add(item);
            }
            ++n2;
        }
        Object[] resultArray = (Object[])Array.newInstance(ArrayUtil.getComponentType(array), result.size());
        return result.toArray(resultArray);
    }

    @SafeVarargs
    public static <T> @Nullable T findFirst(T ... array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[0];
    }

    public static <T, X extends Throwable> @Nullable T findFirstMatching(T @Nullable [] array, ThrowingPredicate<T, X> filter) throws X {
        if (array == null || array.length == 0) {
            return null;
        }
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            if (filter.testOrThrow(e)) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static <T, X extends Throwable> void forEach(T @Nullable [] array, @Nullable ThrowingConsumer<T, X> consumer) throws X {
        if (array == null || array.length == 0 || consumer == null) {
            return;
        }
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            consumer.acceptOrThrow(element);
            ++n2;
        }
    }

    public static <T> Class<T> getComponentType(T[] array) {
        return NullSafetyHelper.castNonNull(array.getClass().getComponentType());
    }

    private ArrayUtil() {
    }
}

