/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import com.google.common.base.Functions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.lsp4e.DocumentContentSynchronizer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LoggingStreamConnectionProviderProxy;
import org.eclipse.lsp4e.client.DefaultLanguageClient;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4e.internal.CancellationUtil;
import org.eclipse.lsp4e.internal.FileBufferListenerAdapter;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.internal.SupportedFeatures;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.ClientInfo;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.DocumentFormattingOptions;
import org.eclipse.lsp4j.DocumentOnTypeFormattingOptions;
import org.eclipse.lsp4j.DocumentRangeFormattingOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.SelectionRangeRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WindowClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersChangeEvent;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class LanguageServerWrapper {
    private final IFileBufferListener fileBufferListener = new LSFileBufferListener();
    public final LanguageServersRegistry.LanguageServerDefinition serverDefinition;
    public final @Nullable IProject initialProject;
    protected Map<URI, DocumentContentSynchronizer> connectedDocuments;
    protected final @Nullable IPath initialPath;
    protected final InitializeParams initParams = new InitializeParams();
    private @Nullable CompletableFuture<@Nullable Void> initializeFuture;
    private volatile @Nullable InitializeResult initializeResult;
    private volatile @Nullable ServerCapabilities serverCapabilities;
    private volatile @Nullable ServerInfo serverInfo;
    private final AtomicReference<@Nullable IProgressMonitor> initializeFutureMonitorRef = new AtomicReference();
    private final int initializeFutureNumberOfStages = 7;
    private @Nullable DefaultLanguageClient languageClient;
    private final Timer timer = new Timer("Stop Language Server Task Processor");
    private @Nullable TimerTask stopTimerTask;
    private final ExecutorService dispatcher;
    private final ExecutorService listener;
    private final ExecutorService cleaner;
    private final ExecutorService errorProcessor;
    private LanguageServerContext context = new LanguageServerContext();
    private final Map<String, Runnable> dynamicRegistrations = new HashMap<String, Runnable>();
    private boolean initiallySupportsWorkspaceFolders = false;
    private final IResourceChangeListener workspaceFolderUpdater = new WorkspaceFolderListener();

    public LanguageServerWrapper(IProject project, LanguageServersRegistry.LanguageServerDefinition serverDefinition) {
        this(project, serverDefinition, null);
    }

    public LanguageServerWrapper(LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) {
        this(null, serverDefinition, initialPath);
    }

    private LanguageServerWrapper(@Nullable IProject project, LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) {
        this.initialProject = project;
        this.initialPath = initialPath;
        this.serverDefinition = serverDefinition;
        this.connectedDocuments = new HashMap<URI, DocumentContentSynchronizer>();
        String projectName = project != null && !serverDefinition.isSingleton ? "@" + project.getName() : "";
        String formatPrefix = "LS-" + serverDefinition.id + projectName;
        String dispatcherThreadNameFormat = formatPrefix + "#dispatcher";
        this.dispatcher = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(dispatcherThreadNameFormat).build());
        String listenerThreadNameFormat = formatPrefix + "#listener-%d";
        this.listener = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(listenerThreadNameFormat).build());
        String livenessThreadNameFormat = formatPrefix + "#cleaner";
        this.cleaner = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(livenessThreadNameFormat).build());
        String errorsThreadNameFormat = formatPrefix + "#errorProcessor";
        this.errorProcessor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(errorsThreadNameFormat).build());
    }

    void stopDispatcher() {
        this.dispatcher.shutdownNow();
        this.listener.shutdownNow();
        this.cleaner.shutdown();
        this.errorProcessor.shutdownNow();
    }

    private List<WorkspaceFolder> getRelevantWorkspaceFolders() {
        DefaultLanguageClient languageClient = this.languageClient;
        List<WorkspaceFolder> folders = null;
        if (languageClient != null) {
            try {
                folders = languageClient.workspaceFolders().get(5L, TimeUnit.SECONDS);
            }
            catch (ExecutionException | TimeoutException ex) {
                LanguageServerPlugin.logError(ex);
            }
            catch (InterruptedException ex) {
                LanguageServerPlugin.logError(ex);
                Thread.currentThread().interrupt();
            }
        }
        if (folders == null) {
            folders = LSPEclipseUtils.getWorkspaceFolders();
        }
        return folders;
    }

    public synchronized void start() {
        this.start(false);
    }

    public synchronized void restart() {
        this.start(true);
    }

    private synchronized void start(boolean forceRestart) {
        HashMap<URI, IDocument> filesToReconnect = new HashMap<URI, IDocument>();
        if (this.context.languageServer != null) {
            if (this.isActive() && !forceRestart) {
                return;
            }
            for (Map.Entry<URI, DocumentContentSynchronizer> entry : this.connectedDocuments.entrySet()) {
                filesToReconnect.put(entry.getKey(), entry.getValue().getDocument());
            }
            this.stop();
        }
        if (this.initializeFuture == null || forceRestart) {
            URI rootURI = this.getRootURI();
            Job job = this.createInitializeLanguageServerJob();
            LanguageServerContext workingContext = this.context;
            this.initializeFuture = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                LanguageServerContext languageServerContext2 = workingContext;
                synchronized (languageServerContext2) {
                    this.markInitializationProgress(workingContext);
                    StreamConnectionProvider lspStreamProvider = LoggingStreamConnectionProviderProxy.shouldLog(this.serverDefinition.id) ? (languageServerContext.lspStreamProvider = new LoggingStreamConnectionProviderProxy(this.serverDefinition.createConnectionProvider(), this.serverDefinition.id)) : (languageServerContext.lspStreamProvider = this.serverDefinition.createConnectionProvider());
                    this.initParams.setInitializationOptions(lspStreamProvider.getInitializationOptions(rootURI));
                    try {
                        lspStreamProvider.start();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return null;
            }).thenRun(() -> {
                LanguageServerContext languageServerContext2 = workingContext;
                synchronized (languageServerContext2) {
                    this.markInitializationProgress(workingContext);
                    DefaultLanguageClient languageClient = this.languageClient = this.serverDefinition.createLanguageClient();
                    this.initParams.setProcessId(Integer.valueOf((int)ProcessHandle.current().pid()));
                    if (rootURI != null) {
                        this.initParams.setRootUri(rootURI.toString());
                        this.initParams.setRootPath(rootURI.getPath());
                    }
                    UnaryOperator wrapper = consumer -> message -> {
                        this.logMessage(message);
                        consumer.consume(message);
                        StreamConnectionProvider lspStreamProvider = languageServerContext.lspStreamProvider;
                        LanguageServer languageServer = languageServerContext.languageServer;
                        if (lspStreamProvider != null && this.isActive() && languageServer != null) {
                            lspStreamProvider.handleMessage(message, languageServer, rootURI);
                        }
                    };
                    this.initParams.setWorkspaceFolders(this.getRelevantWorkspaceFolders());
                    StreamConnectionProvider lspStreamProvider = NullSafetyHelper.castNonNull(languageServerContext.lspStreamProvider);
                    Launcher launcher = this.serverDefinition.createLauncherBuilder().setLocalService((Object)languageClient).setRemoteInterface(this.serverDefinition.getServerInterface()).setInput(lspStreamProvider.getInputStream()).setOutput(lspStreamProvider.getOutputStream()).setExecutorService(this.listener).wrapMessages((Function)wrapper).create();
                    LanguageServer languageServer = languageServerContext.languageServer = (LanguageServer)launcher.getRemoteProxy();
                    languageClient.connect(languageServer, this);
                    languageServerContext.launcherFuture = launcher.startListening();
                }
            })).thenCompose(unused -> {
                this.markInitializationProgress(workingContext);
                CompletableFuture<InitializeResult> initFuture = this.initServer(rootURI);
                CompletableFuture.runAsync(() -> {
                    Exception launchException = null;
                    try {
                        NullSafetyHelper.castNonNull(languageServerContext.launcherFuture).get();
                    }
                    catch (InterruptedException e) {
                        LanguageServerPlugin.logError(e);
                        Thread.currentThread().interrupt();
                    }
                    catch (CancellationException | ExecutionException e) {
                        launchException = e;
                    }
                    if (!initFuture.isDone()) {
                        languageServerContext.languageServer = null;
                        initFuture.completeExceptionally(new ExecutionException("Unexpected language server termination: " + this.getFullErrorStream(), launchException));
                    }
                }, this.cleaner);
                return initFuture;
            })).thenAccept(res -> {
                LanguageServerContext languageServerContext2 = workingContext;
                synchronized (languageServerContext2) {
                    this.markInitializationProgress(workingContext);
                    this.initializeResult = res;
                    this.serverCapabilities = res.getCapabilities();
                    this.serverInfo = res.getServerInfo();
                    this.initiallySupportsWorkspaceFolders = LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities);
                }
            })).thenRun(() -> {
                LanguageServerContext languageServerContext2 = workingContext;
                synchronized (languageServerContext2) {
                    this.markInitializationProgress(workingContext);
                    NullSafetyHelper.castNonNull(languageServerContext.languageServer).initialized(new InitializedParams());
                }
            })).thenRun(() -> {
                LanguageServerContext languageServerContext2 = workingContext;
                synchronized (languageServerContext2) {
                    this.markInitializationProgress(workingContext);
                    HashMap toReconnect = filesToReconnect;
                    NullSafetyHelper.castNonNull(this.initializeFuture).thenRunAsync(() -> {
                        this.watchProjects();
                        for (Map.Entry fileToReconnect : toReconnect.entrySet()) {
                            this.connect((URI)fileToReconnect.getKey(), (IDocument)fileToReconnect.getValue());
                        }
                    });
                    FileBuffers.getTextFileBufferManager().addFileBufferListener(this.fileBufferListener);
                    NullSafetyHelper.castNonNull(this.initializeFuture).thenRunAsync(() -> this.processErrorStream(NullSafetyHelper.castNonNull(this.context.lspStreamProvider), l -> LanguageServerPlugin.getDefault().getLog().error(l), e -> {
                        throw new UncheckedIOException((IOException)e);
                    }), this.errorProcessor);
                }
            })).exceptionally(e -> {
                this.shutdown(workingContext);
                Throwable cause = e.getCause();
                if (cause instanceof CancellationException) {
                    CancellationException c = (CancellationException)cause;
                    throw c;
                }
                LanguageServerPlugin.logError(e);
                throw new RuntimeException(LanguageServerWrapper.getRootCauseMessage(e), (Throwable)e);
            });
            if (!this.initializeFuture.isCompletedExceptionally()) {
                job.schedule();
            }
        }
    }

    private void markInitializationProgress(LanguageServerContext context) {
        if (context.cancelled.get()) {
            throw new CancellationException();
        }
        this.advanceInitializeFutureMonitor();
    }

    private void advanceInitializeFutureMonitor() {
        IProgressMonitor initializeFutureMonitor = this.initializeFutureMonitorRef.get();
        if (initializeFutureMonitor != null) {
            if (initializeFutureMonitor.isCanceled()) {
                throw new CancellationException();
            }
            initializeFutureMonitor.worked(1);
        }
    }

    private Job createInitializeLanguageServerJob() {
        return new Job(NLS.bind((String)Messages.initializeLanguageServer_job, (Object)this.serverDefinition.label)){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor initializeFutureMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
                LanguageServerWrapper.this.initializeFutureMonitorRef.set((IProgressMonitor)initializeFutureMonitor);
                CompletableFuture<@Nullable Void> currentInitializeFuture = LanguageServerWrapper.this.initializeFuture;
                try {
                    try {
                        if (currentInitializeFuture != null) {
                            currentInitializeFuture.join();
                        }
                    }
                    catch (CancellationException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        initializeFutureMonitor.done();
                        LanguageServerWrapper.this.initializeFutureMonitorRef.compareAndSet((IProgressMonitor)initializeFutureMonitor, null);
                        return iStatus;
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipse.lsp4e", LanguageServerWrapper.getRootCauseMessage(e), (Throwable)e);
                        initializeFutureMonitor.done();
                        LanguageServerWrapper.this.initializeFutureMonitorRef.compareAndSet((IProgressMonitor)initializeFutureMonitor, null);
                        return status;
                    }
                }
                finally {
                    initializeFutureMonitor.done();
                    LanguageServerWrapper.this.initializeFutureMonitorRef.compareAndSet((IProgressMonitor)initializeFutureMonitor, null);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(@Nullable Object family) {
                return LanguageServerPlugin.FAMILY_INITIALIZE_LANGUAGE_SERVER == family;
            }
        };
    }

    private CompletableFuture<InitializeResult> initServer(@Nullable URI rootURI) {
        IProduct product = Platform.getProduct();
        String name = product != null ? product.getName() : "Eclipse IDE";
        WorkspaceClientCapabilities workspaceClientCapabilities = SupportedFeatures.getWorkspaceClientCapabilities();
        TextDocumentClientCapabilities textDocumentClientCapabilities = SupportedFeatures.getTextDocumentClientCapabilities();
        WindowClientCapabilities windowClientCapabilities = SupportedFeatures.getWindowClientCapabilities();
        this.initParams.setCapabilities(new ClientCapabilities(workspaceClientCapabilities, textDocumentClientCapabilities, windowClientCapabilities, NullSafetyHelper.castNonNull(this.context.lspStreamProvider).getExperimentalFeaturesPOJO()));
        this.initParams.setClientInfo(this.getClientInfo(name));
        this.initParams.setTrace(NullSafetyHelper.castNonNull(this.context.lspStreamProvider).getTrace(rootURI));
        return NullSafetyHelper.castNonNull(this.context.languageServer).initialize(this.initParams);
    }

    private String getFullErrorStream() {
        StringBuilder builder = new StringBuilder();
        this.processErrorStream(NullSafetyHelper.castNonNull(this.context.lspStreamProvider), l -> {
            StringBuilder stringBuilder2 = builder.append(l + "\n");
        }, e -> {
            StringBuilder stringBuilder2 = builder.append("Exception processing error stream: " + String.valueOf(e));
        });
        if (!builder.isEmpty()) {
            return builder.toString();
        }
        return "No errors recorded.";
    }

    private void processErrorStream(StreamConnectionProvider streamProvider, Consumer<String> lineHandler, Consumer<IOException> exceptionHandler) {
        InputStream errorStream = streamProvider.getErrorStream();
        if (errorStream != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));){
                    String line = reader.readLine();
                    while (line != null) {
                        if (!line.isBlank()) {
                            lineHandler.accept(line);
                        }
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                exceptionHandler.accept(e);
            }
        }
    }

    public @Nullable ProcessHandle getProcessHandle() {
        return (ProcessHandle)Adapters.adapt((Object)this.context.lspStreamProvider, ProcessHandle.class);
    }

    private ClientInfo getClientInfo(String name) {
        String pluginVersion = Platform.getBundle((String)"org.eclipse.lsp4e").getVersion().toString();
        ClientInfo clientInfo = new ClientInfo(name, pluginVersion);
        return clientInfo;
    }

    private @Nullable URI getRootURI() {
        IProject project = this.initialProject;
        if (project != null && project.exists()) {
            return LSPEclipseUtils.toUri((IResource)project);
        }
        IPath path = this.initialPath;
        if (path != null) {
            File projectDirectory = path.toFile();
            if (projectDirectory.isFile()) {
                projectDirectory = NullSafetyHelper.castNonNull(projectDirectory.getParentFile());
            }
            return LSPEclipseUtils.toUri(projectDirectory);
        }
        return null;
    }

    private static boolean supportsWorkspaceFolders(@Nullable ServerCapabilities serverCapabilities) {
        return serverCapabilities != null && serverCapabilities.getWorkspace() != null && serverCapabilities.getWorkspace().getWorkspaceFolders() != null && Boolean.TRUE.equals(serverCapabilities.getWorkspace().getWorkspaceFolders().getSupported());
    }

    private void logMessage(Message message) {
        ResponseMessage responseMessage;
        if (message instanceof ResponseMessage && (responseMessage = (ResponseMessage)message).getError() != null && Integer.toString(ResponseErrorCode.RequestCancelled.getValue()).equals(responseMessage.getId())) {
            LanguageServerPlugin.logError(new ResponseErrorException(responseMessage.getError()));
        } else if (LanguageServerPlugin.DEBUG) {
            LanguageServerPlugin.logInfo(message.getClass().getSimpleName() + "\n" + String.valueOf(message));
        }
    }

    public synchronized boolean isActive() {
        Future<?> launcherFuture = this.context.launcherFuture;
        return launcherFuture != null && !launcherFuture.isDone();
    }

    public synchronized boolean startupFailed() {
        return this.initializeFuture != null && this.initializeFuture.isCompletedExceptionally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStopTimerTask() {
        Timer timer = this.timer;
        synchronized (timer) {
            if (this.stopTimerTask != null) {
                this.stopTimerTask.cancel();
                this.stopTimerTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStopTimerTask() {
        Timer timer = this.timer;
        synchronized (timer) {
            if (this.stopTimerTask != null) {
                this.stopTimerTask.cancel();
            }
            this.stopTimerTask = new TimerTask(){

                @Override
                public void run() {
                    LanguageServerWrapper.this.stop();
                }
            };
            this.timer.schedule(this.stopTimerTask, TimeUnit.SECONDS.toMillis(this.serverDefinition.lastDocumentDisconnectedTimeout));
        }
    }

    boolean isWrapperFor(LanguageServer server) {
        return server == this.context.languageServer;
    }

    public synchronized void stop() {
        if (this.initializeFuture != null) {
            this.initializeFuture.cancel(true);
            this.initializeFuture = null;
        }
        LanguageServerContext contextToStop = this.context;
        this.context = new LanguageServerContext();
        contextToStop.cancelled.set(true);
        this.shutdown(contextToStop);
    }

    private void shutdown(LanguageServerContext workingContext) {
        this.removeStopTimerTask();
        if (this.languageClient != null) {
            this.languageClient.dispose();
        }
        this.serverCapabilities = null;
        this.dynamicRegistrations.clear();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceFolderUpdater);
        CompletableFuture.runAsync(workingContext::close);
        while (!this.connectedDocuments.isEmpty()) {
            this.disconnect(this.connectedDocuments.keySet().iterator().next());
        }
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(this.fileBufferListener);
    }

    public @Nullable CompletableFuture<LanguageServerWrapper> connect(@Nullable IDocument document, IFile file) {
        URI uri = LSPEclipseUtils.toUri((IResource)file);
        if (uri != null) {
            return this.connect(uri, document);
        }
        return null;
    }

    public @Nullable CompletableFuture<LanguageServerWrapper> connectDocument(IDocument document) {
        IFile file = LSPEclipseUtils.getFile(document);
        if (file != null && file.exists()) {
            return this.connect(document, file);
        }
        URI uri = LSPEclipseUtils.toUri(document);
        return uri == null ? null : this.connect(uri, document);
    }

    private void watchProjects() {
        if (!this.supportsWorkspaceFolderCapability()) {
            return;
        }
        final LanguageServer currentLS = this.context.languageServer;
        new WorkspaceJob("Setting watch projects on server " + this.serverDefinition.label){

            public IStatus runInWorkspace(@Nullable IProgressMonitor monitor) throws CoreException {
                WorkspaceFoldersChangeEvent wsFolderEvent = new WorkspaceFoldersChangeEvent();
                wsFolderEvent.getAdded().addAll(LanguageServerWrapper.this.getRelevantWorkspaceFolders());
                if (currentLS != null && currentLS == LanguageServerWrapper.this.context.languageServer) {
                    currentLS.getWorkspaceService().didChangeWorkspaceFolders(new DidChangeWorkspaceFoldersParams(wsFolderEvent));
                }
                ResourcesPlugin.getWorkspace().addResourceChangeListener(LanguageServerWrapper.this.workspaceFolderUpdater, 7);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public boolean canOperate(@Nullable IProject project) {
        return Objects.equals(project, this.initialProject) || this.serverDefinition.isSingleton || this.supportsWorkspaceFolderCapability();
    }

    public boolean canOperate(IDocument document) {
        URI documentUri = LSPEclipseUtils.toUri(document);
        if (documentUri == null) {
            return false;
        }
        if (this.isConnectedTo(documentUri)) {
            return true;
        }
        if (this.initialProject == null && this.connectedDocuments.isEmpty()) {
            return true;
        }
        IFile file = LSPEclipseUtils.getFile(document);
        if (file != null && file.exists() && this.canOperate(file.getProject())) {
            return true;
        }
        return this.serverDefinition.isSingleton || this.supportsWorkspaceFolderCapability();
    }

    private boolean supportsWorkspaceFolderCapability() {
        if (this.initializeFuture != null) {
            try {
                this.initializeFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                LanguageServerPlugin.logWarning("Could not get if the workspace folder capability is supported due to timeout after 1 second");
            }
        }
        return this.initiallySupportsWorkspaceFolders || LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities);
    }

    private @Nullable CompletableFuture<LanguageServerWrapper> connect(URI uri, @Nullable IDocument document) {
        this.removeStopTimerTask();
        if (this.connectedDocuments.containsKey(uri)) {
            return CompletableFuture.completedFuture(this);
        }
        this.start();
        if (this.initializeFuture == null) {
            return null;
        }
        if (document == null) {
            IFile docFile = (IFile)LSPEclipseUtils.findResourceFor(uri);
            document = LSPEclipseUtils.getDocument((IResource)docFile);
        }
        if (document == null) {
            return null;
        }
        IDocument theDocument = document;
        return ((CompletableFuture)NullSafetyHelper.castNonNull(this.initializeFuture).thenAcceptAsync(theVoid -> {
            Map<URI, DocumentContentSynchronizer> map = this.connectedDocuments;
            synchronized (map) {
                if (this.connectedDocuments.containsKey(uri)) {
                    return;
                }
                TextDocumentSyncKind syncKind = this.initializeFuture == null ? null : (TextDocumentSyncKind)NullSafetyHelper.castNonNull(this.serverCapabilities).getTextDocumentSync().map((Function)Functions.identity(), TextDocumentSyncOptions::getChange);
                DocumentContentSynchronizer listener = new DocumentContentSynchronizer(this, NullSafetyHelper.castNonNull(this.context.languageServer), theDocument, syncKind);
                theDocument.addPrenotifiedDocumentListener((IDocumentListener)listener);
                this.connectedDocuments.put(uri, listener);
            }
        })).thenApply(theVoid -> this);
    }

    public @Nullable CompletableFuture<@Nullable Void> disconnect(URI uri) {
        DocumentContentSynchronizer documentListener = this.connectedDocuments.remove(uri);
        CompletableFuture<@Nullable Void> documentClosedFuture = null;
        if (documentListener != null) {
            documentListener.getDocument().removePrenotifiedDocumentListener((IDocumentListener)documentListener);
            documentClosedFuture = documentListener.documentClosed();
            LanguageServerWrapper.disconnectTextFileBuffer(uri);
        }
        if (this.connectedDocuments.isEmpty()) {
            if (this.serverDefinition.lastDocumentDisconnectedTimeout != 0) {
                this.startStopTimerTask();
            } else {
                this.stop();
            }
        }
        return documentClosedFuture;
    }

    private static void disconnectTextFileBuffer(URI uri) {
        IPath location = URIUtil.toPath((URI)uri);
        if (location == null) {
            return;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
        if (file != null) {
            LSPEclipseUtils.disconnectFromFileBuffer(file.getFullPath());
        }
    }

    public void disconnectContentType(IContentType contentType) {
        ArrayList<URI> urisToDisconnect = new ArrayList<URI>();
        for (URI uri : this.connectedDocuments.keySet()) {
            IFile file = ArrayUtil.findFirst(ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri));
            if (file == null) continue;
            if (!LSPEclipseUtils.getFileContentTypes(file).stream().anyMatch(contentType::equals)) continue;
            urisToDisconnect.add(uri);
        }
        for (URI uri : urisToDisconnect) {
            this.disconnect(uri);
        }
    }

    public boolean isConnectedTo(URI uri) {
        return this.connectedDocuments.containsKey(uri);
    }

    protected @Nullable LanguageServer getServer() {
        CompletableFuture<LanguageServer> languageServerFuture = this.getInitializedServer();
        if (Display.getCurrent() != null) {
            return this.context.languageServer;
        }
        return languageServerFuture.join();
    }

    protected CompletableFuture<LanguageServer> getInitializedServer() {
        this.start();
        CompletableFuture<@Nullable Void> currentInitializeFuture = this.initializeFuture;
        if (currentInitializeFuture != null && !currentInitializeFuture.isDone()) {
            return currentInitializeFuture.thenApply(r -> NullSafetyHelper.castNonNull(this.context.languageServer));
        }
        return CompletableFuture.completedFuture(this.context.languageServer);
    }

    public void sendNotification(Consumer<LanguageServer> fn) {
        this.getInitializedServer().thenAcceptAsync((Consumer)fn, (Executor)this.dispatcher);
    }

    public <T> CompletableFuture<T> execute(Function<LanguageServer, ? extends CompletableFuture<T>> fn) {
        CompletableFuture lsRequest = this.executeImpl(fn);
        CompletionStage future = lsRequest.thenApplyAsync(Function.identity());
        ((CompletableFuture)future).exceptionally(t -> {
            if (t instanceof CancellationException) {
                lsRequest.cancel(true);
            }
            return null;
        });
        return future;
    }

    <T> CompletableFuture<T> executeImpl(Function<LanguageServer, ? extends CompletableFuture<T>> fn) {
        AtomicReference request = new AtomicReference();
        Function<LanguageServer, CompletableFuture> cancelWrapper = ls -> {
            CompletableFuture res = (CompletableFuture)fn.apply((LanguageServer)ls);
            request.set(res);
            return res;
        };
        CompletionStage res = this.getInitializedServer().thenComposeAsync(cancelWrapper, (Executor)this.dispatcher);
        ((CompletableFuture)res).exceptionally(e -> {
            CompletableFuture stage;
            if (e instanceof CancellationException && (stage = (CompletableFuture)request.get()) != null) {
                stage.cancel(false);
            }
            return null;
        });
        return res;
    }

    public CompletableFuture<InitializeResult> getInitializeResultAsync() {
        return this.getInitializedServer().thenCompose(ls -> {
            InitializeResult initializeResult = this.initializeResult;
            if (initializeResult == null) {
                return CompletableFuture.failedFuture(new IllegalStateException("initializeResult unexpectedly null after initialization"));
            }
            return CompletableFuture.completedFuture(initializeResult);
        });
    }

    public @Nullable ServerCapabilities getServerCapabilities() {
        try {
            this.getInitializedServer().get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logError("LanguageServer not initialized within 10s", e);
        }
        catch (CancellationException | ExecutionException e) {
            if (!CancellationUtil.isRequestCancelledException(e)) {
                LanguageServerPlugin.logError(e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LanguageServerPlugin.logError(e);
        }
        return this.serverCapabilities;
    }

    public CompletableFuture<ServerCapabilities> getServerCapabilitiesAsync() {
        return this.getInitializedServer().thenCompose(ls -> {
            ServerCapabilities serverCapabilities = this.serverCapabilities;
            if (serverCapabilities == null) {
                return CompletableFuture.failedFuture(new IllegalStateException("serverCapabilities unexpectedly null after initialization"));
            }
            return CompletableFuture.completedFuture(serverCapabilities);
        });
    }

    public CompletableFuture<@Nullable ServerInfo> getServerInfoAsync() {
        return this.getInitializedServer().thenApply(ls -> this.serverInfo);
    }

    public @Nullable String getLanguageId(IContentType[] contentTypes) {
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            String languageId = this.serverDefinition.languageIdMappings.get(contentType);
            if (languageId != null) {
                return languageId;
            }
            ++n2;
        }
        return null;
    }

    public void registerCapability(RegistrationParams params) {
        ServerCapabilities serverCapabilities = this.serverCapabilities;
        Assert.isNotNull((Object)serverCapabilities, (String)"Dynamic capability registration failed! Server not yet initialized?");
        params.getRegistrations().forEach(reg -> {
            switch (reg.getMethod()) {
                case "workspace/didChangeWorkspaceFolders": {
                    if (this.initiallySupportsWorkspaceFolders) break;
                    if (LanguageServerWrapper.supportsWorkspaceFolders(serverCapabilities)) {
                        LanguageServerPlugin.logWarning("Dynamic registration of 'workspace/didChangeWorkspaceFolders' ignored. It was already enabled before");
                        break;
                    }
                    this.addRegistration((Registration)reg, () -> this.setWorkspaceFoldersEnablement(false));
                    this.setWorkspaceFoldersEnablement(true);
                    break;
                }
                case "workspace/executeCommand": {
                    try {
                        ExecuteCommandOptions executeCommandOptions = NullSafetyHelper.castNonNull((ExecuteCommandOptions)new Gson().fromJson((JsonElement)((JsonObject)reg.getRegisterOptions()), ExecuteCommandOptions.class));
                        List newCommands = executeCommandOptions.getCommands();
                        if (newCommands.isEmpty()) break;
                        this.addRegistration((Registration)reg, () -> this.unregisterCommands(newCommands));
                        this.registerCommands(newCommands);
                    }
                    catch (Exception ex) {
                        LanguageServerPlugin.logError(ex);
                    }
                    break;
                }
                case "textDocument/formatting": {
                    Either documentFormattingProvider = serverCapabilities.getDocumentFormattingProvider();
                    if (documentFormattingProvider == null || documentFormattingProvider.isLeft()) {
                        serverCapabilities.setDocumentFormattingProvider(Boolean.TRUE);
                    } else {
                        serverCapabilities.setDocumentFormattingProvider((DocumentFormattingOptions)documentFormattingProvider.getRight());
                    }
                    this.addRegistration((Registration)reg, () -> serverCapabilities.setDocumentFormattingProvider(documentFormattingProvider));
                    break;
                }
                case "textDocument/rangeFormatting": {
                    Either documentRangeFormattingProvider = serverCapabilities.getDocumentRangeFormattingProvider();
                    if (documentRangeFormattingProvider == null || documentRangeFormattingProvider.isLeft()) {
                        serverCapabilities.setDocumentRangeFormattingProvider(Boolean.TRUE);
                    } else {
                        serverCapabilities.setDocumentRangeFormattingProvider((DocumentRangeFormattingOptions)documentRangeFormattingProvider.getRight());
                    }
                    this.addRegistration((Registration)reg, () -> serverCapabilities.setDocumentRangeFormattingProvider(documentRangeFormattingProvider));
                    break;
                }
                case "textDocument/codeAction": {
                    Either beforeRegistration = serverCapabilities.getCodeActionProvider();
                    serverCapabilities.setCodeActionProvider(Boolean.TRUE);
                    this.addRegistration((Registration)reg, () -> serverCapabilities.setCodeActionProvider(beforeRegistration));
                    break;
                }
                case "textDocument/completion": {
                    CompletionOptions previous = serverCapabilities.getCompletionProvider();
                    try {
                        CompletionOptions completionOpts = (CompletionOptions)new Gson().fromJson((JsonElement)((JsonObject)reg.getRegisterOptions()), CompletionOptions.class);
                        serverCapabilities.setCompletionProvider(completionOpts);
                        this.addRegistration((Registration)reg, () -> serverCapabilities.setCompletionProvider(previous));
                    }
                    catch (Exception ex) {
                        LanguageServerPlugin.logError(ex);
                    }
                    break;
                }
                case "workspace/symbol": {
                    Either workspaceSymbolBeforeRegistration = serverCapabilities.getWorkspaceSymbolProvider();
                    serverCapabilities.setWorkspaceSymbolProvider(Boolean.TRUE);
                    this.addRegistration((Registration)reg, () -> serverCapabilities.setWorkspaceSymbolProvider(workspaceSymbolBeforeRegistration));
                    break;
                }
                case "textDocument/selectionRange": {
                    Either selectionRangeProvider = serverCapabilities.getSelectionRangeProvider();
                    if (selectionRangeProvider == null || selectionRangeProvider.isLeft()) {
                        serverCapabilities.setSelectionRangeProvider(Boolean.TRUE);
                    } else {
                        serverCapabilities.setSelectionRangeProvider((SelectionRangeRegistrationOptions)selectionRangeProvider.getRight());
                    }
                    this.addRegistration((Registration)reg, () -> serverCapabilities.setSelectionRangeProvider(selectionRangeProvider));
                    break;
                }
                case "textDocument/typeHierarchy": {
                    Either typeHierarchyBeforeRegistration = serverCapabilities.getTypeHierarchyProvider();
                    serverCapabilities.setTypeHierarchyProvider(Boolean.TRUE);
                    this.addRegistration((Registration)reg, () -> serverCapabilities.setTypeHierarchyProvider(typeHierarchyBeforeRegistration));
                    break;
                }
                case "textDocument/onTypeFormatting": {
                    DocumentOnTypeFormattingOptions opts;
                    DocumentOnTypeFormattingOptions onTypeFormattingBeforeRegistration = serverCapabilities.getDocumentOnTypeFormattingProvider();
                    Object object = reg.getRegisterOptions();
                    serverCapabilities.setDocumentOnTypeFormattingProvider(object instanceof DocumentOnTypeFormattingOptions ? (opts = (DocumentOnTypeFormattingOptions)object) : null);
                    this.addRegistration((Registration)reg, () -> serverCapabilities.setDocumentOnTypeFormattingProvider(onTypeFormattingBeforeRegistration));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRegistration(Registration reg, Runnable unregistrationHandler) {
        String regId = reg.getId();
        Map<String, Runnable> map = this.dynamicRegistrations;
        synchronized (map) {
            if (this.dynamicRegistrations.containsKey(regId)) {
                ILog.get().warn("A registration with id " + regId + " already exists. Unregistering may not fully work in this case.\n");
            } else {
                this.dynamicRegistrations.put(regId, unregistrationHandler);
            }
        }
    }

    synchronized void setWorkspaceFoldersEnablement(boolean enable) {
        WorkspaceFoldersOptions folders;
        WorkspaceServerCapabilities workspace;
        if (enable == this.supportsWorkspaceFolderCapability()) {
            return;
        }
        ServerCapabilities serverCapabilities = this.serverCapabilities;
        if (serverCapabilities == null) {
            serverCapabilities = this.serverCapabilities = new ServerCapabilities();
        }
        if ((workspace = serverCapabilities.getWorkspace()) == null) {
            workspace = new WorkspaceServerCapabilities();
            serverCapabilities.setWorkspace(workspace);
        }
        if ((folders = workspace.getWorkspaceFolders()) == null) {
            folders = new WorkspaceFoldersOptions();
            workspace.setWorkspaceFolders(folders);
        }
        folders.setSupported(Boolean.valueOf(enable));
        if (enable) {
            this.watchProjects();
        }
    }

    synchronized void registerCommands(List<String> newCommands) {
        ServerCapabilities caps = this.getServerCapabilities();
        if (caps != null) {
            ExecuteCommandOptions commandProvider = caps.getExecuteCommandProvider();
            if (commandProvider == null) {
                commandProvider = new ExecuteCommandOptions(new ArrayList());
                caps.setExecuteCommandProvider(commandProvider);
            }
            List existingCommands = commandProvider.getCommands();
            for (String newCmd : newCommands) {
                Assert.isLegal((!existingCommands.contains(newCmd) ? 1 : 0) != 0, (String)("Command already registered '" + newCmd + "'"));
                existingCommands.add(newCmd);
            }
        } else {
            throw new IllegalStateException("Dynamic command registration failed! Server not yet initialized?");
        }
    }

    public void unregisterCapability(UnregistrationParams params) {
        params.getUnregisterations().forEach(reg -> {
            Runnable unregistrator;
            String id = reg.getId();
            Map<String, Runnable> map = this.dynamicRegistrations;
            synchronized (map) {
                unregistrator = this.dynamicRegistrations.get(id);
                this.dynamicRegistrations.remove(id);
            }
            if (unregistrator != null) {
                unregistrator.run();
            }
        });
    }

    void unregisterCommands(List<String> cmds) {
        ExecuteCommandOptions commandProvider;
        ServerCapabilities caps = this.getServerCapabilities();
        if (caps != null && (commandProvider = caps.getExecuteCommandProvider()) != null) {
            List existingCommands = commandProvider.getCommands();
            existingCommands.removeAll(cmds);
        }
    }

    public int getTextDocumentVersion(URI uri) {
        DocumentContentSynchronizer documentContentSynchronizer = this.connectedDocuments.get(uri);
        if (documentContentSynchronizer != null) {
            return documentContentSynchronizer.getVersion();
        }
        return -1;
    }

    public String toString() {
        ProcessHandle ph = this.getProcessHandle();
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " [serverId=" + this.serverDefinition.id + ", initialPath=" + String.valueOf(this.initialPath) + ", initialProject=" + String.valueOf(this.initialProject) + ", isActive=" + this.isActive() + ", pid=" + String.valueOf(ph == null ? null : Long.valueOf(ph.pid())) + "]";
    }

    private static String getRootCauseMessage(Throwable throwable) {
        Throwable cause = throwable;
        while (cause != null && cause.getCause() != null && cause.getCause() != cause) {
            cause = cause.getCause();
        }
        if (cause == null) {
            return LanguageServerWrapper.getThrowableMessage(throwable);
        }
        String message = cause.getMessage();
        return message != null ? message : LanguageServerWrapper.getThrowableMessage(throwable);
    }

    private static String getThrowableMessage(Throwable throwable) {
        String message = throwable.getMessage();
        return message != null ? message : "No exception message available: " + throwable.getClass().getSimpleName();
    }

    private final class LSFileBufferListener
    extends FileBufferListenerAdapter {
        private LSFileBufferListener() {
        }

        @Override
        public void bufferDisposed(IFileBuffer buffer) {
            URI uri = LSPEclipseUtils.toUri(buffer);
            if (uri != null) {
                LanguageServerWrapper.this.disconnect(uri);
            }
        }

        @Override
        public void stateChanging(IFileBuffer buffer) {
            DocumentContentSynchronizer documentListener;
            if (buffer.isDirty() && (documentListener = LanguageServerWrapper.this.connectedDocuments.get(LSPEclipseUtils.toUri(buffer))) != null) {
                documentListener.documentAboutToBeSaved();
            }
        }

        @Override
        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            if (isDirty) {
                return;
            }
            DocumentContentSynchronizer documentListener = LanguageServerWrapper.this.connectedDocuments.get(LSPEclipseUtils.toUri(buffer));
            if (documentListener != null) {
                documentListener.documentSaved(buffer);
            }
        }

        @Override
        public void underlyingFileMoved(IFileBuffer buffer, IPath newPath) {
            URI oldUri = LSPEclipseUtils.toUri(buffer);
            if (oldUri == null) {
                return;
            }
            DocumentContentSynchronizer documentListener = LanguageServerWrapper.this.connectedDocuments.get(oldUri);
            if (documentListener == null) {
                return;
            }
            LSPEclipseUtils.disconnectFromFileBuffer(buffer.getLocation());
        }

        @Override
        public void underlyingFileDeleted(IFileBuffer buffer) {
            URI oldUri = LSPEclipseUtils.toUri(buffer);
            if (oldUri == null) {
                return;
            }
            if (!LanguageServerWrapper.this.isConnectedTo(oldUri)) {
                return;
            }
            LSPEclipseUtils.disconnectFromFileBuffer(buffer.getLocation());
            LanguageServerWrapper.this.disconnect(oldUri);
        }
    }

    private static class LanguageServerContext {
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        @Nullable Future<?> launcherFuture;
        @Nullable StreamConnectionProvider lspStreamProvider;
        @Nullable LanguageServer languageServer;

        private LanguageServerContext() {
        }

        synchronized void close() {
            if (this.languageServer != null) {
                CompletableFuture shutdown = this.languageServer.shutdown();
                try {
                    shutdown.get(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (TimeoutException ex) {
                    LanguageServerPlugin.logWarning("The server did not stop after 5 seconds");
                }
                catch (Exception ex) {
                    LanguageServerPlugin.logError(ex.getClass().getSimpleName() + " occurred during shutdown of " + String.valueOf(this.languageServer), ex);
                }
            }
            if (this.launcherFuture != null) {
                this.launcherFuture.cancel(true);
            }
            if (this.languageServer != null) {
                this.languageServer.exit();
            }
            if (this.lspStreamProvider != null) {
                this.lspStreamProvider.stop();
            }
        }
    }

    private final class WorkspaceFolderListener
    implements IResourceChangeListener {
        private WorkspaceFolderListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            WorkspaceFoldersChangeEvent workspaceFolderEvent = this.toWorkspaceFolderEvent(event);
            if (workspaceFolderEvent == null || workspaceFolderEvent.getAdded().isEmpty() && workspaceFolderEvent.getRemoved().isEmpty()) {
                return;
            }
            LanguageServer currentServer = LanguageServerWrapper.this.context.languageServer;
            if (currentServer != null) {
                currentServer.getWorkspaceService().didChangeWorkspaceFolders(new DidChangeWorkspaceFoldersParams(workspaceFolderEvent));
            }
        }

        private @Nullable WorkspaceFoldersChangeEvent toWorkspaceFolderEvent(IResourceChangeEvent e) {
            if (!(this.isPostChangeEvent(e) || this.isPreDeletEvent(e) || this.isPreCloseEvent(e))) {
                return null;
            }
            WorkspaceFoldersChangeEvent wsFolderEvent = new WorkspaceFoldersChangeEvent();
            if (this.isPreDeletEvent(e) || this.isPreCloseEvent(e)) {
                IResource resource = e.getResource();
                if (resource instanceof IProject) {
                    IProject project = (IProject)resource;
                    wsFolderEvent.getRemoved().add(LSPEclipseUtils.toWorkspaceFolder(project));
                    return wsFolderEvent;
                }
                return null;
            }
            List<WorkspaceFolder> relevantFolders = LanguageServerWrapper.this.getRelevantWorkspaceFolders();
            try {
                e.getDelta().accept(delta -> {
                    IResource iResource = delta.getResource();
                    if (iResource instanceof IProject) {
                        IProject project = (IProject)iResource;
                        WorkspaceFolder wsFolder = LSPEclipseUtils.toWorkspaceFolder(project);
                        if (relevantFolders.contains(wsFolder) && (this.isAddEvent(delta) || this.isProjectOpenCloseEvent(delta)) && project.isAccessible() && this.isValid(wsFolder)) {
                            wsFolderEvent.getAdded().add(wsFolder);
                        } else if ((this.isRemoveEvent(delta) || this.isProjectOpenCloseEvent(delta)) && !project.isAccessible() && this.isValid(wsFolder)) {
                            wsFolderEvent.getRemoved().add(wsFolder);
                        }
                    }
                    return delta.getResource().getType() == 8;
                });
            }
            catch (CoreException ex) {
                LanguageServerPlugin.logError(ex);
            }
            if (wsFolderEvent.getAdded().isEmpty() && wsFolderEvent.getRemoved().isEmpty()) {
                return null;
            }
            return wsFolderEvent;
        }

        private boolean isPostChangeEvent(IResourceChangeEvent e) {
            return e.getType() == 1;
        }

        private boolean isPreDeletEvent(IResourceChangeEvent e) {
            return e.getType() == 4;
        }

        private boolean isPreCloseEvent(IResourceChangeEvent e) {
            return e.getType() == 2;
        }

        private boolean isAddEvent(IResourceDelta delta) {
            return delta.getKind() == 1;
        }

        private boolean isRemoveEvent(IResourceDelta delta) {
            return delta.getKind() == 2;
        }

        private boolean isProjectOpenCloseEvent(IResourceDelta delta) {
            return delta.getKind() == 4 && (delta.getFlags() & 0x4000) == 16384;
        }

        private boolean isValid(@Nullable WorkspaceFolder wsFolder) {
            return wsFolder != null && wsFolder.getUri() != null && !wsFolder.getUri().isEmpty();
        }
    }
}

