/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.internal.Pair;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.MockConnectionProvider;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockTextDocumentService;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class LanguageServersTest
extends AbstractTestWithProject {
    private final Predicate<ServerCapabilities> MATCH_ALL = sc -> true;

    @Test
    public void testCollectAll() throws Exception {
        final AtomicInteger hoverCount = new AtomicInteger();
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)("HoverContent" + hoverCount.incrementAndGet()))), new Range(new Position(0, 0), new Position(0, 10)));
                return CompletableFuture.completedFuture(hoverResponse);
            }
        });
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        CompletableFuture result = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).collectAll(ls -> ls.getTextDocumentService().hover(params).thenApply(h -> (String)((Either)((List)h.getContents().getLeft()).get(0)).getLeft()));
        List hovers = (List)result.join();
        Assert.assertTrue((boolean)hovers.contains("HoverContent1"));
        Assert.assertTrue((boolean)hovers.contains("HoverContent2"));
    }

    @Test
    public void testCollectAllExcludesNulls() throws Exception {
        final AtomicInteger hoverCount = new AtomicInteger();
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)("HoverContent" + hoverCount.incrementAndGet()))), new Range(new Position(0, 0), new Position(0, 10)));
                return CompletableFuture.completedFuture(hoverCount.get() == 1 ? hoverResponse : null);
            }
        });
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        CompletableFuture result = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).collectAll(ls -> ls.getTextDocumentService().hover(params).thenApply(h -> h == null ? null : (String)((Either)((List)h.getContents().getLeft()).get(0)).getLeft()));
        List hovers = (List)result.join();
        Assert.assertTrue((boolean)hovers.contains("HoverContent1"));
        Assert.assertFalse((boolean)hovers.contains(null));
    }

    @Test
    public void testComputeAll() throws Exception {
        final AtomicInteger hoverCount = new AtomicInteger();
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)("HoverContent" + hoverCount.incrementAndGet()))), new Range(new Position(0, 0), new Position(0, 10)));
                int currentCount = hoverCount.get();
                return CompletableFuture.completedFuture(hoverResponse).thenApplyAsync(t -> {
                    try {
                        Thread.sleep(currentCount * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return t;
                });
            }
        });
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        List result = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).computeAll(ls -> ls.getTextDocumentService().hover(params).thenApply(h -> (String)((Either)((List)h.getContents().getLeft()).get(0)).getLeft()));
        Assert.assertEquals((String)"Should have had two responses", (long)2L, (long)result.size());
        Object first = CompletableFuture.anyOf((CompletableFuture)result.get(0), (CompletableFuture)result.get(1)).join();
        Assert.assertEquals((String)"HoverContent1 should have returned first, independently", (Object)"HoverContent1", (Object)first);
        List<String> hovers = result.stream().map(CompletableFuture::join).toList();
        Assert.assertTrue((boolean)hovers.contains("HoverContent1"));
        Assert.assertTrue((boolean)hovers.contains("HoverContent2"));
    }

    @Test
    public void testCollectAllUserCannotBlockListener() throws Exception {
        Assume.assumeTrue((String)"Test skipped as common thread pool does not have multiple executors", (ForkJoinPool.commonPool().getParallelism() >= 2 ? 1 : 0) != 0);
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        long startTime = System.currentTimeMillis();
        CompletionStage resultThreadFuture = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).collectAll(ls -> ls.getTextDocumentService().hover(params)).thenApply(hoverResult -> {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return Thread.currentThread().getName();
        });
        CompletableFuture fastHover = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).collectAll(ls -> ls.getTextDocumentService().hover(params));
        fastHover.join();
        long secondResponseTime = System.currentTimeMillis() - startTime;
        String resultThread = (String)((CompletableFuture)resultThreadFuture).join();
        Assert.assertTrue((String)("Second hover response should not have been blocked by the first but took " + secondResponseTime + " ms"), (secondResponseTime < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Result should not have run on an LS listener thread but ran on " + resultThread), (!resultThread.startsWith("LS") ? 1 : 0) != 0);
    }

    @Test
    public void testComputeFirst() throws Exception {
        final AtomicInteger hoverCount = new AtomicInteger();
        final Vector<CompletableFuture> internalResults = new Vector<CompletableFuture>();
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)("HoverContent" + hoverCount.incrementAndGet()))), new Range(new Position(0, 0), new Position(0, 10)));
                int currentCount = hoverCount.get();
                CompletionStage result = CompletableFuture.completedFuture(hoverResponse).thenApplyAsync(t -> {
                    try {
                        Thread.sleep(currentCount * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return t;
                });
                internalResults.add(result);
                return result;
            }
        });
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        CompletableFuture response = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).computeFirst(ls -> ls.getTextDocumentService().hover(params).thenApply(h -> (String)((Either)((List)h.getContents().getLeft()).get(0)).getLeft()));
        Optional result = (Optional)response.join();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((String)"HoverContent1 should have arrived first", (Object)"HoverContent1", result.get());
        internalResults.forEach(CompletableFuture::join);
    }

    @Test
    public void testComputeFirstSkipsEmptyResults() throws Exception {
        final AtomicInteger hoverCount = new AtomicInteger();
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)("HoverContent" + hoverCount.incrementAndGet()))), new Range(new Position(0, 0), new Position(0, 10)));
                if (hoverCount.get() == 1) {
                    return CompletableFuture.completedFuture(null);
                }
                return CompletableFuture.completedFuture(hoverResponse).thenApplyAsync(t -> {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return t;
                });
            }
        });
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        CompletableFuture response = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).computeFirst(ls -> ls.getTextDocumentService().hover(params).thenApply(h -> h == null ? null : (String)((Either)((List)h.getContents().getLeft()).get(0)).getLeft()));
        Optional result = (Optional)response.join();
        Assert.assertTrue((String)"Should have returned a result", (boolean)result.isPresent());
        Assert.assertEquals((String)"HoverContent2 should have been the result", (Object)"HoverContent2", result.get());
    }

    @Test
    public void testComputeFirstReturnsEmptyOptionalIfNoResult() throws Exception {
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                return CompletableFuture.completedFuture(null);
            }
        });
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        CompletableFuture response = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).computeFirst(ls -> ls.getTextDocumentService().hover(params).thenApply(h -> h == null ? null : (String)((Either)((List)h.getContents().getLeft()).get(0)).getLeft()));
        Optional result = (Optional)response.join();
        Assert.assertTrue((String)"Should not have returned a result", (boolean)result.isEmpty());
    }

    @Test
    public void testComputeFirstTreatsEmptyListAsNull() throws Exception {
        final AtomicInteger hoverCount = new AtomicInteger();
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)("HoverContent" + hoverCount.incrementAndGet()))), new Range(new Position(0, 0), new Position(0, 10)));
                if (hoverCount.get() == 1) {
                    return CompletableFuture.completedFuture(null);
                }
                return CompletableFuture.completedFuture(hoverResponse).thenApplyAsync(t -> {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return t;
                });
            }
        });
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        CompletableFuture response = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).computeFirst(ls -> ls.getTextDocumentService().hover(params).thenApply(h -> h == null ? Collections.emptyList() : List.of((String)((Either)((List)h.getContents().getLeft()).get(0)).getLeft())));
        Optional result = (Optional)response.join();
        Assert.assertTrue((String)"Should have returned a result", (boolean)result.isPresent());
        Assert.assertEquals((String)"HoverContent2 should have been the result", (Object)"HoverContent2", ((List)result.get()).get(0));
    }

    @Test
    public void editInterleavingTortureTest() throws Exception {
        final Vector<Integer> tooEarlyHover = new Vector<Integer>();
        final Vector<Integer> tooLateHover = new Vector<Integer>();
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){
            int changeVersion;
            {
                super($anonymous0);
                this.changeVersion = 0;
            }

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
                ++this.changeVersion;
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                int targetVersionForRequest = position.getPosition().getCharacter();
                if (targetVersionForRequest < this.changeVersion) {
                    tooLateHover.add(targetVersionForRequest);
                } else if (targetVersionForRequest > this.changeVersion) {
                    tooEarlyHover.add(targetVersionForRequest);
                }
                return super.hover(position);
            }
        });
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        CompletableFuture<Object> initial = CompletableFuture.completedFuture(null);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        StyledText text = viewer.getTextWidget();
        Thread.sleep(1000L);
        int i2 = 0;
        while (i2 < 5000) {
            int current = i2 + 1;
            text.append(i2 + "\n");
            HoverParams params = new HoverParams();
            Position position = new Position();
            position.setCharacter(current);
            position.setLine(0);
            params.setPosition(position);
            CompletableFuture result = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).collectAll(ls -> ls.getTextDocumentService().hover(params));
            initial = CompletableFuture.allOf(initial, result);
            ++i2;
        }
        initial.join();
        StringBuilder message = new StringBuilder();
        message.append("Too Early hover requests: ");
        message.append(tooEarlyHover.size());
        message.append(System.lineSeparator());
        tooEarlyHover.forEach(i -> {
            message.append("  Too Early ");
            message.append(i);
            message.append(System.lineSeparator());
        });
        message.append("Too Late hover requests: ");
        message.append(tooLateHover.size());
        message.append(System.lineSeparator());
        tooLateHover.forEach(i -> {
            message.append("  Too Late ");
            message.append(i);
            message.append(System.lineSeparator());
        });
        Assert.assertTrue((String)message.toString(), (tooEarlyHover.isEmpty() && tooLateHover.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testBlockingServerDoesNotBlockUIThread() throws Exception {
        AtomicInteger uiDispatchCount = new AtomicInteger();
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                return super.hover(position);
            }
        });
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        CompletableFuture<Object> initial = CompletableFuture.completedFuture(null);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        StyledText text = viewer.getTextWidget();
        Thread.sleep(1000L);
        long startTime = System.currentTimeMillis();
        StringBuilder bulkyText = new StringBuilder();
        int i = 0;
        while (i < 1000) {
            bulkyText.append("Some Text; ");
            ++i;
        }
        String content = bulkyText.toString();
        int i2 = 0;
        while (i2 < 10) {
            int current = i2 + 1;
            text.append(content + "\n");
            HoverParams params = new HoverParams();
            Position position = new Position();
            position.setCharacter(current);
            position.setLine(0);
            params.setPosition(position);
            CompletableFuture hoverFuture = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).collectAll(ls -> {
                try {
                    if (Display.getCurrent() != null) {
                        uiDispatchCount.incrementAndGet();
                    }
                    return ls.getTextDocumentService().hover(params);
                }
                catch (Exception exception) {
                    return CompletableFuture.completedFuture(null);
                }
            });
            initial = CompletableFuture.allOf(initial, hoverFuture);
            ++i2;
        }
        long dispatchTime = System.currentTimeMillis() - startTime;
        initial.join();
        long finishTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)String.format("Dispatch should not have blocked but took %d ms vs overall test time of %d ms", dispatchTime, finishTime), (dispatchTime < 1000L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should not have been any messages dispatched on UI thread", (long)0L, (long)uiDispatchCount.get());
    }

    @Test
    public void testNoMatchingServers() throws Exception {
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withFilter(sc -> false);
        Assert.assertFalse((String)"Should not have been any valid LS", (boolean)executor.anyMatching());
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        Optional result = (Optional)executor.computeFirst(ls -> ls.getTextDocumentService().hover(params)).get(10L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"Should not have had a result", (boolean)result.isPresent());
        List collectedResult = (List)executor.collectAll(ls -> ls.getTextDocumentService().hover(params)).get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Should not have had a result", (boolean)collectedResult.isEmpty());
        List allResults = executor.computeAll(ls -> ls.getTextDocumentService().hover(params));
        for (CompletableFuture f : allResults) {
            Hover h = (Hover)f.get(10L, TimeUnit.SECONDS);
            Assert.assertNull((Object)h);
        }
    }

    @Test(expected=CompletionException.class)
    public void testComputeFirstBubblesException() throws Exception {
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                CompletableFuture<Hover> result = new CompletableFuture<Hover>();
                result.completeExceptionally(new IllegalStateException("No hovering here"));
                return result;
            }
        });
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        CompletableFuture response = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).computeFirst(ls -> ls.getTextDocumentService().hover(params).thenApply(h -> h == null ? null : (String)((Either)((List)h.getContents().getLeft()).get(0)).getLeft()));
        response.join();
    }

    @Test
    public void testWrapperWrapsSameLS() throws Exception {
        Hover hoverResponse = new Hover(List.of(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        HoverParams params = new HoverParams();
        Position position = new Position();
        position.setCharacter(10);
        position.setLine(0);
        params.setPosition(position);
        CompletableFuture async = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).collectAll((w, ls) -> ls.getTextDocumentService().hover(params).thenApply(h -> Pair.of((Object)w, (Object)ls)));
        List result = (List)async.join();
        AtomicInteger matching = new AtomicInteger();
        Assert.assertEquals((String)"Should have had two responses", (long)2L, (long)result.size());
        Assert.assertNotEquals((String)"LS should have been different proxies", (Object)((Pair)result.get(0)).second(), (Object)((Pair)result.get(1)).second());
        result.forEach(p -> ((LanguageServerWrapper)p.first()).execute(ls -> {
            if (ls == p.second()) {
                matching.incrementAndGet();
            }
            return CompletableFuture.completedFuture(null);
        }).join());
        Assert.assertEquals((String)"Wrapper should have used same LS", (long)2L, (long)matching.get());
    }

    @Test
    public void testProjectExecutor() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lspt-different", "");
        IEditorPart editor1 = TestUtils.openEditor(testFile1);
        IEditorPart editor2 = TestUtils.openEditor(testFile2);
        AtomicInteger serverCounter = new AtomicInteger();
        List serversForProject = (List)LanguageServers.forProject((IProject)this.project).collectAll(ls -> CompletableFuture.completedFuture("Server" + serverCounter.incrementAndGet())).join();
        Assert.assertTrue((boolean)serversForProject.contains("Server1"));
        Assert.assertTrue((boolean)serversForProject.contains("Server2"));
        editor1.getSite().getPage().closeEditor(editor1, false);
        editor2.getSite().getPage().closeEditor(editor2, false);
        TestUtils.waitForCondition(5000, () -> !LanguageServiceAccessor.hasActiveLanguageServers(this.MATCH_ALL));
        serverCounter.set(0);
        List serversForProject2 = (List)LanguageServers.forProject((IProject)this.project).excludeInactive().collectAll(ls -> CompletableFuture.completedFuture("Server" + serverCounter.incrementAndGet())).join();
        Assert.assertTrue((boolean)serversForProject2.isEmpty());
        serverCounter.set(0);
        editor1 = TestUtils.openEditor(testFile1);
        List serversForProject3 = (List)LanguageServers.forProject((IProject)this.project).excludeInactive().collectAll(ls -> CompletableFuture.completedFuture("Server" + serverCounter.incrementAndGet())).join();
        Assert.assertTrue((boolean)serversForProject3.contains("Server1"));
        Assert.assertFalse((boolean)serversForProject3.contains("Server2"));
        serverCounter.set(0);
        List serversForProject4 = (List)LanguageServers.forProject((IProject)this.project).collectAll(ls -> CompletableFuture.completedFuture("Server" + serverCounter.incrementAndGet())).join();
        Assert.assertTrue((boolean)serversForProject4.contains("Server1"));
        Assert.assertTrue((boolean)serversForProject4.contains("Server2"));
    }

    @Test
    public void testGetDocument() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IDocument document = viewer.getDocument();
        LanguageServers.LanguageServerDocumentExecutor executor = LanguageServers.forDocument((IDocument)document);
        Assert.assertEquals((Object)document, (Object)executor.getDocument());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testCancellable() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "Here is some content");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        Display display = viewer.getTextWidget().getDisplay();
        DisplayHelper.sleep((Display)display, (long)2000L);
        IDocument document = viewer.getDocument();
        LanguageServers.LanguageServerDocumentExecutor executor = LanguageServers.forDocument((IDocument)document);
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(3000L);
        LanguageServerWrapper lsWrapper = (LanguageServerWrapper)((Optional)executor.computeFirst((wrapper, ls) -> CompletableFuture.completedFuture(wrapper)).get()).get();
        CompletableFuture request = lsWrapper.execute(ls -> ls.getTextDocumentService().references(new ReferenceParams()));
        DisplayHelper.sleep((Display)viewer.getTextWidget().getDisplay(), (long)500L);
        request.cancel(false);
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)display, (long)3000L, () -> !MockConnectionProvider.cancellations.isEmpty()));
        MockConnectionProvider.cancellations.clear();
        request = executor.computeFirst(ls -> ls.getTextDocumentService().references(new ReferenceParams()));
        DisplayHelper.sleep((Display)viewer.getTextWidget().getDisplay(), (long)500L);
        request.cancel(false);
        DisplayHelper.sleep((Display)viewer.getTextWidget().getDisplay(), (long)100L);
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)display, (long)3000L, () -> !MockConnectionProvider.cancellations.isEmpty()));
        MockConnectionProvider.cancellations.clear();
        request = executor.collectAll(ls -> ls.getTextDocumentService().references(new ReferenceParams()));
        DisplayHelper.sleep((Display)viewer.getTextWidget().getDisplay(), (long)500L);
        request.cancel(false);
        DisplayHelper.sleep((Display)viewer.getTextWidget().getDisplay(), (long)100L);
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)display, (long)3000L, () -> !MockConnectionProvider.cancellations.isEmpty()));
        MockConnectionProvider.cancellations.clear();
        @NonNull @NonNull @Nullable List requests = executor.computeAll(ls -> ls.getTextDocumentService().references(new ReferenceParams()));
        DisplayHelper.sleep((Display)viewer.getTextWidget().getDisplay(), (long)500L);
        requests.forEach(r -> {
            boolean bl = r.cancel(false);
        });
        DisplayHelper.sleep((Display)viewer.getTextWidget().getDisplay(), (long)100L);
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)display, (long)3000L, () -> !MockConnectionProvider.cancellations.isEmpty()));
    }
}

