/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.outline.CNFOutlinePage;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class EditorToOutlineAdapterFactory
implements IAdapterFactory {
    private static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    private static final Map<IEditorPart, LanguageServerWrapper> LANG_SERVER_CACHE = Collections.synchronizedMap(new HashMap());

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == IContentOutlinePage.class && adaptableObject instanceof IEditorPart var3_4 && (editorInput = editorPart.getEditorInput()) != null && LanguageServersRegistry.getInstance().canUseLanguageServer(editorInput)) {
            LanguageServerWrapper server = LANG_SERVER_CACHE.remove(adaptableObject);
            if (server != null && server.isActive()) {
                return adapterType.cast(EditorToOutlineAdapterFactory.createOutlinePage((IEditorPart)editorPart, server));
            }
            IDocument document = LSPEclipseUtils.getDocument(editorInput);
            if (document != null) {
                CompletableFuture<Optional<LanguageServerWrapper>> languageServer = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getDocumentSymbolProvider()))).computeFirst((w, ls) -> CompletableFuture.completedFuture(w));
                try {
                    return languageServer.get(50L, TimeUnit.MILLISECONDS).filter(Objects::nonNull).filter(LanguageServerWrapper::isActive).map(arg_0 -> EditorToOutlineAdapterFactory.lambda$4(adapterType, (IEditorPart)editorPart, arg_0)).orElse(null);
                }
                catch (TimeoutException e) {
                    EditorToOutlineAdapterFactory.refreshContentOutlineAsync(languageServer, (IEditorPart)editorPart);
                }
                catch (ExecutionException e) {
                    LanguageServerPlugin.logError(e);
                }
                catch (InterruptedException e) {
                    LanguageServerPlugin.logError(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IContentOutlinePage.class};
    }

    private static CNFOutlinePage createOutlinePage(IEditorPart editorPart, @NonNull LanguageServerWrapper wrapper) {
        ITextEditor textEditor = null;
        if (editorPart instanceof ITextEditor var3_4) {
            textEditor = thisTextEditor;
        }
        return new CNFOutlinePage(wrapper, textEditor);
    }

    private static void refreshContentOutlineAsync(CompletableFuture<Optional<LanguageServerWrapper>> wrapper, IEditorPart editorPart) {
        wrapper.thenAcceptAsync(servers -> {
            if (!servers.isEmpty()) {
                Display.getDefault().asyncExec(() -> {
                    ContentOutline contentOutline;
                    IViewPart viewPart;
                    IViewPart iViewPart;
                    IWorkbenchPage page = UI.getActivePage();
                    if (page != null && (iViewPart = (viewPart = page.findView(OUTLINE_VIEW_ID))) instanceof ContentOutline && (contentOutline = (ContentOutline)iViewPart) == (ContentOutline)iViewPart) {
                        void contentOutline2;
                        LANG_SERVER_CACHE.put(editorPart, (LanguageServerWrapper)servers.get());
                        contentOutline2.partActivated((IWorkbenchPart)editorPart);
                    }
                });
            }
        });
    }

    private static /* synthetic */ Object lambda$4(Class clazz, IEditorPart iEditorPart, LanguageServerWrapper s) {
        return clazz.cast(EditorToOutlineAdapterFactory.createOutlinePage(iEditorPart, s));
    }
}

