/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.codeactions.CodeActionCompletionProposal;
import org.eclipse.lsp4e.operations.codeactions.LSPCodeActionMarkerResolution;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPCodeActionsMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IDocument document;
    private Range range;

    public void initialize(IServiceLocator serviceLocator) {
        ITextEditor editor = UI.getActiveTextEditor();
        if (editor != null) {
            ITextEditor textEditor = editor;
            IDocument document = LSPEclipseUtils.getDocument(textEditor);
            if (document == null) {
                return;
            }
            this.document = document;
            ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
            try {
                this.range = new Range(LSPEclipseUtils.toPosition(selection.getOffset(), document), LSPEclipseUtils.toPosition(selection.getOffset() + selection.getLength(), document));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public void fill(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 0, index);
        item.setEnabled(false);
        item.setText(Messages.computing);
        @NonNull IDocument document = this.document;
        URI fileUri = LSPEclipseUtils.toUri(document);
        CodeActionContext context = new CodeActionContext(Collections.emptyList());
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(LSPEclipseUtils.toTextDocumentIdentifier(fileUri));
        params.setRange(this.range);
        params.setContext(context);
        @NonNull List<@NonNull CompletableFuture<T>> actions = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(LSPCodeActionMarkerResolution::providesCodeActions)).computeAll((w, ls) -> ls.getTextDocumentService().codeAction(params).whenComplete((codeActions, t) -> this.scheduleMenuUpdate(menu, item, index, document, (LanguageServerWrapper)w, (Throwable)t, (List<Either<Command, CodeAction>>)codeActions)));
        if (actions.isEmpty()) {
            item.setText(Messages.notImplemented);
            return;
        }
        super.fill(menu, index);
    }

    private void scheduleMenuUpdate(final Menu menu, final MenuItem placeHolder, final int index, final IDocument document, final LanguageServerWrapper wrapper, final Throwable u, final List<Either<Command, CodeAction>> codeActions) {
        UIJob job = new UIJob(menu.getDisplay(), Messages.updateCodeActions_menu){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (u != null) {
                    MenuItem item = new MenuItem(menu, 0, index);
                    item.setText(u.getMessage());
                    item.setImage(LSPImages.getSharedImage("IMG_DEC_FIELD_ERROR"));
                    item.setEnabled(false);
                } else if (codeActions != null) {
                    for (Either command : codeActions) {
                        if (command == null) continue;
                        MenuItem item = new MenuItem(menu, 0, index);
                        final CodeActionCompletionProposal proposal = new CodeActionCompletionProposal((Either<Command, CodeAction>)command, wrapper);
                        item.setText(proposal.getDisplayString());
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                proposal.apply(document);
                            }
                        });
                    }
                }
                if (menu.getItemCount() == 1) {
                    placeHolder.setText(Messages.codeActions_emptyMenu);
                } else {
                    placeHolder.dispose();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

