/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.test.completion.AbstractCompletionTest;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.Assert;
import org.junit.Test;

public class IncompleteCompletionTest
extends AbstractCompletionTest {
    @Test
    public void testAssistForUnknownButConnectedType() throws CoreException, InvocationTargetException, IOException, InterruptedException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        IFile testFile = TestUtils.createUniqueTestFileOfUnknownType(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        LanguageServersRegistry.LanguageServerDefinition serverDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.lsp4e.test.server");
        Assert.assertNotNull((Object)serverDefinition);
        final LanguageServerWrapper lsWrapper = LanguageServiceAccessor.getLSWrapper((IProject)testFile.getProject(), (LanguageServersRegistry.LanguageServerDefinition)serverDefinition);
        final URI fileLocation = testFile.getLocationURI();
        lsWrapper.connect(testFile, null);
        new DisplayHelper(){

            protected boolean condition() {
                return lsWrapper.isConnectedTo(fileLocation);
            }
        }.waitForCondition(Display.getCurrent(), 3000L);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testNoPrefix() throws CoreException, InvocationTargetException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testDeprecatedCompletion() throws Exception {
        BoldStylerProvider boldStyleProvider = null;
        try {
            ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
            CompletionItem completionItem = this.createCompletionItem("FirstClassDeprecated", CompletionItemKind.Class);
            completionItem.setDeprecated(Boolean.valueOf(true));
            items.add(completionItem);
            MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
            String content = "First";
            ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
            ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
            Assert.assertEquals((long)1L, (long)proposals.length);
            LSCompletionProposal proposal = (LSCompletionProposal)proposals[0];
            StyledString simpleStyledStr = proposal.getStyledDisplayString();
            Assert.assertEquals((Object)"FirstClassDeprecated", (Object)simpleStyledStr.getString());
            Assert.assertEquals((long)1L, (long)simpleStyledStr.getStyleRanges().length);
            StyleRange styleRange = simpleStyledStr.getStyleRanges()[0];
            Assert.assertTrue((boolean)styleRange.strikeout);
            boldStyleProvider = new BoldStylerProvider(Display.getDefault().getActiveShell().getFont());
            StyledString styledStr = proposal.getStyledDisplayString(viewer.getDocument(), 4, boldStyleProvider);
            Assert.assertTrue((styledStr.getStyleRanges().length > 1 ? 1 : 0) != 0);
            StyleRange[] styleRangeArray = styledStr.getStyleRanges();
            int n = styleRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange sr = styleRangeArray[n2];
                Assert.assertTrue((boolean)sr.strikeout);
                ++n2;
            }
        }
        finally {
            if (boldStyleProvider != null) {
                boldStyleProvider.dispose();
            }
        }
    }

    @Test
    public void testPrefix() throws CoreException, InvocationTargetException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        items.add(this.createCompletionItem("SecondClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "First";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testPrefixCaseSensitivity() throws CoreException, InvocationTargetException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "FIRST";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompleteOnFileEnd() throws CoreException, InvocationTargetException {
        CompletionItem item = new CompletionItem();
        item.setLabel("1024M");
        item.setKind(CompletionItemKind.Value);
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(2, 10), new Position(2, 10)), "1024M")));
        CompletionList completionList = new CompletionList(true, Collections.singletonList(item));
        MockLanguageServer.INSTANCE.setCompletionList(completionList);
        String content = "applications:\n- name: hello\n  memory: ";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assert.assertEquals((Object)(String.valueOf(content) + "1024M"), (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompletionWithAdditionalEdits() throws CoreException, InvocationTargetException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        CompletionItem item = new CompletionItem("additionaEditsCompletion");
        item.setKind(CompletionItemKind.Function);
        item.setInsertText("MainInsertText");
        ArrayList<TextEdit> additionalTextEdits = new ArrayList<TextEdit>();
        TextEdit additionaEdit1 = new TextEdit(new Range(new Position(0, 6), new Position(0, 6)), "addOnText1");
        TextEdit additionaEdit2 = new TextEdit(new Range(new Position(0, 12), new Position(0, 12)), "addOnText2");
        additionalTextEdits.add(additionaEdit1);
        additionalTextEdits.add(additionaEdit2);
        item.setAdditionalTextEdits(additionalTextEdits);
        items.add(item);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "this <> is <> the main <> content of the file";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, content);
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 24);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        String newContent = viewer.getDocument().get();
        Assert.assertEquals((Object)"this <addOnText1> is <addOnText2> the main <MainInsertText> content of the file", (Object)newContent);
    }

    @Test
    public void testSnippetCompletionWithAdditionalEdits() throws PartInitException, InvocationTargetException, CoreException {
        CompletionItem item = new CompletionItem("snippet item");
        item.setInsertText("$1 and ${2:foo}");
        item.setKind(CompletionItemKind.Class);
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        ArrayList<TextEdit> additionalTextEdits = new ArrayList<TextEdit>();
        TextEdit additionaEdit1 = new TextEdit(new Range(new Position(0, 6), new Position(0, 6)), "addOnText1");
        TextEdit additionaEdit2 = new TextEdit(new Range(new Position(0, 12), new Position(0, 12)), "addOnText2");
        additionalTextEdits.add(additionaEdit1);
        additionalTextEdits.add(additionaEdit2);
        item.setAdditionalTextEdits(additionalTextEdits);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, Collections.singletonList(item)));
        String content = "this <> is <> the main <> content of the file";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 24);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        String newContent = viewer.getDocument().get();
        Assert.assertEquals((Object)"this <addOnText1> is <addOnText2> the main < and foo> content of the file", (Object)newContent);
    }

    @Test
    public void testApplyCompletionWithPrefix() throws CoreException, InvocationTargetException {
        Range range = new Range(new Position(0, 0), new Position(0, 5));
        List<CompletionItem> items = Collections.singletonList(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "First";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assert.assertEquals((Object)true, (Object)viewer.getDocument().get().equals("FirstClass"));
        Assert.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplace() throws CoreException, InvocationTargetException {
        Range range = new Range(new Position(0, 0), new Position(0, 20));
        List<CompletionItem> items = Collections.singletonList(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "FirstNotMatchedLabel";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 5);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assert.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplaceAndTypingWithTextEdit() throws CoreException, InvocationTargetException, BadLocationException {
        Range range = new Range(new Position(0, 0), new Position(0, 22));
        List<CompletionItem> items = Collections.singletonList(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "FirstNotMatchedLabel";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        int invokeOffset = 5;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        viewer.getDocument().replace(5, 0, "No");
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assert.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplaceAndTyping() throws CoreException, InvocationTargetException, BadLocationException {
        CompletionItem item = new CompletionItem("strncasecmp");
        item.setKind(CompletionItemKind.Function);
        item.setInsertText("strncasecmp()");
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, Collections.singletonList(item)));
        String content = "str";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        int invokeOffset = content.length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        viewer.getDocument().replace(content.length(), 0, "nc");
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assert.assertEquals((Object)item.getInsertText(), (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(item.getInsertText().length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompletionReplace() throws CoreException, InvocationTargetException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "line1\nlineInsertHere");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, Collections.singletonList(this.createCompletionItem("Inserted", CompletionItemKind.Text, new Range(new Position(1, 4), new Position(1, 4 + "InsertHere".length()))))));
        int invokeOffset = viewer.getDocument().getLength() - "InsertHere".length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assert.assertEquals((Object)"line1\nlineInserted", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testItemOrdering() throws Exception {
        Range range = new Range(new Position(0, 0), new Position(0, 1));
        List<CompletionItem> items = Arrays.asList(this.createCompletionItem("AA", CompletionItemKind.Class, range), this.createCompletionItem("AB", CompletionItemKind.Class, range), this.createCompletionItem("BA", CompletionItemKind.Class, range), this.createCompletionItem("BB", CompletionItemKind.Class, range), this.createCompletionItem("CB", CompletionItemKind.Class, range), this.createCompletionItem("CC", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "B";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        int invokeOffset = 1;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)4L, (long)proposals.length);
        Assert.assertEquals((Object)"BA", (Object)proposals[0].getDisplayString());
        Assert.assertEquals((Object)"BB", (Object)proposals[1].getDisplayString());
        Assert.assertEquals((Object)"AB", (Object)proposals[2].getDisplayString());
        Assert.assertEquals((Object)"CB", (Object)proposals[3].getDisplayString());
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        Assert.assertEquals((Object)"BA", (Object)viewer.getDocument().get());
    }

    @Test
    public void testBasicSnippet() throws PartInitException, InvocationTargetException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("$1 and ${2:foo}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, Collections.singletonList(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        Assert.assertEquals((Object)" and foo", (Object)viewer.getDocument().get());
    }

    @Test
    public void testDuplicateVariable() throws PartInitException, InvocationTargetException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("${1:foo} and ${1:foo}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, Collections.singletonList(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        Assert.assertEquals((Object)"foo and foo", (Object)viewer.getDocument().get());
    }

    @Test
    public void testVariableReplacement() throws PartInitException, InvocationTargetException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("${1:$TM_FILENAME_BASE} ${2:$TM_FILENAME} ${3:$TM_FILEPATH} ${4:$TM_DIRECTORY} ${5:$TM_LINE_INDEX} ${6:$TM_LINE_NUMBER} ${7:$TM_CURRENT_LINE} ${8:$TM_SELECTED_TEXT}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, Collections.singletonList(completionItem)));
        String content = "line1\nline2\nline3";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, content);
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        int lineIndex = ((TextEdit)completionItem.getTextEdit().getLeft()).getRange().getStart().getLine();
        String fileNameBase = testFile.getFullPath().removeFileExtension().lastSegment();
        String filePath = testFile.getRawLocation().toOSString();
        String fileDir = this.project.getLocation().toOSString();
        Assert.assertEquals((Object)String.format("%s %s %s %s %d %d %s %s%s", fileNameBase, testFile.getName(), filePath, fileDir, lineIndex, lineIndex + 1, "line1", "l", content.substring(1)), (Object)viewer.getDocument().get());
    }

    @Test
    public void testMultipleLS() throws Exception {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)(2 * items.size()), (long)proposals.length);
    }

    @Test
    public void testCompletionWithAdditionalTextEditInsertion() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Some Text Before\n<tag>tagText</tag>\nSome Text After");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        CompletionItem item = this.createCompletionItem("tagText", CompletionItemKind.Text, new Range(new Position(1, "<tag>".length()), new Position(1, "<tag>".length() + "tag".length())));
        ArrayList<TextEdit> additionalEdits = new ArrayList<TextEdit>(2);
        additionalEdits.add(new TextEdit(new Range(new Position(1, 0), new Position(1, 0)), "<prefix>prefixText</prefix>\n"));
        additionalEdits.add(new TextEdit(new Range(new Position(1, "<tag>tag</tag>".length()), new Position(1, "<tag>tag</tag>".length())), "\n<postfix>postfixText</postfix>"));
        item.setAdditionalTextEdits(additionalEdits);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, Collections.singletonList(item)));
        String text = viewer.getDocument().get();
        int invokeOffset = text.indexOf("<tag>tag") + "<tag>tag".length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        int currentOffset = invokeOffset + "Text".length();
        LSIncompleteCompletionProposal.apply(viewer.getDocument(), '\u0000', currentOffset);
        String expectedText = "Some Text Before\n<prefix>prefixText</prefix>\n<tag>tagText</tag>\n<postfix>postfixText</postfix>\nSome Text After";
        Assert.assertEquals((Object)"Some Text Before\n<prefix>prefixText</prefix>\n<tag>tagText</tag>\n<postfix>postfixText</postfix>\nSome Text After", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(viewer.getDocument().get().indexOf("</tag>"), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompletionExternalFile() throws Exception {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClassExternal", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        File file = File.createTempFile("testCompletionExternalFile", ".lspt");
        try {
            ITextEditor editor = (ITextEditor)IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
            ITextViewer viewer = TestUtils.getTextViewer((IEditorPart)editor);
            ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
            Assert.assertEquals((long)1L, (long)proposals.length);
            proposals[0].apply(viewer.getDocument());
            Assert.assertEquals((Object)"FirstClassExternal", (Object)viewer.getDocument().get());
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void testAdditionalInformation() throws Exception {
        IDocument document = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "")).getDocument();
        LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)document, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, new CompletionItem("blah"), info.getLanguageClient());
        completionProposal.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAdditionalInformationWithEmptyDetail() throws Exception {
        IDocument document = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "")).getDocument();
        LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)document, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        CompletionItem item = new CompletionItem("blah");
        item.setDetail("");
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, item, info.getLanguageClient());
        String addInfo = completionProposal.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)addInfo.isEmpty());
    }

    @Test
    public void testAdditionalInformationWithDetail() throws Exception {
        IDocument document = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "")).getDocument();
        LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)document, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        CompletionItem item = new CompletionItem("blah");
        item.setDetail("detail");
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, item, info.getLanguageClient());
        String addInfo = completionProposal.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((addInfo.indexOf("<p>detail</p>") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAdditionalInformationWithEmptyDocumentation() throws Exception {
        IDocument document = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "")).getDocument();
        LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)document, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        CompletionItem item = new CompletionItem("blah");
        item.setDocumentation("");
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, item, info.getLanguageClient());
        String addInfo = completionProposal.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)addInfo.isEmpty());
    }

    @Test
    public void testAdditionalInformationWithDocumentation() throws Exception {
        IDocument document = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "")).getDocument();
        LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)document, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        CompletionItem item = new CompletionItem("blah");
        item.setDocumentation("documentation");
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, item, info.getLanguageClient());
        String addInfo = completionProposal.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)addInfo.isEmpty());
    }
}

