/*
 * Decompiled with CFR 0.152.
 */
package activity.util;

import activity.Action;
import activity.Activity;
import activity.ActivityFactory;
import activity.Claim;
import activity.Dependency;
import activity.Release;
import activity.SyncBar;
import activity.impl.ActivityQueries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import machine.IResource;
import machine.ResourceType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.graph.directed.editable.EdgFactory;
import org.eclipse.lsat.common.graph.directed.editable.Edge;
import org.eclipse.lsat.common.graph.directed.editable.EdgeTarget;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.graph.directed.editable.SourceReference;
import org.eclipse.lsat.common.graph.directed.editable.TargetReference;

public final class ActivityUtil {
    public static final String EXPAND_DELIMITER = "_";

    private ActivityUtil() {
    }

    public static void addDependency(Activity activity, Node source, Node target) {
        if (!ActivityUtil.edgeExists(activity, source, target)) {
            Dependency dependency = ActivityFactory.eINSTANCE.createDependency();
            SourceReference sourceRef = EdgFactory.eINSTANCE.createSourceReference();
            sourceRef.setNode(source);
            dependency.setSource(sourceRef);
            TargetReference targetRef = EdgFactory.eINSTANCE.createTargetReference();
            targetRef.setNode(target);
            dependency.setTarget((EdgeTarget)targetRef);
            activity.getEdges().add((Object)dependency);
        }
    }

    private static boolean edgeExists(Activity activity, Node source, Node target) {
        return activity.getEdges().stream().anyMatch(e -> e.getSource() == source && e.getTarget() == target);
    }

    public static SyncBar addSyncBar(Activity activity) {
        SyncBar syncBar = ActivityFactory.eINSTANCE.createSyncBar();
        syncBar.setName(ActivityUtil.getFirstFreeName("S", activity));
        activity.getNodes().add((Object)syncBar);
        return syncBar;
    }

    public static Release addRelease(Activity activity, IResource resource) {
        if (ActivityUtil.getReleases(activity, resource).isEmpty()) {
            Release release = ActivityFactory.eINSTANCE.createRelease();
            release.setName(ActivityUtil.getFirstFreeName("R", activity));
            release.setResource(resource);
            activity.getNodes().add((Object)release);
        }
        return ActivityUtil.getReleases(activity, resource).iterator().next();
    }

    public static Claim addClaim(Activity activity, IResource resource) {
        if (ActivityUtil.getClaims(activity, resource).isEmpty()) {
            Claim claim = ActivityFactory.eINSTANCE.createClaim();
            claim.setName(ActivityUtil.getFirstFreeName("C", activity));
            claim.setResource(resource);
            activity.getNodes().add((Object)claim);
        }
        return ActivityUtil.getClaims(activity, resource).iterator().next();
    }

    public static void insertSyncBars(Action action) {
        SyncBar syncBar;
        Activity activity = (Activity)action.getGraph();
        if (action.getIncomingEdges().size() > 1) {
            syncBar = ActivityUtil.addSyncBar(activity);
            action.getIncomingEdges().stream().map(Edge::getSourceNode).forEach(s -> ActivityUtil.addDependency(activity, s, syncBar));
            new ArrayList<Edge>((Collection<Edge>)action.getIncomingEdges()).forEach(ActivityUtil::delete);
            ActivityUtil.addDependency(activity, syncBar, action);
        }
        if (action.getOutgoingEdges().size() > 1) {
            syncBar = ActivityUtil.addSyncBar(activity);
            action.getOutgoingEdges().stream().map(Edge::getTargetNode).forEach(s -> ActivityUtil.addDependency(activity, syncBar, s));
            new ArrayList<Edge>((Collection<Edge>)action.getOutgoingEdges()).forEach(ActivityUtil::delete);
            ActivityUtil.addDependency(activity, action, syncBar);
        }
    }

    public static void delete(Node node) {
        for (Edge edge : node.getIncomingEdges()) {
            ActivityUtil.delete(edge);
        }
        for (Edge edge : node.getOutgoingEdges()) {
            ActivityUtil.delete(edge);
        }
        if (node.getGraph() != null) {
            node.getGraph().getNodes().remove((Object)node);
        }
        EcoreUtil.delete((EObject)node);
    }

    public static void delete(Edge edge) {
        if (edge.getTarget() instanceof Edge) {
            edge.getGraph().getEdges().add((Object)((Edge)edge.getTarget()));
        }
        if (edge.getEdge() != null) {
            TargetReference target = EdgFactory.eINSTANCE.createTargetReference();
            target.setNode(edge.getSource().getNode());
            edge.getEdge().setTarget((EdgeTarget)target);
        }
        edge.setTarget(null);
        edge.setSource(null);
        if (edge.getGraph() != null) {
            edge.getGraph().getEdges().remove((Object)edge);
        }
        EcoreUtil.delete((EObject)edge);
    }

    public static String getFirstFreeName(String prefix, Activity activity) {
        Collection names = activity.getNodes().stream().map(n -> n.getName()).collect(Collectors.toSet());
        int i = 1;
        while (names.contains(prefix + i)) {
            ++i;
        }
        return prefix + i;
    }

    public static String getPassiveName(IResource resource) {
        if (resource.getResource().getResourceType() == ResourceType.PASSIVE) {
            return resource.getName();
        }
        return ResourceType.PASSIVE.getName() + EXPAND_DELIMITER + resource.fqn().replace('.', '_');
    }

    public static Collection<Claim> getClaims(Activity activity, IResource resource) {
        return ActivityQueries.getActionsFor(resource, Claim.class, (Iterable<Node>)activity.getNodes()).asList();
    }

    public static Collection<Release> getReleases(Activity activity, IResource resource) {
        return ActivityQueries.getActionsFor(resource, Release.class, (Iterable<Node>)activity.getNodes()).asList();
    }
}

