/**
 */
package distributions;

import distributions.math.ModeDistribution;

import expressions.Expression;

import java.math.BigDecimal;

import org.apache.commons.math3.random.RandomGenerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Normal Distribution</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link distributions.NormalDistribution#getMean <em>Mean</em>}</li>
 *   <li>{@link distributions.NormalDistribution#getSd <em>Sd</em>}</li>
 *   <li>{@link distributions.NormalDistribution#getMeanExp <em>Mean Exp</em>}</li>
 *   <li>{@link distributions.NormalDistribution#getSdExp <em>Sd Exp</em>}</li>
 * </ul>
 *
 * @see distributions.DistributionsPackage#getNormalDistribution()
 * @model
 * @generated
 */
public interface NormalDistribution extends Distribution
{
    /**
     * Returns the value of the '<em><b>Mean</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Mean</em>' attribute.
     * @see distributions.DistributionsPackage#getNormalDistribution_Mean()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getMean();

    /**
     * Returns the value of the '<em><b>Sd</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Sd</em>' attribute.
     * @see distributions.DistributionsPackage#getNormalDistribution_Sd()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getSd();

    /**
     * Returns the value of the '<em><b>Mean Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Mean Exp</em>' containment reference.
     * @see #setMeanExp(Expression)
     * @see distributions.DistributionsPackage#getNormalDistribution_MeanExp()
     * @model containment="true" required="true"
     * @generated
     */
    Expression getMeanExp();

    /**
     * Sets the value of the '{@link distributions.NormalDistribution#getMeanExp <em>Mean Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Mean Exp</em>' containment reference.
     * @see #getMeanExp()
     * @generated
     */
    void setMeanExp(Expression value);

    /**
     * Returns the value of the '<em><b>Sd Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Sd Exp</em>' containment reference.
     * @see #setSdExp(Expression)
     * @see distributions.DistributionsPackage#getNormalDistribution_SdExp()
     * @model containment="true" required="true"
     * @generated
     */
    Expression getSdExp();

    /**
     * Sets the value of the '{@link distributions.NormalDistribution#getSdExp <em>Sd Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Sd Exp</em>' containment reference.
     * @see #getSdExp()
     * @generated
     */
    void setSdExp(Expression value);

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @model dataType="distributions.ModeDistribution" required="true" generatorDataType="distributions.RandomGenerator"
     * @generated
     */
    ModeDistribution createModeDistribution(RandomGenerator generator);

} // NormalDistribution
