/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.common.ui;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class TableContentOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener,
IViewerProvider {
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private TableViewer tableViewer;

    protected TableContentOutlinePage() {
    }

    public Viewer getViewer() {
        return this.tableViewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void createControl(Composite parent) {
        this.tableViewer = new TableViewer(parent, this.getTableStyle());
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected int getTableStyle() {
        return 770;
    }

    protected void fireSelectionChanged(ISelection selection) {
        Object[] listeners;
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] objectArray = listeners = this.selectionChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ISelectionChangedListener l = (ISelectionChangedListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++n2;
        }
    }

    public Control getControl() {
        if (this.tableViewer == null) {
            return null;
        }
        return this.tableViewer.getControl();
    }

    public ISelection getSelection() {
        if (this.tableViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.tableViewer.getSelection();
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.tableViewer != null) {
            this.tableViewer.setSelection(selection);
        }
    }
}

