/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.model;

import com.google.gson.annotations.SerializedName;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.lsat.external.api.model.LsatBase;
import org.eclipse.lsat.external.api.model.PathType;

public class Path
extends LsatBase {
    public static final String SERIALIZED_NAME_POINTS = "points";
    @SerializedName(value="points")
    @Nonnull
    private List<String> points = new ArrayList<String>();
    public static final String SERIALIZED_NAME_PROFILES = "profiles";
    @SerializedName(value="profiles")
    @Nonnull
    private List<String> profiles = new ArrayList<String>();
    public static final String SERIALIZED_NAME_PATH_TYPE = "pathType";
    @SerializedName(value="pathType")
    @Nonnull
    private PathType pathType;

    public Path points(@Nonnull List<String> points) {
        this.points = points;
        return this;
    }

    public Path addPointsItem(String pointsItem) {
        if (this.points == null) {
            this.points = new ArrayList<String>();
        }
        this.points.add(pointsItem);
        return this;
    }

    @Nonnull
    public List<String> getPoints() {
        return this.points;
    }

    public void setPoints(@Nonnull List<String> points) {
        this.points = points;
    }

    public Path profiles(@Nonnull List<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    public Path addProfilesItem(String profilesItem) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<String>();
        }
        this.profiles.add(profilesItem);
        return this;
    }

    @Nonnull
    public List<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(@Nonnull List<String> profiles) {
        this.profiles = profiles;
    }

    public Path pathType(@Nonnull PathType pathType) {
        this.pathType = pathType;
        return this;
    }

    @Nonnull
    public PathType getPathType() {
        return this.pathType;
    }

    public void setPathType(@Nonnull PathType pathType) {
        this.pathType = pathType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return Objects.equals(this.points, path.points) && Objects.equals(this.profiles, path.profiles) && Objects.equals((Object)this.pathType, (Object)path.pathType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.points, this.profiles, this.pathType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Path {\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    profiles: ").append(this.toIndentedString(this.profiles)).append("\n");
        sb.append("    pathType: ").append(this.toIndentedString((Object)this.pathType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

