/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.util.NamingUtil;
import org.eclipse.lsat.external.api.model.Activity;
import org.eclipse.lsat.external.api.model.LsatData;

public class LsatBase {
    private static final Map<String, String> FIELD_TRANSLATION = Map.of("predecessorMove", "action", "successorMove", "action", "source", "task", "target", "task", "inTask", "task", "outTask", "task");
    private transient boolean resolved = false;

    public boolean isResolved() {
        return this.resolved;
    }

    public void resolveReferences(LsatData lsatData) {
        this.resolveReferences(lsatData, null);
    }

    private void resolveReferences(LsatData lsatData, LsatBase container) {
        String fieldName;
        this.resolved = true;
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> cls = this.getClass();
        while (cls != LsatBase.class) {
            Field[] newFields = cls.getDeclaredFields();
            fields.addAll(Arrays.asList(newFields));
            cls = cls.getSuperclass();
        }
        Set fieldNames = fields.stream().map(Field::getName).collect(Collectors.toSet());
        for (Field field : fields) {
            Object obj;
            Map<String, Object> lookupData;
            fieldName = field.getName();
            if (!fieldName.endsWith("Id") && !fieldName.endsWith("Ids")) continue;
            String referenceFieldName = "";
            referenceFieldName = fieldName.endsWith("Id") ? fieldName.substring(0, fieldName.length() - 2) : fieldName.substring(0, fieldName.length() - 3);
            String lookupName = NamingUtil.makePlural((String)this.translateField(referenceFieldName));
            if (lookupName.equals("actions")) {
                if (container instanceof Activity) {
                    lookupData = this.getMapAttr(container, "actions");
                } else {
                    Map<String, Object> activities = this.getMapAttr(container, "activities");
                    Object activity = activities.get(this.getAttr((Object)this, "activityId"));
                    lookupData = this.getMapAttr(activity, "actions");
                }
            } else {
                lookupData = this.getMapAttr(lsatData, lookupName);
            }
            if (fieldName.endsWith("Ids")) {
                referenceFieldName = NamingUtil.makePlural((String)referenceFieldName);
            }
            if ((obj = this.getAttr((Object)this, field)) instanceof List) {
                List listOfIds = (List)obj;
                List objList = (List)this.getAttr((Object)this, referenceFieldName);
                for (Object f : listOfIds) {
                    LsatBase data = (LsatBase)lookupData.get(f);
                    objList.add(data);
                }
                this.setAttr((Object)this, referenceFieldName, (Object)objList);
                continue;
            }
            LsatBase data = (LsatBase)lookupData.get(obj);
            this.setAttr((Object)this, referenceFieldName, (Object)data);
        }
        block3: for (Field field : fields) {
            LsatBase lsatBase;
            LsatBase lsatBase2;
            fieldName = field.getName();
            if (fieldNames.contains(fieldName + "Id") || fieldNames.contains(fieldName + "Ids")) continue;
            if (field.getType() == List.class) {
                List objList = (List)this.getAttr((Object)this, field);
                for (Object obj : objList) {
                    if (!(obj instanceof LsatBase)) continue block3;
                    lsatBase2 = (LsatBase)obj;
                    if (lsatBase2.isResolved()) continue;
                    lsatBase2.resolveReferences(lsatData, this);
                }
                continue;
            }
            if (field.getType() == Map.class) {
                Map objMap = (Map)this.getAttr((Object)this, field);
                for (Object obj : objMap.values()) {
                    if (!(obj instanceof LsatBase)) continue block3;
                    lsatBase2 = (LsatBase)obj;
                    if (lsatBase2.isResolved()) continue;
                    lsatBase2.resolveReferences(lsatData, this);
                }
                continue;
            }
            if (!LsatBase.class.isAssignableFrom(field.getType()) || (lsatBase = (LsatBase)this.getAttr((Object)this, field)) == null || lsatBase.isResolved()) continue;
            lsatBase.resolveReferences(lsatData, this);
        }
    }

    private String translateField(String fieldName) {
        if (this.getClass().getSimpleName().equals("ActivityDependency") && (fieldName.equals("source") || fieldName.equals("target"))) {
            return "action";
        }
        return FIELD_TRANSLATION.containsKey(fieldName) ? FIELD_TRANSLATION.get(fieldName) : fieldName;
    }

    private Map<String, Object> getMapAttr(Object container, String fieldName) {
        Map dataMap;
        Object attr = this.getAttr(container, fieldName);
        if (attr instanceof Map) {
            Map cast;
            dataMap = cast = (Map)attr;
        } else if (attr == null) {
            dataMap = null;
        } else {
            throw new IllegalStateException("Expected a Map<String,Object> for " + fieldName + " but got: " + String.valueOf(attr.getClass()));
        }
        return dataMap;
    }

    private Object getAttr(Object container, String fieldName) {
        Field field;
        try {
            field = container.getClass().getDeclaredField(fieldName);
        }
        catch (Exception exception) {
            return null;
        }
        return this.getAttr(container, field);
    }

    private Object getAttr(Object container, Field field) {
        Object obj = null;
        boolean accessibility = false;
        try {
            accessibility = field.canAccess(container);
        }
        catch (Exception exception) {
            return obj;
        }
        try {
            field.setAccessible(true);
            obj = field.get(container);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        field.setAccessible(accessibility);
        return obj;
    }

    private void setAttr(Object container, String fieldName, Object value) {
        Class<?> cls = this.getClass();
        while (cls != LsatBase.class) {
            Field field = null;
            try {
                field = cls.getDeclaredField(fieldName);
            }
            catch (Exception exception) {}
            if (field != null) {
                this.setAttr(container, field, value);
                break;
            }
            cls = cls.getSuperclass();
        }
    }

    private void setAttr(Object container, Field field, Object value) {
        boolean accessibility = false;
        try {
            accessibility = field.canAccess(container);
        }
        catch (Exception exception) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(container, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        field.setAccessible(accessibility);
    }
}

