/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.por.DependencyGraph;

public class MatrixDependencies {
    private MatrixDependencies() {
    }

    public static DependencyGraph getDependencyGraphMatrixCommute(Map<String, Matrix> mapping) {
        DependencyGraph depGraph = new DependencyGraph();
        for (String matrixName : mapping.keySet()) {
            depGraph.addNode(matrixName);
        }
        for (String matrixA : mapping.keySet()) {
            for (String matrixB : mapping.keySet()) {
                Matrix mBA;
                Matrix mB;
                Matrix mA = mapping.get(matrixA);
                Matrix mAB = mA.multiply(mB = mapping.get(matrixB));
                if (mAB.compareTo(mBA = mB.multiply(mA)) == 0) continue;
                depGraph.addDependency(matrixA, matrixB);
            }
        }
        return depGraph;
    }

    public static DependencyGraph getDependencyGraphResourceSharing(Map<String, Matrix> mapping) {
        HashMap<String, Set<Integer>> matrix2usedResourcesMap = new HashMap<String, Set<Integer>>();
        for (String matrixName : mapping.keySet()) {
            matrix2usedResourcesMap.put(matrixName, MatrixDependencies.getUsedResources(mapping.get(matrixName)));
        }
        DependencyGraph depGraph = new DependencyGraph();
        for (String matrixName : mapping.keySet()) {
            depGraph.addNode(matrixName);
        }
        for (String thisMatrix : mapping.keySet()) {
            for (String otherMatrix : mapping.keySet()) {
                if (Collections.disjoint((Collection)matrix2usedResourcesMap.get(thisMatrix), (Collection)matrix2usedResourcesMap.get(otherMatrix))) continue;
                depGraph.addDependency(thisMatrix, otherMatrix);
            }
        }
        return depGraph;
    }

    public static Set<Integer> getUsedResources(Matrix m) {
        HashSet<Integer> resources = new HashSet<Integer>();
        int resId = 0;
        while (resId < m.getRows()) {
            if (MatrixDependencies.isResourceUsed(m, resId)) {
                resources.add(resId);
            }
            ++resId;
        }
        return resources;
    }

    private static boolean isResourceUsed(Matrix m, Integer resId) {
        return !MatrixDependencies.isIdentityRow(m, resId) || !MatrixDependencies.isIdentityColumn(m, resId);
    }

    private static boolean isIdentityRow(Matrix m, Integer row) {
        int column = 0;
        while (column < m.getColumns()) {
            Value v = m.get(row, column);
            if (row == column ? !v.equals(new Value(0.0)) : !v.equals(new Value(Double.NEGATIVE_INFINITY))) {
                return false;
            }
            ++column;
        }
        return true;
    }

    private static boolean isIdentityColumn(Matrix m, Integer column) {
        int row = 0;
        while (row < m.getRows()) {
            Value v = m.get(row, column);
            if (row == column ? !v.equals(new Value(0.0)) : !v.equals(new Value(Double.NEGATIVE_INFINITY))) {
                return false;
            }
            ++row;
        }
        return true;
    }
}

