/**
 */
package distributions.impl;

import distributions.DistributionsPackage;
import distributions.EnumeratedDistribution;

import distributions.math.ModeDistribution;

import expressions.Expression;

import expressions.impl.ExpressionImpl;

import java.lang.reflect.InvocationTargetException;

import java.math.BigDecimal;

import java.util.Collection;

import org.apache.commons.math3.random.RandomGenerator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Enumerated Distribution</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link distributions.impl.EnumeratedDistributionImpl#getDefault <em>Default</em>}</li>
 *   <li>{@link distributions.impl.EnumeratedDistributionImpl#getDefaultExp <em>Default Exp</em>}</li>
 *   <li>{@link distributions.impl.EnumeratedDistributionImpl#getModeDistributionInstance <em>Mode Distribution Instance</em>}</li>
 *   <li>{@link distributions.impl.EnumeratedDistributionImpl#getValues <em>Values</em>}</li>
 *   <li>{@link distributions.impl.EnumeratedDistributionImpl#getValuesExp <em>Values Exp</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EnumeratedDistributionImpl extends ExpressionImpl implements EnumeratedDistribution
{
    /**
     * The default value of the '{@link #getDefault() <em>Default</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDefault()
     * @generated
     * @ordered
     */
    protected static final BigDecimal DEFAULT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDefaultExp() <em>Default Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDefaultExp()
     * @generated
     * @ordered
     */
    protected Expression defaultExp;

    /**
     * The default value of the '{@link #getModeDistributionInstance() <em>Mode Distribution Instance</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeDistributionInstance()
     * @generated
     * @ordered
     */
    protected static final ModeDistribution MODE_DISTRIBUTION_INSTANCE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getModeDistributionInstance() <em>Mode Distribution Instance</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeDistributionInstance()
     * @generated
     * @ordered
     */
    protected ModeDistribution modeDistributionInstance = MODE_DISTRIBUTION_INSTANCE_EDEFAULT;

    /**
     * The cached value of the '{@link #getValuesExp() <em>Values Exp</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getValuesExp()
     * @generated
     * @ordered
     */
    protected EList<Expression> valuesExp;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EnumeratedDistributionImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return DistributionsPackage.Literals.ENUMERATED_DISTRIBUTION;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getDefault()
    {
        return defaultExp==null ? null:  defaultExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getDefaultExp()
    {
        return defaultExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetDefaultExp(Expression newDefaultExp, NotificationChain msgs)
    {
        Expression oldDefaultExp = defaultExp;
        defaultExp = newDefaultExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT_EXP, oldDefaultExp, newDefaultExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setDefaultExp(Expression newDefaultExp)
    {
        if (newDefaultExp != defaultExp)
        {
            NotificationChain msgs = null;
            if (defaultExp != null)
                msgs = ((InternalEObject)defaultExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT_EXP, null, msgs);
            if (newDefaultExp != null)
                msgs = ((InternalEObject)newDefaultExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT_EXP, null, msgs);
            msgs = basicSetDefaultExp(newDefaultExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT_EXP, newDefaultExp, newDefaultExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution getModeDistributionInstance()
    {
        return modeDistributionInstance;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setModeDistributionInstance(ModeDistribution newModeDistributionInstance)
    {
        ModeDistribution oldModeDistributionInstance = modeDistributionInstance;
        modeDistributionInstance = newModeDistributionInstance;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.ENUMERATED_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE, oldModeDistributionInstance, modeDistributionInstance));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<BigDecimal> getValues()
    {
        return valuesExp==null ? null:  new org.eclipse.emf.common.util.BasicEList<BigDecimal>(valuesExp.stream().map(e->e.evaluate()).collect(java.util.stream.Collectors.toList()));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<Expression> getValuesExp()
    {
        if (valuesExp == null)
        {
            valuesExp = new EObjectContainmentEList<Expression>(Expression.class, this, DistributionsPackage.ENUMERATED_DISTRIBUTION__VALUES_EXP);
        }
        return valuesExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution createModeDistribution(final RandomGenerator generator)
    {
        return new distributions.math.EnumeratedModeDistribution(generator, 
           getValues().stream().mapToDouble(java.math.BigDecimal::doubleValue).toArray(), 
            null == getDefault() ? null : getDefault().doubleValue()
        );
        
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal evaluate()
    {
        var adapter =  distributions.DistributionsAdapter.getAdapter(this);
        var mode = adapter.getCalculationMode();
        if( mode == distributions.CalculationMode.DISTRIBUTED ){
            if( adapter.getRandomGenerator() == null ){
                throw new IllegalArgumentException("To use CalculationMode.DISTRIBUTED you'll have to set a RandomGenerator on Distributions");
            }
            return BigDecimal.valueOf(getModeDistribution().nextSample());
        }
        return BigDecimal.valueOf(getModeDistribution().getDefault());
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution getModeDistribution()
    {
        if( modeDistributionInstance == null){
            var adapter = distributions.DistributionsAdapter.getAdapter(this);
            if( adapter.getCalculationMode()==distributions.CalculationMode.DISTRIBUTED && adapter.getRandomGenerator() == null ){
                throw new IllegalArgumentException("To use CalculationMode.DISTRIBUTED you'll have to set a RandomGenerator on DistributionsAdapter");
            }
            setModeDistributionInstance( createModeDistribution(adapter.getRandomGenerator()) );
        }
        return modeDistributionInstance;
        
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT_EXP:
                return basicSetDefaultExp(null, msgs);
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__VALUES_EXP:
                return ((InternalEList<?>)getValuesExp()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT:
                return getDefault();
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT_EXP:
                return getDefaultExp();
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                return getModeDistributionInstance();
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__VALUES:
                return getValues();
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__VALUES_EXP:
                return getValuesExp();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT_EXP:
                setDefaultExp((Expression)newValue);
                return;
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                setModeDistributionInstance((ModeDistribution)newValue);
                return;
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__VALUES_EXP:
                getValuesExp().clear();
                getValuesExp().addAll((Collection<? extends Expression>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT_EXP:
                setDefaultExp((Expression)null);
                return;
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                setModeDistributionInstance(MODE_DISTRIBUTION_INSTANCE_EDEFAULT);
                return;
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__VALUES_EXP:
                getValuesExp().clear();
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT:
                return DEFAULT_EDEFAULT == null ? getDefault() != null : !DEFAULT_EDEFAULT.equals(getDefault());
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__DEFAULT_EXP:
                return defaultExp != null;
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                return MODE_DISTRIBUTION_INSTANCE_EDEFAULT == null ? modeDistributionInstance != null : !MODE_DISTRIBUTION_INSTANCE_EDEFAULT.equals(modeDistributionInstance);
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__VALUES:
                return !getValues().isEmpty();
            case DistributionsPackage.ENUMERATED_DISTRIBUTION__VALUES_EXP:
                return valuesExp != null && !valuesExp.isEmpty();
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
    {
        switch (operationID)
        {
            case DistributionsPackage.ENUMERATED_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR:
                return createModeDistribution((RandomGenerator)arguments.get(0));
            case DistributionsPackage.ENUMERATED_DISTRIBUTION___EVALUATE:
                return evaluate();
            case DistributionsPackage.ENUMERATED_DISTRIBUTION___GET_MODE_DISTRIBUTION:
                return getModeDistribution();
        }
        return super.eInvoke(operationID, arguments);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (modeDistributionInstance: ");
        result.append(modeDistributionInstance);
        result.append(')');
        return result.toString();
    }

} //EnumeratedDistributionImpl
