/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.zwick;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Triple;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.SingleWeightFunctionDouble;
import org.eclipse.lsat.common.ludus.backend.games.StrategyVector;
import org.eclipse.lsat.common.ludus.backend.games.algorithms.DoubleFunctions;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.MeanPayoffGame;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.zwick.ZPSolverDouble;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTEdge;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTGraph;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTVertex;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.meanpayoff.MPGDoubleImplJGraphT;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGDoubleImplJGraphT;

public class SolverZPDouble {
    private SolverZPDouble() {
    }

    public static Tuple<Map<JGraphTVertex, Double>, StrategyVector<JGraphTVertex, JGraphTEdge>> solve(RGDoubleImplJGraphT game) {
        return SolverZPDouble.solve(game, 1.0E-4);
    }

    public static Tuple<Map<JGraphTVertex, Double>, StrategyVector<JGraphTVertex, JGraphTEdge>> solve(RGDoubleImplJGraphT game, Double epsilon) {
        Map<JGraphTVertex, Double> values = SolverZPDouble.getValues(game, epsilon);
        StrategyVector strategyVector = new StrategyVector();
        for (JGraphTVertex vertex : game.getVertices()) {
            HashSet<JGraphTEdge> outgoing = new HashSet<JGraphTEdge>(game.outgoingEdgesOf(vertex));
            JGraphTEdge edge = SolverZPDouble.findOutgoingEdge(game, vertex, values.get(vertex), outgoing, epsilon);
            strategyVector.setSuccessor(vertex, game.getEdgeTarget(edge));
        }
        return Tuple.of(values, strategyVector);
    }

    public static Map<JGraphTVertex, Double> getValues(RGDoubleImplJGraphT game) {
        return SolverZPDouble.getValues(game, 1.0E-4);
    }

    public static Map<JGraphTVertex, Double> getValues(RGDoubleImplJGraphT game, Double epsilon) {
        HashMap<JGraphTVertex, Double> valueMap = new HashMap<JGraphTVertex, Double>();
        Integer vSize = game.getVertices().size();
        Double w = game.getMaxAbsValue();
        Double lowerBound = 0.0;
        Double upperBound = (double)vSize.intValue() * w * 1.0;
        for (JGraphTVertex v : game.getVertices()) {
            Double value = SolverZPDouble.getValue(game, v, lowerBound, upperBound, epsilon);
            valueMap.put(v, value);
        }
        return valueMap;
    }

    private static JGraphTEdge findOutgoingEdge(RGDoubleImplJGraphT game, JGraphTVertex vertex, Double oldValue, Set<JGraphTEdge> outgoing, Double epsilon) {
        if (outgoing.size() < 2) {
            return outgoing.iterator().next();
        }
        Double halve = Math.ceil((double)outgoing.size() / 2.0);
        Integer leftHalveSize = halve.intValue();
        Iterator<JGraphTEdge> outgoingEdgeIterator = outgoing.iterator();
        HashSet<JGraphTEdge> outgoingLeftHalve = new HashSet<JGraphTEdge>();
        HashSet<JGraphTEdge> outgoingRightHalve = new HashSet<JGraphTEdge>();
        int i = 0;
        while (i < outgoing.size()) {
            if (i < leftHalveSize) {
                outgoingLeftHalve.add(outgoingEdgeIterator.next());
            } else {
                outgoingRightHalve.add(outgoingEdgeIterator.next());
            }
            ++i;
        }
        HashSet<JGraphTEdge> subGraphEdges = new HashSet<JGraphTEdge>(game.getEdges());
        subGraphEdges.removeAll(outgoingRightHalve);
        RGDoubleImplJGraphT subGraph = game.getSubGraphEdges(subGraphEdges);
        Map<JGraphTVertex, Double> newValues = SolverZPDouble.getValues(subGraph, epsilon);
        Double newValue = newValues.get(vertex);
        if (DoubleFunctions.equalTo(newValue, oldValue, epsilon)) {
            return SolverZPDouble.findOutgoingEdge(game, vertex, newValue, outgoingLeftHalve, epsilon);
        }
        return SolverZPDouble.findOutgoingEdge(game, vertex, newValue, outgoingRightHalve, epsilon);
    }

    private static Double getValue(RGDoubleImplJGraphT game, JGraphTVertex vertex, Double lowerBoundRatio, Double upperBoundRatio, Double epsilon) {
        Double middle = (lowerBoundRatio + upperBoundRatio) / 2.0;
        MeanPayoffGame<JGraphTVertex, JGraphTEdge, Double> mpg = SolverZPDouble.convertToMeanPayoffGame(game, middle);
        Triple<Set<JGraphTVertex>, Set<JGraphTVertex>, Set<JGraphTVertex>> split = ZPSolverDouble.getThreeWayPartition(mpg, 0.0, epsilon);
        if (split.getMiddle().contains(vertex)) {
            return middle;
        }
        if (split.getLeft().contains(vertex)) {
            return SolverZPDouble.getValue(game, vertex, lowerBoundRatio, middle, epsilon);
        }
        return SolverZPDouble.getValue(game, vertex, middle, upperBoundRatio, epsilon);
    }

    private static MeanPayoffGame<JGraphTVertex, JGraphTEdge, Double> convertToMeanPayoffGame(RGDoubleImplJGraphT game, Double value) {
        JGraphTGraph graph = game.getGraph();
        SingleWeightFunctionDouble<JGraphTEdge> wf = new SingleWeightFunctionDouble<JGraphTEdge>();
        for (JGraphTEdge e : graph.getEdges()) {
            wf.addWeight(e, 1.0 * game.getWeight1(e) - value * game.getWeight2(e));
        }
        return new MPGDoubleImplJGraphT(graph, wf);
    }
}

