/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.memcheck;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.valgrind.memcheck.MemcheckLaunchConstants;
import org.eclipse.linuxtools.valgrind.launch.IValgrindLaunchDelegate;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.osgi.framework.Version;

public class MemcheckLaunchDelegate
implements IValgrindLaunchDelegate {
    private static final Version VER_3_4_0 = new Version(3, 4, 0);
    private static final Version VER_3_6_0 = new Version(3, 6, 0);
    private static final String EQUALS = "=";
    private static final String NO = "no";
    private static final String YES = "yes";
    private static final String HEX = "0x";

    public void handleLaunch(ILaunchConfiguration config, ILaunch launch, IPath outDir, IProgressMonitor monitor) {
    }

    public String[] getCommandArray(ILaunchConfiguration config, Version ver, IPath logDir) throws CoreException {
        ArrayList<CallSite> opts = new ArrayList<CallSite>();
        opts.add((CallSite)((Object)("--leak-check=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKCHECK", true) ? YES : NO))));
        opts.add((CallSite)((Object)("--show-reachable=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_SHOWREACH", false) ? YES : NO))));
        opts.add((CallSite)((Object)("--leak-resolution=" + config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKRES", "high"))));
        opts.add((CallSite)((Object)("--freelist-vol=" + config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREELIST", 10000000))));
        opts.add((CallSite)((Object)("--workaround-gcc296-bugs=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_GCCWORK", false) ? YES : NO))));
        opts.add((CallSite)((Object)("--partial-loads-ok=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_PARTIAL", false) ? YES : NO))));
        opts.add((CallSite)((Object)("--undef-value-errors=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF", true) ? YES : NO))));
        if (config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_BOOL", false)) {
            opts.add((CallSite)((Object)("--alignment=" + config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_VAL", 0))));
        }
        if ((ver == null || ver.compareTo(VER_3_4_0) >= 0) && config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_TRACKORIGINS", false)) {
            opts.add((CallSite)((Object)("--track-origins=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_TRACKORIGINS", false) ? YES : NO))));
        }
        if (!(ver != null && ver.compareTo(VER_3_6_0) < 0 || config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_POSSIBLY_LOST", true))) {
            opts.add((CallSite)((Object)("--show-possibly-lost=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_POSSIBLY_LOST", true) ? YES : NO))));
        }
        if (config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_MALLOCFILL_BOOL", false)) {
            opts.add((CallSite)((Object)("--malloc-fill=0x" + config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_MALLOCFILL_VAL", ""))));
        }
        if (config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREEFILL_BOOL", false)) {
            opts.add((CallSite)((Object)("--free-fill=0x" + config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREEFILL_VAL", ""))));
        }
        List ignoreRangesFns = config.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_IGNORE_RANGES", MemcheckLaunchConstants.DEFAULT_MEMCHECK_IGNORE_RANGES);
        for (String func : ignoreRangesFns) {
            opts.add((CallSite)((Object)("--ignore-ranges=" + func)));
        }
        return opts.toArray(new String[opts.size()]);
    }

    public void initializeView(IValgrindToolView view, String contentDescription, IProgressMonitor monitor) {
    }
}

