/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.linuxtools.docker.core.IDockerDevice;
import org.mandas.docker.client.messages.Device;

public class DockerDevice
implements IDockerDevice {
    private final String pathOnHost;
    private final String pathInContainer;
    private final String cgroupPermissions;

    public DockerDevice(Device device) {
        this.pathOnHost = device.pathOnHost();
        this.pathInContainer = device.pathInContainer();
        this.cgroupPermissions = device.cgroupPermissions();
    }

    private DockerDevice(Builder builder) {
        this.pathOnHost = builder.pathOnHost;
        this.pathInContainer = builder.pathInContainer;
        this.cgroupPermissions = builder.cgroupPermissions;
    }

    @Override
    public String pathOnHost() {
        return this.pathOnHost;
    }

    @Override
    public String pathInContainer() {
        return this.pathInContainer;
    }

    @Override
    public String cgroupPermissions() {
        return this.cgroupPermissions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String pathOnHost;
        private String pathInContainer;
        private String cgroupPermissions;

        public Builder pathOnHost(String pathOnHost) {
            this.pathOnHost = pathOnHost;
            return this;
        }

        public Builder pathInContainer(String pathInContainer) {
            this.pathInContainer = pathInContainer;
            return this;
        }

        public Builder cgroupsPermission(String cgroupsPermission) {
            this.cgroupPermissions = cgroupsPermission;
            return this;
        }

        public IDockerDevice build() {
            return new DockerDevice(this);
        }
    }
}

