/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.CreateVMPageModel;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.WizardMessages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class CreateVMAdvancedComposite
extends ExpandableComposite {
    private CreateVMPageModel model;
    private final TableViewer tv;
    private static final String KEY = WizardMessages.getString("CreateVMAdvancedComposite.Key");
    private static final String VALUE = WizardMessages.getString("CreateVMAdvancedComposite.Value");
    private static final String DEFAULT_KEY = WizardMessages.getString("CreateVMAdvancedComposite.DefaultKey");
    private static final String DEFAULT_VALUE = WizardMessages.getString("CreateVMAdvancedComposite.DefaultValue");
    private String[] KEY_VALUE = new String[]{KEY, VALUE};

    public CreateVMAdvancedComposite(final Composite parent, final ScrolledComposite scrollTop, final CreateVMPageModel model) {
        super(parent, 2146);
        this.model = model;
        this.setText(WizardMessages.getString("CreateVMAdvancedComposite.EnvironmentVariables"));
        Composite advancedComposite = new Composite((Composite)this, 0);
        this.setClient((Control)advancedComposite);
        this.addExpansionListener((IExpansionListener)new ExpansionAdapter(this){

            public void expansionStateChanged(ExpansionEvent e) {
                Shell shell = parent.getShell();
                Point minSize = shell.getMinimumSize();
                shell.setMinimumSize(shell.getSize().x, minSize.y);
                Point point = parent.computeSize(-1, -1);
                scrollTop.setSize(point);
                scrollTop.setMinSize(point);
                shell.pack();
                parent.layout();
                shell.setMinimumSize(minSize);
            }
        });
        advancedComposite.setLayout((Layout)new GridLayout());
        this.tv = new TableViewer(advancedComposite, 67584);
        this.tv.setContentProvider((IContentProvider)new EnvironmentContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new EnvironmentLabelProvider());
        Table table = this.tv.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        TableColumn tc1 = new TableColumn(table, 0x1000000);
        TableColumn tc2 = new TableColumn(table, 0x1000000);
        tc1.setText(KEY);
        tc2.setText(VALUE);
        tc1.setWidth(250);
        tc2.setWidth(150);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
        this.tv.setColumnProperties(this.KEY_VALUE);
        this.tv.setCellModifier((ICellModifier)new EnvironmentCellModifier());
        this.tv.setCellEditors(editors);
        this.tv.setInput((Object)ResourcesPlugin.getWorkspace());
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String varToAdd = DEFAULT_KEY;
                int i = 1;
                if (model.getEnvironment().containsKey(varToAdd)) {
                    boolean done = false;
                    while (!done) {
                        String toTest = varToAdd + " (" + i++ + ")";
                        if (model.getEnvironment().containsKey(toTest)) continue;
                        model.getEnvironment().put(toTest, DEFAULT_VALUE);
                        done = true;
                    }
                } else {
                    model.getEnvironment().put(varToAdd, DEFAULT_VALUE);
                }
                CreateVMAdvancedComposite.this.tv.refresh();
            }
        });
    }

    public void refresh() {
        if (this.tv != null && !this.tv.getTable().isDisposed()) {
            this.tv.refresh();
        }
    }

    private class EnvironmentContentProvider
    implements IStructuredContentProvider {
        private EnvironmentContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            final Map<String, String> env = CreateVMAdvancedComposite.this.model.getEnvironment();
            if (env != null) {
                ArrayList<String> keys = new ArrayList<String>(env.keySet());
                Collections.sort(keys, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        boolean o1IsDefaultValue = ((String)env.get(o1)).equals(DEFAULT_VALUE);
                        boolean o2IsDefaultValue = ((String)env.get(o2)).equals(DEFAULT_VALUE);
                        if (o1IsDefaultValue) {
                            if (o2IsDefaultValue) {
                                return o1.compareTo(o2);
                            }
                            return 1;
                        }
                        if (o2IsDefaultValue) {
                            return -1;
                        }
                        if (o1.startsWith(DEFAULT_KEY)) {
                            if (o2.startsWith(DEFAULT_KEY)) {
                                return ((String)env.get(o1)).compareTo((String)env.get(o2));
                            }
                            return 1;
                        }
                        if (o2.startsWith(DEFAULT_KEY)) {
                            return -1;
                        }
                        return o1.compareTo(o2);
                    }
                });
                return keys.toArray(new String[keys.size()]);
            }
            return new String[0];
        }
    }

    private class EnvironmentLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private EnvironmentLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return (String)element;
            }
            if (columnIndex == 1) {
                return CreateVMAdvancedComposite.this.model.getEnvironment().get(element);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private class EnvironmentCellModifier
    implements ICellModifier {
        private EnvironmentCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            if (property == KEY) {
                return element;
            }
            if (property == VALUE) {
                return CreateVMAdvancedComposite.this.model.getEnvironment().get(element);
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            String data = (String)((TableItem)element).getData();
            if (property == KEY) {
                String v = (String)value;
                if (v == null || v.isEmpty()) {
                    CreateVMAdvancedComposite.this.model.getEnvironment().remove(data);
                } else {
                    String currentVal = CreateVMAdvancedComposite.this.model.getEnvironment().get(data);
                    CreateVMAdvancedComposite.this.model.getEnvironment().remove(data);
                    CreateVMAdvancedComposite.this.model.getEnvironment().put((String)value, currentVal);
                }
            } else if (property == VALUE) {
                String v = (String)value;
                if (v == null || v.isEmpty()) {
                    CreateVMAdvancedComposite.this.model.getEnvironment().remove(data);
                } else {
                    CreateVMAdvancedComposite.this.model.getEnvironment().put(data, (String)value);
                }
            }
            CreateVMAdvancedComposite.this.tv.refresh();
        }
    }
}

