/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import org.eclipse.lemminx.utils.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilsTest {
    @Test
    public void testTrimOfOneNewLine() {
        StringUtilsTest.assertTrimNewLines("\r", "");
        StringUtilsTest.assertTrimNewLines("\n", "");
        StringUtilsTest.assertTrimNewLines("\r\n", "");
    }

    @Test
    public void testNoTrim() {
        StringUtilsTest.assertTrimNewLines(" ", " ");
        StringUtilsTest.assertTrimNewLines("  abcd  ", "  abcd  ");
        StringUtilsTest.assertTrimNewLines("  a\rbcd  ", "  a\rbcd  ");
        StringUtilsTest.assertTrimNewLines("  a\nbcd  ", "  a\nbcd  ");
        StringUtilsTest.assertTrimNewLines("  a\r\nbcd  ", "  a\r\nbcd  ");
    }

    @Test
    public void testTrimOfSpace() {
        StringUtilsTest.assertTrimNewLines(" ", " ");
        StringUtilsTest.assertTrimNewLines("\r \r", " ");
        StringUtilsTest.assertTrimNewLines("\r\n \r\n", " ");
        StringUtilsTest.assertTrimNewLines(" \n \n ", " ");
        StringUtilsTest.assertTrimNewLines("      \r\n \r\n       ", " ");
    }

    @Test
    public void testTrimWhichContainsNewLine() {
        StringUtilsTest.assertTrimNewLines(" \r abc\rdef", " abc\rdef");
        StringUtilsTest.assertTrimNewLines("   abc\rdef", "   abc\rdef");
    }

    @Test
    public void testGetOffsetAfterWhitespace() {
        Assertions.assertEquals((int)4, (int)StringUtils.getOffsetAfterWhitespace((String)"abc 123", (int)7));
        Assertions.assertEquals((int)4, (int)StringUtils.getOffsetAfterWhitespace((String)"abc 123", (int)6));
        Assertions.assertEquals((int)-1, (int)StringUtils.getOffsetAfterWhitespace((String)"abc 123", (int)4));
        Assertions.assertEquals((int)0, (int)StringUtils.getOffsetAfterWhitespace((String)"123", (int)3));
        Assertions.assertEquals((int)-1, (int)StringUtils.getOffsetAfterWhitespace((String)"123", (int)0));
    }

    @Test
    public void testIsTagOutsideOfBackTicks() {
        Assertions.assertFalse((boolean)StringUtils.isTagOutsideOfBackticks((String)"abc `<def></def>`"));
        Assertions.assertFalse((boolean)StringUtils.isTagOutsideOfBackticks((String)"abc `<def>` abc"));
        Assertions.assertFalse((boolean)StringUtils.isTagOutsideOfBackticks((String)"asd `<abc></abc>"));
        Assertions.assertFalse((boolean)StringUtils.isTagOutsideOfBackticks((String)"`<hij></hij>`"));
        Assertions.assertFalse((boolean)StringUtils.isTagOutsideOfBackticks((String)""));
        Assertions.assertFalse((boolean)StringUtils.isTagOutsideOfBackticks((String)"A"));
        Assertions.assertTrue((boolean)StringUtils.isTagOutsideOfBackticks((String)"<A></A>"));
        Assertions.assertTrue((boolean)StringUtils.isTagOutsideOfBackticks((String)"test `<a></a>` <A></A>"));
        Assertions.assertTrue((boolean)StringUtils.isTagOutsideOfBackticks((String)"<A></A> `<a></a>`"));
        Assertions.assertTrue((boolean)StringUtils.isTagOutsideOfBackticks((String)"<A> `<a></a>`"));
    }

    @Test
    public void testGetString() {
        StringBuilder buffer = new StringBuilder();
        String bufferText = "This is buffer text";
        buffer.append(bufferText);
        Assertions.assertEquals((Object)bufferText, (Object)StringUtils.getString((Object)buffer));
        String regularText = "This is regular text";
        Assertions.assertEquals((Object)regularText, (Object)StringUtils.getString((Object)regularText));
    }

    private static void assertTrimNewLines(String valueToTrim, String expected) {
        String actual = StringUtils.trimNewLines((String)valueToTrim);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

