/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.settings;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterMaxLineWithTest
extends AbstractCacheBasedTest {
    @Test
    public void splitText() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(6);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a>abcde fghi</a>";
        String expected = "<a>abcde" + System.lineSeparator() + "  fghi</a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 9, System.lineSeparator() + "  "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitTextWithSpace() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(6);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a> abcde fghi</a>";
        String expected = "<a>" + System.lineSeparator() + "  abcde" + System.lineSeparator() + "  fghi</a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 0, 4, System.lineSeparator() + "  "), XMLAssert.te(0, 9, 0, 10, System.lineSeparator() + "  "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitMixedText() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(5);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a><b /> efgh</a>";
        String expected = "<a><b />" + System.lineSeparator() + "  efgh</a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 9, System.lineSeparator() + "  "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void noSplit() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(20);
        settings.getFormattingSettings().setJoinContentLines(true);
        String expected = content = "<a>abcde fghi</a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttribute() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setMaxLineWidth(20);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<aaaaaaaaa bb=\"tes t\" c=\"a\" d=\"a\" e=\"a\"> </aaaaaaaaa>";
        String expected = "<aaaaaaaaa" + System.lineSeparator() + "    bb=\"tes t\" c=\"a\"" + System.lineSeparator() + "    d=\"a\" e=\"a\"> </aaaaaaaaa>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 10, 0, 11, System.lineSeparator() + "    "), XMLAssert.te(0, 27, 0, 28, System.lineSeparator() + "    "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeMultiLine() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setMaxLineWidth(10);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a bb=\"a\" c=\"a\" d=\"a\" e=\"a\"> </a>";
        String expected = "<a bb=\"a\"" + System.lineSeparator() + "    c=\"a\"" + System.lineSeparator() + "    d=\"a\"" + System.lineSeparator() + "    e=\"a\"> </a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 9, 0, 10, System.lineSeparator() + "    "), XMLAssert.te(0, 15, 0, 16, System.lineSeparator() + "    "), XMLAssert.te(0, 21, 0, 22, System.lineSeparator() + "    "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeWithChild() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setMaxLineWidth(10);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a bb=\"a\" c=\"a\" d=\"a\" e=\"a\"> <b bb=\"a\" c=\"a\" d=\"a\" e=\"a\"> </b> </a>";
        String expected = "<a bb=\"a\"" + System.lineSeparator() + "    c=\"a\"" + System.lineSeparator() + "    d=\"a\"" + System.lineSeparator() + "    e=\"a\">" + System.lineSeparator() + "    <b" + System.lineSeparator() + "        bb=\"a\"" + System.lineSeparator() + "        c=\"a\"" + System.lineSeparator() + "        d=\"a\"" + System.lineSeparator() + "        e=\"a\"> </b>" + System.lineSeparator() + "</a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 9, 0, 10, System.lineSeparator() + "    "), XMLAssert.te(0, 15, 0, 16, System.lineSeparator() + "    "), XMLAssert.te(0, 21, 0, 22, System.lineSeparator() + "    "), XMLAssert.te(0, 28, 0, 29, System.lineSeparator() + "    "), XMLAssert.te(0, 31, 0, 32, System.lineSeparator() + "        "), XMLAssert.te(0, 38, 0, 39, System.lineSeparator() + "        "), XMLAssert.te(0, 44, 0, 45, System.lineSeparator() + "        "), XMLAssert.te(0, 50, 0, 51, System.lineSeparator() + "        "), XMLAssert.te(0, 62, 0, 63, System.lineSeparator()));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeMixedDontSplit() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        settings.getFormattingSettings().setMaxLineWidth(10);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a bb=\"test\"> <b/> h </a>";
        String expected = "<a" + System.lineSeparator() + "    bb=\"test\">" + System.lineSeparator() + "    <b/> h </a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, System.lineSeparator() + "    "), XMLAssert.te(0, 13, 0, 14, System.lineSeparator() + "    "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeMixedSplit() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        settings.getFormattingSettings().setMaxLineWidth(10);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a bb=\"test\"> <b/> gh </a>";
        String expected = "<a" + System.lineSeparator() + "    bb=\"test\">" + System.lineSeparator() + "    <b/>" + System.lineSeparator() + "    gh </a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, System.lineSeparator() + "    "), XMLAssert.te(0, 13, 0, 14, System.lineSeparator() + "    "), XMLAssert.te(0, 18, 0, 19, System.lineSeparator() + "    "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeNested() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setMaxLineWidth(10);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a bb=\"test\"> <b c=\"test\"> </b>  </a>";
        String expected = "<a" + System.lineSeparator() + "    bb=\"test\">" + System.lineSeparator() + "    <b" + System.lineSeparator() + "        c=\"test\"> </b>" + System.lineSeparator() + "</a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, System.lineSeparator() + "    "), XMLAssert.te(0, 13, 0, 14, System.lineSeparator() + "    "), XMLAssert.te(0, 16, 0, 17, System.lineSeparator() + "        "), XMLAssert.te(0, 31, 0, 33, System.lineSeparator()));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeKeepSameLine() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setMaxLineWidth(20);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<aaaaaaaaa bb=\"t tt\" c=\"a\" d=\"a\" e=\"a\"> </aaaaaaaaa>";
        String expected = "<aaaaaaaaa bb=\"t tt\"" + System.lineSeparator() + "    c=\"a\" d=\"a\"" + System.lineSeparator() + "    e=\"a\"> </aaaaaaaaa>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 20, 0, 21, System.lineSeparator() + "    "), XMLAssert.te(0, 32, 0, 33, System.lineSeparator() + "    "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeInvalid() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setMaxLineWidth(10);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a bb=>    </a>";
        String expected = "<a bb=> </a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 7, 0, 11, " "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeInvalidSingleQuote() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setMaxLineWidth(10);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a bb=\">    </a>";
        String expected = "<a" + System.lineSeparator() + "    bb=\">    </a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, System.lineSeparator() + "    "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeInvalidSpace() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setMaxLineWidth(10);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a bb = >    </a>";
        String expected = "<a bb=> </a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 0, 6, ""), XMLAssert.te(0, 7, 0, 8, ""), XMLAssert.te(0, 9, 0, 13, " "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeInvalidSpaceSingleQuote() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setMaxLineWidth(10);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a bb = \" >    </a>";
        String expected = "<a" + System.lineSeparator() + "    bb=\" >    </a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, System.lineSeparator() + "    "), XMLAssert.te(0, 5, 0, 6, ""), XMLAssert.te(0, 7, 0, 8, ""));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitWithAttributeInvalidSpaceQuoted() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setMaxLineWidth(10);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a bb = \" \" >    </a>";
        String expected = "<a bb=\" \"> </a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 0, 6, ""), XMLAssert.te(0, 7, 0, 8, ""), XMLAssert.te(0, 11, 0, 12, ""), XMLAssert.te(0, 13, 0, 17, " "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void longText() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(20);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<foo>\r\n\t<para>    \r\n\t\tvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\r\n\t</para>\r\n</foo>";
        String expected = "<foo>\r\n  <para>\r\n    vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\r\n  </para>\r\n</foo>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 1, 1, "\r\n  "), XMLAssert.te(1, 7, 2, 2, "\r\n    "), XMLAssert.te(2, 102, 3, 1, "\r\n  "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void complex() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(80);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<ip_log  version=\"1.0\">\r\n  <project id=\"org.apache.ant\" version=\"1.10.12\" status=\"done\">\r\n    <info>\r\n      <name>Apache            Ant (all-in-one) ffffffffffffffffff        fffffffffffffffffffffffff    ggggggggggggggg</name>\r\n      <repository>scm:git:git.eclipse.org:/gitroot/orbit/recipes.git</repository>\r\n      <location>apache-parent/ant/org.apache.ant</location>\r\n    </info>\r\n    <contact>\r\n      <name>Sarika          \r\n        Sinha</name>\r\n      <email>sarika.\r\n        \r\n        \r\n        sinha@in.ibm.com</email>\r\n      <company>IBM</company>\r\n    </contact>\r\n  </project>\r\n</ip_log>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<ip_log version=\"1.0\">\r\n  <project id=\"org.apache.ant\" version=\"1.10.12\" status=\"done\">\r\n    <info>\r\n      <name>Apache Ant (all-in-one) ffffffffffffffffff fffffffffffffffffffffffff\r\n        ggggggggggggggg</name>\r\n      <repository>scm:git:git.eclipse.org:/gitroot/orbit/recipes.git</repository>\r\n      <location>apache-parent/ant/org.apache.ant</location>\r\n    </info>\r\n    <contact>\r\n      <name>Sarika Sinha</name>\r\n      <email>sarika. sinha@in.ibm.com</email>\r\n      <company>IBM</company>\r\n    </contact>\r\n  </project>\r\n</ip_log>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(1, 7, 1, 9, " "), XMLAssert.te(4, 18, 4, 30, " "), XMLAssert.te(4, 65, 4, 73, " "), XMLAssert.te(4, 98, 4, 102, "\r\n        "), XMLAssert.te(9, 18, 10, 8, " "), XMLAssert.te(11, 20, 14, 8, " "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void mixedText() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(130);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<para>All DocBook V5.0 elements are in the namespace <uri>http://docbook.org/ns/docbook</uri>. <acronym>XML <alt>Extensible Markup\r\n  Language</alt></acronym> namespaces are used to distinguish between different element sets. In the last few years, almost all new\r\n  XML grammars have used their own namespace. It is easy to create compound documents that contain elements from different XML\r\n  vocabularies. DocBook V5.0 is\r\n\r\n\r\n  <emphasis>following</emphasis> this\r\n  <emphasis>design</emphasis>/<emphasis>rule</emphasis>.\r\n\r\n  Using\r\n  namespaces in your documents is very easy. Consider this simple article marked up in DocBook V4.5:</para>";
        String expected = "<para>All DocBook V5.0 elements are in the namespace <uri>http://docbook.org/ns/docbook</uri>. <acronym>XML <alt>Extensible Markup\r\n  Language</alt></acronym> namespaces are used to distinguish between different element sets. In the last few years, almost all\r\n  new XML grammars have used their own namespace. It is easy to create compound documents that contain elements from different XML\r\n  vocabularies. DocBook V5.0 is <emphasis>following</emphasis> this <emphasis>design</emphasis>/<emphasis>rule</emphasis>. Using\r\n  namespaces in your documents is very easy. Consider this simple article marked up in DocBook V4.5:</para>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(1, 127, 1, 128, "\r\n  "), XMLAssert.te(1, 131, 2, 2, " "), XMLAssert.te(3, 31, 6, 2, " "), XMLAssert.te(6, 37, 7, 2, " "), XMLAssert.te(7, 56, 9, 2, " "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void mixedTextDefaultLineWidth() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(100);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<para>All DocBook V5.0 elements are in the namespace <uri>http://docbook.org/ns/docbook</uri>. <acronym>XML <alt>Extensible Markup\r\n  Language</alt></acronym> namespaces are used to distinguish between different element sets. In the last few years, almost all new\r\n  XML grammars have used their own namespace. It is easy to create compound documents that contain elements from different XML\r\n  vocabularies. DocBook V5.0 is\r\n\r\n\r\n  <emphasis>following</emphasis> this\r\n  <emphasis>design</emphasis>/<emphasis>rule</emphasis>.\r\n\r\n  Using\r\n  namespaces in your documents is very easy. Consider this simple article marked up in DocBook V4.5:</para>";
        String expected = "<para>All DocBook V5.0 elements are in the namespace <uri>http://docbook.org/ns/docbook</uri>. <acronym>\r\n  XML <alt>Extensible Markup Language</alt></acronym> namespaces are used to distinguish between\r\n  different element sets. In the last few years, almost all new XML grammars have used their own\r\n  namespace. It is easy to create compound documents that contain elements from different XML\r\n  vocabularies. DocBook V5.0 is <emphasis>following</emphasis> this <emphasis>design</emphasis>/<emphasis>\r\n  rule</emphasis>. Using namespaces in your documents is very easy. Consider this simple article\r\n  marked up in DocBook V4.5:</para>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 104, 0, 104, "\r\n  "), XMLAssert.te(0, 130, 1, 2, " "), XMLAssert.te(1, 69, 1, 70, "\r\n  "), XMLAssert.te(1, 131, 2, 2, " "), XMLAssert.te(2, 34, 2, 35, "\r\n  "), XMLAssert.te(3, 31, 6, 2, " "), XMLAssert.te(6, 37, 7, 2, " "), XMLAssert.te(7, 40, 7, 40, "\r\n  "), XMLAssert.te(7, 56, 9, 2, " "), XMLAssert.te(9, 7, 10, 2, " "), XMLAssert.te(10, 73, 10, 74, "\r\n  "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void mixedTextIsChild() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(130);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<parent>\r\n<para>All DocBook V5.0 elements are in the namespace <uri>http://docbook.org/ns/docbook</uri>. <acronym>XML <alt>Extensible Markup\r\n  Language</alt></acronym> namespaces are used to distinguish between different element sets. In the last few years, almost all new\r\n  XML grammars have used their own namespace. It is easy to create compound documents that contain elements from different XML\r\n  vocabularies. DocBook V5.0 is\r\n\r\n\r\n  <emphasis>following</emphasis> this\r\n  <emphasis>design</emphasis>/<emphasis>rule</emphasis>.\r\n\r\n  Using\r\n  namespaces in your documents is very easy. Consider this simple article marked up in DocBook V4.5:</para></parent> <para>All DocBook V5.0 elements are in the namespace <uri>http://docbook.org/ns/docbook</uri>. <acronym>XML <alt>Extensible Markup\r\n  Language</alt></acronym> namespaces are used to distinguish between different element sets. In the last few years, almost all\r\n  new XML grammars have used their own namespace. It is easy to create compound documents that contain elements from different XML\r\n  vocabularies. DocBook V5.0 is <emphasis>following</emphasis> this <emphasis>design</emphasis>/<emphasis>rule</emphasis>. Using\r\n  namespaces in your documents is very easy. Consider this simple article marked up in DocBook V4.5:</para>";
        String expected = "<parent>\r\n  <para>All DocBook V5.0 elements are in the namespace <uri>http://docbook.org/ns/docbook</uri>. <acronym>XML <alt>Extensible\r\n    Markup Language</alt></acronym> namespaces are used to distinguish between different element sets. In the last few years,\r\n    almost all new XML grammars have used their own namespace. It is easy to create compound documents that contain elements from\r\n    different XML vocabularies. DocBook V5.0 is <emphasis>following</emphasis> this <emphasis>design</emphasis>/<emphasis>rule</emphasis>.\r\n    Using namespaces in your documents is very easy. Consider this simple article marked up in DocBook V4.5:</para>\r\n</parent>\r\n<para>All DocBook V5.0 elements are in the namespace <uri>http://docbook.org/ns/docbook</uri>. <acronym>XML <alt>Extensible Markup\r\n  Language</alt></acronym> namespaces are used to distinguish between different element sets. In the last few years, almost all\r\n  new XML grammars have used their own namespace. It is easy to create compound documents that contain elements from different XML\r\n  vocabularies. DocBook V5.0 is <emphasis>following</emphasis> this <emphasis>design</emphasis>/<emphasis>rule</emphasis>. Using\r\n  namespaces in your documents is very easy. Consider this simple article marked up in DocBook V4.5:</para>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 1, 0, "\r\n  "), XMLAssert.te(1, 123, 1, 124, "\r\n    "), XMLAssert.te(1, 130, 2, 2, " "), XMLAssert.te(2, 116, 2, 117, "\r\n    "), XMLAssert.te(2, 131, 3, 2, " "), XMLAssert.te(3, 112, 3, 113, "\r\n    "), XMLAssert.te(3, 126, 4, 2, " "), XMLAssert.te(4, 31, 7, 2, " "), XMLAssert.te(7, 37, 8, 2, " "), XMLAssert.te(8, 56, 10, 2, "\r\n    "), XMLAssert.te(10, 7, 11, 2, " "), XMLAssert.te(11, 107, 11, 107, "\r\n"), XMLAssert.te(11, 116, 11, 117, "\r\n"));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void mixedTextNoJoinContentLines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(130);
        settings.getFormattingSettings().setJoinContentLines(false);
        String content = "<para>All DocBook V5.0 elements are in the namespace <uri>http://docbook.org/ns/docbook</uri>. <acronym>XML <alt>Extensible Markup\r\n  Language</alt></acronym> namespaces are used to distinguish between different element sets. In the last few years, almost all new\r\n  XML grammars have used their own namespace. It is easy to create compound documents that contain elements from different XML\r\n  vocabularies. DocBook V5.0 is\r\n\r\n\r\n  <emphasis>following</emphasis> this\r\n  <emphasis>design</emphasis>/<emphasis>rule</emphasis>.\r\n\r\n  Using\r\n  namespaces in your documents is very easy. Consider this simple article marked up in DocBook V4.5:</para>";
        String expected = "<para>All DocBook V5.0 elements are in the namespace <uri>http://docbook.org/ns/docbook</uri>. <acronym>XML <alt>Extensible Markup\r\n  Language</alt></acronym> namespaces are used to distinguish between different element sets. In the last few years, almost all\r\n  new XML grammars have used their own namespace. It is easy to create compound documents that contain elements from different XML\r\n  vocabularies. DocBook V5.0 is <emphasis>following</emphasis> this <emphasis>design</emphasis>/<emphasis>rule</emphasis>. Using\r\n  namespaces in your documents is very easy. Consider this simple article marked up in DocBook V4.5:</para>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(1, 127, 1, 128, "\r\n  "), XMLAssert.te(1, 131, 2, 2, " "), XMLAssert.te(3, 31, 6, 2, " "), XMLAssert.te(6, 37, 7, 2, " "), XMLAssert.te(7, 56, 9, 2, " "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void commentFormattingLineBreakingEarly() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(100);
        String expected = content = "<!--\r\n/*******************************************************************************\r\n * Lorem ipsum dolor sit amet, consectetur\r\n * \u00a9 Copyright adipiscing elit. In eget magna ornare,\r\n *\r\n * pharetra sapienvitae, iaculis purus. Sed et dignissim lacus.\r\n * Morbi condimentum nisi eget sem laoreet placerat.\r\n * Pellentesque diam elit, vehicula et auctor a, euismod a enim.\r\n *******************************************************************************/\r\n-->\r\n</foo>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void commentFormattingLineBreakingEarlyAtMaxLineWidth() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(100);
        String content = "<!--\r\n/*******************************************************************************\r\n * Lorem ipsum dolor sit amet, consectetur \u00a9 Copyright adipiscing elit. In eget magna ornare, tester\r\n *\r\n * pharetra sapienvitae, iaculis purus. Sed et dignissim lacus. Morbi condimentum nisi eget sem laoreet placerat.\r\n * Pellentesque diam elit, vehicula et auctor a, euismod a enim.\r\n *******************************************************************************/\r\n-->\r\n</foo>";
        String expected = "<!--\r\n/*******************************************************************************\r\n * Lorem ipsum dolor sit amet, consectetur \u00a9 Copyright adipiscing elit. In eget magna ornare, tester\r\n *\r\n * pharetra sapienvitae, iaculis purus. Sed et dignissim lacus. Morbi condimentum nisi eget sem\r\nlaoreet placerat.\r\n * Pellentesque diam elit, vehicula et auctor a, euismod a enim.\r\n *******************************************************************************/\r\n-->\r\n</foo>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(4, 95, 4, 96, "\r\n"));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void firstLineNoBreakAtMaxLineWidth() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(160);
        String content = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"></project>";
        String expected = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "  xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"></project>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 104, 0, 105, System.lineSeparator() + "  "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void firstLineNoBreakAtMaxLineWidthDefaultWidth() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(100);
        String content = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"></project>";
        String expected = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"" + System.lineSeparator() + "  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "  xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"></project>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, settings, XMLAssert.te(0, 50, 0, 51, System.lineSeparator() + "  "), XMLAssert.te(0, 104, 0, 105, System.lineSeparator() + "  "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, "test.xml", Boolean.FALSE, expectedEdits);
    }
}

