/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.HTMLTag;
import org.eclipse.lemminx.services.extensions.completion.CompletionParticipantAdapter;
import org.eclipse.lemminx.services.extensions.completion.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.jupiter.api.Test;

public class HTMLCompletionExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void testHTMLElementCompletion() throws BadLocationException {
        HTMLCompletionExtensionsTest.testCompletionFor("<|", XMLAssert.c("iframe", "<iframe/>", "<iframe"), XMLAssert.c("h1", "<h1/>", "<h1"), XMLAssert.c("div", "<div/>", "<div"));
        HTMLCompletionExtensionsTest.testCompletionFor("< |", XMLAssert.c("iframe", "<iframe/>", "<iframe"), XMLAssert.c("h1", "<h1/>", "<h1"), XMLAssert.c("div", "<div/>", "<div"));
        HTMLCompletionExtensionsTest.testCompletionFor("<h|", XMLAssert.c("html", "<html/>", "<html"), XMLAssert.c("h1", "<h1/>", "<h1"), XMLAssert.c("header", "<header/>", "<header"));
        HTMLCompletionExtensionsTest.testCompletionFor("<input|", XMLAssert.c("input", "<input/>", "<input"));
        HTMLCompletionExtensionsTest.testCompletionFor("<inp|ut", XMLAssert.c("input", "<input/>", "<input"));
        HTMLCompletionExtensionsTest.testCompletionFor("<|inp", XMLAssert.c("input", "<input/>", "<input"));
    }

    @Test
    public void testHTMLElementCompletionWithoutOpenStart() throws BadLocationException {
        HTMLCompletionExtensionsTest.testCompletionFor(" |", XMLAssert.c("iframe", "<iframe/>", "iframe"), XMLAssert.c("h1", "<h1/>", "h1"), XMLAssert.c("div", "<div/>", "div"));
        HTMLCompletionExtensionsTest.testCompletionFor("h|", XMLAssert.c("html", "<html/>", "html"), XMLAssert.c("h1", "<h1/>", "h1"), XMLAssert.c("header", "<header/>", "header"));
        HTMLCompletionExtensionsTest.testCompletionFor("input|", XMLAssert.c("input", "<input/>", "input"));
        HTMLCompletionExtensionsTest.testCompletionFor("inp|ut", XMLAssert.c("input", "<input/>", "input"));
        HTMLCompletionExtensionsTest.testCompletionFor("|inp", XMLAssert.c("input", "<input/>", "input"));
    }

    @Test
    public void testHTMLAttributeNameCompletion() throws BadLocationException {
        HTMLCompletionExtensionsTest.testCompletionFor("<input |", XMLAssert.c("type", "type=\"$1\""), XMLAssert.c("style", "style=\"$1\""), XMLAssert.c("onmousemove", "onmousemove=\"$1\""));
        HTMLCompletionExtensionsTest.testCompletionFor("<input t|", XMLAssert.c("type", "type=\"$1\""), XMLAssert.c("style", "style=\"$1\""));
        HTMLCompletionExtensionsTest.testCompletionFor("<input t|ype", XMLAssert.c("type", "type=\"$1\""), XMLAssert.c("style", "style=\"$1\""));
    }

    @Test
    public void testHTMLAttributeValueCompletion() throws BadLocationException {
        HTMLCompletionExtensionsTest.testCompletionFor("<input type=|", XMLAssert.c("text", "\"text\""), XMLAssert.c("checkbox", "\"checkbox\""));
    }

    @Test
    public void testHTMLOnXMLContentCompletion() throws BadLocationException {
        HTMLCompletionExtensionsTest.testCompletionFor("<input>|</input>", XMLAssert.c("Test replace range", "replacement text", XMLAssert.r(0, 7, 0, 7), null));
        HTMLCompletionExtensionsTest.testCompletionFor("<input> |</input>", XMLAssert.c("Test replace range", "replacement text", XMLAssert.r(0, 7, 0, 8), null));
        HTMLCompletionExtensionsTest.testCompletionFor("<input>| </input>", XMLAssert.c("Test replace range", "replacement text", XMLAssert.r(0, 7, 0, 8), null));
        HTMLCompletionExtensionsTest.testCompletionFor("<input>some extisti|ng text</input>", XMLAssert.c("Test replace range", "replacement text", XMLAssert.r(0, 7, 0, 26), null));
        HTMLCompletionExtensionsTest.testCompletionFor("<input>some extisti|ng <br/>text</input>", XMLAssert.c("Test replace range", "replacement text", XMLAssert.r(0, 7, 0, 22), null));
    }

    public static void testCompletionFor(String value, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor((XMLLanguageService)new HTMLLanguageService(), value, (String)null, null, null, null, true, expectedItems);
    }

    private static class HTMLLanguageService
    extends XMLLanguageService {
        public HTMLLanguageService() {
            super.registerCompletionParticipant((ICompletionParticipant)new HTMLCompletionParticipant());
        }

        class HTMLCompletionParticipant
        extends CompletionParticipantAdapter {
            HTMLCompletionParticipant() {
            }

            public void onTagOpen(ICompletionRequest completionRequest, ICompletionResponse completionResponse, CancelChecker cancelChecker) throws Exception {
                Range range = completionRequest.getReplaceRange();
                HTMLTag.HTML_TAGS.forEach(t -> {
                    String tag = t.getTag();
                    String label = t.getLabel();
                    CompletionItem item = new CompletionItem();
                    item.setLabel(tag);
                    item.setFilterText(completionRequest.getFilterForStartTagName(tag));
                    item.setKind(CompletionItemKind.Property);
                    item.setDocumentation(Either.forLeft((Object)label));
                    item.setTextEdit(Either.forLeft((Object)new TextEdit(range, "<" + tag + "/>")));
                    item.setInsertTextFormat(InsertTextFormat.PlainText);
                    completionResponse.addCompletionItem(item);
                });
            }

            public void onAttributeName(boolean generateValue, ICompletionRequest completionRequest, ICompletionResponse completionResponse, CancelChecker cancelChecker) {
                String[] attributes;
                String tag = completionRequest.getCurrentTag();
                HTMLTag htmlTag = HTMLTag.getHTMLTag(tag);
                if (htmlTag != null && (attributes = htmlTag.getAttributes()) != null) {
                    Range replaceRange = completionRequest.getReplaceRange();
                    for (String attribute : attributes) {
                        int index = attribute.indexOf(":");
                        if (index != -1) {
                            attribute = attribute.substring(0, index);
                        }
                        if (completionResponse.hasAttribute(attribute)) continue;
                        CompletionItem item = new CompletionItem();
                        item.setLabel(attribute);
                        item.setKind(CompletionItemKind.Value);
                        String value = generateValue ? "=\"$1\"" : "";
                        item.setTextEdit(Either.forLeft((Object)new TextEdit(replaceRange, attribute + value)));
                        item.setInsertTextFormat(InsertTextFormat.Snippet);
                        completionResponse.addCompletionAttribute(item);
                    }
                }
            }

            public void onAttributeValue(String valuePrefix, ICompletionRequest completionRequest, ICompletionResponse completionResponse, CancelChecker cancelChecker) {
                String[] attributes;
                String tag = completionRequest.getCurrentTag();
                String attributeName = completionRequest.getCurrentAttributeName();
                HTMLTag htmlTag = HTMLTag.getHTMLTag(tag);
                if (htmlTag != null && (attributes = htmlTag.getAttributes()) != null) {
                    String[] stringArray = attributes;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String[] values;
                        String attribute;
                        String attrName = attribute = stringArray[i];
                        String attrType = null;
                        int index = attribute.indexOf(":");
                        if (index != -1) {
                            attrName = attribute.substring(0, index);
                            attrType = attribute.substring(index + 1, attribute.length());
                        }
                        if (attrType == null || !attributeName.equals(attrName)) continue;
                        Range fullRange = completionRequest.getReplaceRange();
                        for (String value : values = HTMLTag.getAttributeValues(attrType)) {
                            String insertText = completionRequest.getInsertAttrValue(value);
                            CompletionItem item = new CompletionItem();
                            item.setLabel(value);
                            item.setFilterText(insertText);
                            item.setKind(CompletionItemKind.Unit);
                            item.setTextEdit(Either.forLeft((Object)new TextEdit(fullRange, insertText)));
                            item.setInsertTextFormat(InsertTextFormat.PlainText);
                            completionResponse.addCompletionAttribute(item);
                        }
                        break;
                    }
                }
            }

            public void onXMLContent(ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) {
                CompletionItem completion = new CompletionItem("Test replace range");
                TextEdit edit = new TextEdit();
                edit.setNewText("replacement text");
                edit.setRange(request.getReplaceRange());
                completion.setTextEdit(Either.forLeft((Object)edit));
                response.addCompletionItem(completion);
            }
        }
    }
}

