/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.junit.jupiter.api.Test;

public class XMLHighlightingTest {
    @Test
    public void single() throws BadLocationException {
        XMLAssert.assertHighlights("|<html></html>", new int[0], null);
        XMLAssert.assertHighlights("<|html></html>", new int[]{1, 8}, "html");
        XMLAssert.assertHighlights("<h|tml></html>", new int[]{1, 8}, "html");
        XMLAssert.assertHighlights("<htm|l></html>", new int[]{1, 8}, "html");
        XMLAssert.assertHighlights("<html|></html>", new int[]{1, 8}, "html");
        XMLAssert.assertHighlights("<html>|</html>", new int[0], null);
        XMLAssert.assertHighlights("<html><|/html>", new int[0], null);
        XMLAssert.assertHighlights("<html></|html>", new int[]{1, 8}, "html");
        XMLAssert.assertHighlights("<html></h|tml>", new int[]{1, 8}, "html");
        XMLAssert.assertHighlights("<html></ht|ml>", new int[]{1, 8}, "html");
        XMLAssert.assertHighlights("<html></htm|l>", new int[]{1, 8}, "html");
        XMLAssert.assertHighlights("<html></html|>", new int[]{1, 8}, "html");
        XMLAssert.assertHighlights("<html></html>|", new int[0], null);
    }

    @Test
    public void nested() throws BadLocationException {
        XMLAssert.assertHighlights("<html>|<div></div></html>", new int[0], null);
        XMLAssert.assertHighlights("<html><|div></div></html>", new int[]{7, 13}, "div");
        XMLAssert.assertHighlights("<html><div>|</div></html>", new int[0], null);
        XMLAssert.assertHighlights("<html><div></di|v></html>", new int[]{7, 13}, "div");
        XMLAssert.assertHighlights("<html><div><div></div></di|v></html>", new int[]{7, 24}, "div");
        XMLAssert.assertHighlights("<html><div><div></div|></div></html>", new int[]{12, 18}, "div");
        XMLAssert.assertHighlights("<html><div><div|></div></div></html>", new int[]{12, 18}, "div");
        XMLAssert.assertHighlights("<html><div><div></div></div></h|tml>", new int[]{1, 30}, "html");
        XMLAssert.assertHighlights("<html><di|v></div><div></div></html>", new int[]{7, 13}, "div");
        XMLAssert.assertHighlights("<html><div></div><div></d|iv></html>", new int[]{18, 24}, "div");
    }

    @Test
    public void selfclosed() throws BadLocationException {
        XMLAssert.assertHighlights("<html><|div/></html>", new int[]{7}, "div");
        XMLAssert.assertHighlights("<html><|br></html>", new int[]{7}, "br");
        XMLAssert.assertHighlights("<html><div><d|iv/></div></html>", new int[]{12}, "div");
    }

    @Test
    public void caseSensitive() throws BadLocationException {
        XMLAssert.assertHighlights("<HTML><diV><Div></dIV></dI|v></html>", new int[]{24}, "div");
        XMLAssert.assertHighlights("<HTML><diV|><Div></dIV></dIv></html>", new int[]{7}, "div");
    }

    @Test
    public void insideEndTag() throws BadLocationException {
        XMLAssert.assertHighlights("<html|></meta></html>", new int[]{1, 15}, "html");
    }
}

