/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.io.FileOutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.LocationLink;
import org.junit.jupiter.api.Test;

public class XMLSchemaTypeDefinitionWithCacheExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void typeDefinitionPOMCache() throws Exception {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(true);
        };
        Path expectedLocation = this.testWorkDirectory.resolve("cache/http/maven.apache.org/xsd/maven-4.0.0.xsd");
        Files.createDirectories(expectedLocation.getParent(), new FileAttribute[0]);
        Path path = Files.createFile(expectedLocation, new FileAttribute[0]);
        try (ReadableByteChannel rbc = Channels.newChannel(XMLSchemaTypeDefinitionWithCacheExtensionsTest.class.getResourceAsStream("/xsd/maven-4.0.0.xsd"));
             FileOutputStream fos = new FileOutputStream(path.toFile());){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        XMLLanguageService ls2 = new XMLLanguageService();
        String targetSchemaURI = expectedLocation.toUri().toString();
        String xml = "<proj|ect xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n";
        XMLAssert.testTypeDefinitionFor(ls2, null, configuration, xml, "pom.xml", XMLAssert.ll(targetSchemaURI, XMLAssert.r(0, 1, 0, 8), XMLAssert.r(24, 19, 24, 28)));
        xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n<paren|t>";
        XMLAssert.testTypeDefinitionFor(ls2, null, configuration, xml, "pom.xml", XMLAssert.ll(targetSchemaURI, XMLAssert.r(3, 1, 3, 7), XMLAssert.r(52, 37, 52, 45)));
        xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n<parent><grou|pId>";
        XMLAssert.testTypeDefinitionFor(ls2, null, configuration, xml, "pom.xml", XMLAssert.ll(targetSchemaURI, XMLAssert.r(3, 9, 3, 16), XMLAssert.r(842, 37, 842, 46)));
        xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n<XX|X>";
        XMLAssert.testTypeDefinitionFor(ls2, null, configuration, xml, "pom.xml", new LocationLink[0]);
    }
}

