/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.contentmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDAttributeDeclaration;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDDocument;
import org.eclipse.lemminx.extensions.xsd.contentmodel.XSDDocumentation;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.eclipse.lemminx.settings.SchemaDocumentationType;
import org.eclipse.lemminx.utils.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMXSDElementDeclaration
implements CMElementDeclaration {
    private static final short PC_UNKWOWN = -1;
    private final CMXSDDocument document;
    private final XSElementDeclaration elementDeclaration;
    private final XSTypeDefinition typeDefinition;
    private Collection<CMAttributeDeclaration> attributes;
    private Collection<CMElementDeclaration> elements;
    private String documentation;
    private Map<String, String> textsDocumentation;
    private SchemaDocumentationType docStrategy;
    private Map<String, Boolean> elementOptionality;

    private CMXSDElementDeclaration(CMXSDDocument document, XSElementDeclaration elementDeclaration, XSTypeDefinition typeDefinition) {
        this.document = document;
        this.elementDeclaration = elementDeclaration;
        this.typeDefinition = typeDefinition;
    }

    public CMXSDElementDeclaration(CMXSDDocument document, XSElementDeclaration elementDeclaration) {
        this(document, elementDeclaration, elementDeclaration.getTypeDefinition());
    }

    public CMXSDElementDeclaration refineType(XSTypeDefinition refinedType) {
        return new CMXSDElementDeclaration(this.document, this.elementDeclaration, refinedType);
    }

    @Override
    public String getLocalName() {
        return this.elementDeclaration.getName();
    }

    @Override
    public String getNamespace() {
        return this.elementDeclaration.getNamespace();
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public Collection<CMAttributeDeclaration> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<CMAttributeDeclaration>();
            this.collectAttributesDeclaration(this.elementDeclaration, this.attributes);
        }
        return this.attributes;
    }

    private void collectAttributesDeclaration(XSElementDeclaration elementDecl, Collection<CMAttributeDeclaration> attributes) {
        switch (this.typeDefinition.getTypeCategory()) {
            case 16: {
                break;
            }
            case 15: {
                this.collectAttributesDeclaration((XSComplexTypeDefinition)this.typeDefinition, attributes);
            }
        }
    }

    private void collectAttributesDeclaration(XSComplexTypeDefinition typeDefinition, Collection<CMAttributeDeclaration> attributes) {
        XSObjectList list = typeDefinition.getAttributeUses();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                XSObject object = list.item(i);
                if (object.getType() != 4) continue;
                XSAttributeUse attributeUse = (XSAttributeUse)object;
                attributes.add(new CMXSDAttributeDeclaration(this, attributeUse));
            }
        }
    }

    @Override
    public Collection<CMElementDeclaration> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<CMElementDeclaration>();
            this.collectElementsDeclaration(this.elementDeclaration, this.elements);
        }
        return this.elements;
    }

    @Override
    public Collection<CMElementDeclaration> getPossibleElements(DOMElement parentElement, int offset) {
        if (this.typeDefinition != null && this.typeDefinition.getTypeCategory() == 15) {
            CMBuilder cmBuilder = new CMBuilder(new CMNodeFactory());
            XSCMValidator validator = ((XSComplexTypeDecl)this.typeDefinition).getContentModel(cmBuilder);
            if (validator == null) {
                return Collections.emptyList();
            }
            SubstitutionGroupHandler handler = new SubstitutionGroupHandler((XSElementDeclHelper)this.document);
            List<QName> qNames = CMXSDElementDeclaration.toQNames(parentElement, offset);
            int[] states = validator.startContentModel();
            for (QName elementName : qNames) {
                Object decl = validator.oneTransition(elementName, states, handler);
                if (decl != null) continue;
                return Collections.emptyList();
            }
            Vector result = validator.whatCanGoHere(states);
            if (result.isEmpty()) {
                return Collections.emptyList();
            }
            HashSet<CMElementDeclaration> possibleElements = new HashSet<CMElementDeclaration>();
            for (Object object : result) {
                if (object instanceof XSElementDeclaration) {
                    XSElementDeclaration elementDecl = (XSElementDeclaration)object;
                    this.document.collectElement(elementDecl, possibleElements);
                    XSObjectList group = this.document.getSubstitutionGroup(elementDecl);
                    if (group == null) continue;
                    for (int i = 0; i < group.getLength(); ++i) {
                        XSElementDeclaration o = (XSElementDeclaration)group.item(i);
                        this.document.collectElement(o, possibleElements);
                    }
                    continue;
                }
                Collection<CMElementDeclaration> anyElements = this.getXSAnyElements(object);
                if (anyElements == null) continue;
                return anyElements;
            }
            return possibleElements;
        }
        return this.getElements();
    }

    private Collection<CMElementDeclaration> getXSAnyElements(Object declaration) {
        short processContents = CMXSDElementDeclaration.getXSAnyProcessContents(declaration);
        if (processContents != -1) {
            switch (processContents) {
                case 1: 
                case 2: {
                    return this.document.getElements();
                }
            }
            return ANY_ELEMENT_DECLARATIONS;
        }
        return null;
    }

    private static short getXSAnyProcessContents(Object declaration) {
        XSWildcard wildcard;
        if (declaration instanceof XSWildcard && (wildcard = (XSWildcard)declaration).getConstraintType() == 1) {
            return wildcard.getProcessContents();
        }
        return -1;
    }

    private static List<QName> toQNames(DOMElement parentElement, int offset) {
        if (parentElement == null || !parentElement.hasChildNodes()) {
            return Collections.emptyList();
        }
        ArrayList<QName> qNames = new ArrayList<QName>();
        NodeList children = parentElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)child;
            if (element.getEnd() > offset) break;
            if (!element.isClosed()) continue;
            qNames.add(CMXSDElementDeclaration.createQName(element));
        }
        return qNames;
    }

    private static QName createQName(Element tag) {
        String namespace = tag.getNamespaceURI();
        return new QName(tag.getPrefix(), tag.getLocalName().intern(), tag.getTagName().intern(), StringUtils.isEmpty(namespace) ? null : namespace.intern());
    }

    private void collectElementsDeclaration(XSElementDeclaration elementDecl, Collection<CMElementDeclaration> elements) {
        switch (this.typeDefinition.getTypeCategory()) {
            case 16: {
                break;
            }
            case 15: {
                this.collectElementsDeclaration((XSComplexTypeDefinition)this.typeDefinition, elements);
            }
        }
    }

    private void collectElementsDeclaration(XSComplexTypeDefinition typeDefinition, Collection<CMElementDeclaration> elements) {
        XSParticle particle = typeDefinition.getParticle();
        if (particle != null) {
            this.collectElementsDeclaration(particle.getTerm(), elements);
        }
    }

    @Override
    public boolean isOptional(String childElementName) {
        Boolean isOptional;
        if (this.elementOptionality == null) {
            this.elementOptionality = new HashMap<String, Boolean>();
            switch (this.typeDefinition.getTypeCategory()) {
                case 16: {
                    break;
                }
                case 15: {
                    XSParticle particle = ((XSComplexTypeDefinition)this.typeDefinition).getParticle();
                    if (particle == null) break;
                    XSObjectList objectList = ((XSModelGroup)particle.getTerm()).getParticles();
                    for (int i = 0; i < objectList.getLength(); ++i) {
                        XSParticle xp = (XSParticle)objectList.item(i);
                        XSTerm t = xp.getTerm();
                        if (!(t instanceof XSElementDeclaration) || xp == null) continue;
                        this.elementOptionality.put(t.getName(), xp.getMinOccurs() == 0);
                    }
                    break;
                }
            }
        }
        return (isOptional = this.elementOptionality.get(childElementName)) != null ? isOptional : false;
    }

    private void collectElementsDeclaration(XSTerm term, Collection<CMElementDeclaration> elements) {
        if (term == null) {
            return;
        }
        switch (term.getType()) {
            case 9: {
                this.document.getElements().forEach(e -> {
                    if (!elements.contains(e)) {
                        elements.add((CMElementDeclaration)e);
                    }
                });
                break;
            }
            case 7: {
                XSObjectList particles = ((XSModelGroup)term).getParticles();
                particles.forEach(p -> this.collectElementsDeclaration(((XSParticle)p).getTerm(), elements));
                break;
            }
            case 2: {
                XSElementDeclaration elementDeclaration = (XSElementDeclaration)term;
                this.document.collectElement(elementDeclaration, elements);
            }
        }
    }

    @Override
    public String getDocumentation(ISharedSettingsRequest request) {
        SchemaDocumentationType currStrategy = request.getSharedSettings().getPreferences().getShowSchemaDocumentationType();
        if (this.docStrategy != currStrategy) {
            this.clearDocumentation();
        } else if (this.documentation != null) {
            return this.documentation;
        }
        this.docStrategy = currStrategy;
        XSObjectList annotations = this.getElementAnnotations();
        boolean markdownSupported = request.canSupportMarkupKind("markdown");
        this.documentation = new XSDDocumentation(annotations, this.docStrategy, !markdownSupported).getFormattedDocumentation(markdownSupported);
        return this.documentation;
    }

    private XSObjectList getElementAnnotations() {
        XSObjectList annotation = this.elementDeclaration.getAnnotations();
        if (annotation != null && annotation.getLength() > 0) {
            return annotation;
        }
        if (this.typeDefinition == null) {
            return null;
        }
        return this.getElementAnnotations(this.typeDefinition);
    }

    private XSObjectList getElementAnnotations(XSTypeDefinition typeDefinition) {
        if (typeDefinition.getTypeCategory() == 15) {
            XSObjectList annotation = ((XSComplexTypeDecl)typeDefinition).getAnnotations();
            if (((XSComplexTypeDecl)typeDefinition).getDerivationMethod() == 1) {
                XSObjectListImpl allAnnotations = new XSObjectListImpl();
                XSTypeDefinition baseType = ((XSComplexTypeDecl)typeDefinition).getBaseType();
                for (Object xsObject : annotation.toArray()) {
                    if ((XSObject)xsObject == null) continue;
                    allAnnotations.addXSObject((XSObject)xsObject);
                }
                for (Object xsObject : this.getElementAnnotations(baseType).toArray()) {
                    if ((XSObject)xsObject == null) continue;
                    allAnnotations.addXSObject((XSObject)xsObject);
                }
                return allAnnotations;
            }
            return annotation;
        }
        if (typeDefinition.getTypeCategory() == 16) {
            return ((XSSimpleTypeDecl)typeDefinition).getAnnotations();
        }
        return null;
    }

    @Override
    public CMElementDeclaration findCMElement(String tag, String namespace) {
        for (CMElementDeclaration cmElement : this.getElements()) {
            if (!cmElement.getLocalName().equals(tag)) continue;
            return cmElement;
        }
        return null;
    }

    @Override
    public CMAttributeDeclaration findCMAttribute(String attributeName, String namespace) {
        for (CMAttributeDeclaration cmAttribute : this.getAttributes()) {
            if (!cmAttribute.getLocalName().equals(attributeName)) continue;
            return cmAttribute;
        }
        return null;
    }

    public String toString() {
        return this.getLocalName();
    }

    @Override
    public boolean isEmpty() {
        if (this.typeDefinition != null && this.typeDefinition.getTypeCategory() == 15) {
            XSComplexTypeDefinition complexTypeDefinition = (XSComplexTypeDefinition)this.typeDefinition;
            return complexTypeDefinition.getContentType() == 0;
        }
        return false;
    }

    @Override
    public boolean isNillable() {
        return this.elementDeclaration == null ? false : this.elementDeclaration.getNillable();
    }

    @Override
    public Collection<String> getEnumerationValues() {
        if (this.typeDefinition != null) {
            XSSimpleTypeDefinition simpleDefinition = null;
            if (this.typeDefinition.getTypeCategory() == 16) {
                simpleDefinition = (XSSimpleTypeDefinition)this.typeDefinition;
            } else if (this.typeDefinition.getTypeCategory() == 15) {
                simpleDefinition = ((XSComplexTypeDefinition)this.typeDefinition).getSimpleType();
            }
            return CMXSDDocument.getEnumerationValues(simpleDefinition);
        }
        return Collections.emptyList();
    }

    @Override
    public String getTextDocumentation(String textContent, ISharedSettingsRequest request) {
        SchemaDocumentationType currStrategy = request.getSharedSettings().getPreferences().getShowSchemaDocumentationType();
        if (this.docStrategy != currStrategy) {
            this.clearDocumentation();
        }
        this.docStrategy = currStrategy;
        if (this.textsDocumentation == null) {
            this.textsDocumentation = this.createTextsDocumentation(request);
        }
        return this.textsDocumentation.get(textContent);
    }

    private Map<String, String> createTextsDocumentation(ISharedSettingsRequest request) {
        boolean markdownSupported = request.canSupportMarkupKind("markdown");
        HashMap<String, String> textsDocumentation = new HashMap<String, String>();
        this.getEnumerationValues().forEach(value -> {
            String documentation = null;
            XSObjectList annotations = this.getTextAnnotations((String)value);
            if (annotations != null) {
                documentation = new XSDDocumentation(annotations, (String)value, this.docStrategy, !markdownSupported).getFormattedDocumentation(markdownSupported);
            }
            if (StringUtils.isBlank(documentation)) {
                documentation = this.getDocumentation(request);
            }
            textsDocumentation.put((String)value, documentation);
        });
        return textsDocumentation;
    }

    private XSObjectList getTextAnnotations(String textContent) {
        if (this.typeDefinition != null) {
            XSSimpleTypeDefinition simpleDefinition = null;
            if (this.typeDefinition.getTypeCategory() == 16) {
                simpleDefinition = (XSSimpleTypeDefinition)this.typeDefinition;
            } else if (this.typeDefinition.getTypeCategory() == 15) {
                simpleDefinition = ((XSComplexTypeDefinition)this.typeDefinition).getSimpleType();
            }
            return CMXSDDocument.getEnumerationAnnotations(simpleDefinition, textContent);
        }
        return null;
    }

    private void clearDocumentation() {
        this.textsDocumentation = null;
        this.documentation = null;
    }

    XSElementDeclaration getElementDeclaration() {
        return this.elementDeclaration;
    }

    @Override
    public String getDocumentURI() {
        SchemaGrammar schemaGrammar = this.document.getOwnerSchemaGrammar(this.elementDeclaration);
        return CMXSDDocument.getSchemaURI(schemaGrammar);
    }

    @Override
    public boolean isStringType() {
        if (this.typeDefinition != null) {
            XSSimpleTypeDefinition simpleDefinition = null;
            if (this.typeDefinition.getTypeCategory() == 16) {
                simpleDefinition = (XSSimpleTypeDefinition)this.typeDefinition;
            } else if (this.typeDefinition.getTypeCategory() == 15) {
                simpleDefinition = ((XSComplexTypeDefinition)this.typeDefinition).getSimpleType();
            }
            if (simpleDefinition != null) {
                return "string".equals(simpleDefinition.getName());
            }
        }
        return false;
    }

    @Override
    public boolean isMixedContent() {
        if (this.typeDefinition != null && this.typeDefinition.getTypeCategory() == 15) {
            XSComplexTypeDefinition complexTypeDefinition = (XSComplexTypeDefinition)this.typeDefinition;
            return complexTypeDefinition.getContentType() == 3;
        }
        return false;
    }

    public Set<CMElementDeclaration> getRequiredElements() {
        LinkedHashSet<CMElementDeclaration> requiredElements = new LinkedHashSet<CMElementDeclaration>();
        for (CMElementDeclaration element : this.elements) {
            if (this.isOptional(element.getLocalName())) continue;
            requiredElements.add(element);
        }
        return requiredElements;
    }
}

