/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class DTDDiagnosticsTest
extends AbstractCacheBasedTest {
    @Test
    public void EntityDeclUnterminated() throws Exception {
        String dtd = "<!ENTITY copyright \"Copyright W3Schools.\"\r\n<!ELEMENT element-name (#PCDATA)>";
        DTDDiagnosticsTest.testDiagnosticsFor(dtd, "test.dtd", XMLAssert.d(0, 41, 42, (IXMLErrorCode)DTDErrorCode.EntityDeclUnterminated));
    }

    @Test
    public void OpenQuoteExpected() throws Exception {
        String dtd = "<!ATTLIST dadesadministratives idinstitut ID >";
        Diagnostic d = XMLAssert.d(0, 31, 41, (IXMLErrorCode)DTDErrorCode.OpenQuoteExpected);
        DTDDiagnosticsTest.testDiagnosticsFor(dtd, "test.dtd", d);
    }

    public static void testDiagnosticsFor(String xml, String fileURI, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, null, null, fileURI, true, expected);
    }

    public static void testDiagnosticsFor(String xml, String fileURI, ContentModelSettings settings, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, null, null, fileURI, true, settings, expected);
    }

    public static void testDiagnosticsFor(XMLLanguageService ls, String xml, String fileURI, ContentModelSettings settings, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(ls, xml, null, null, fileURI, true, settings, expected);
    }
}

