/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.entities.participants;

import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.DTDEntityDecl;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.extensions.AbstractDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IDefinitionRequest;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;

public class EntitiesDefinitionParticipant
extends AbstractDefinitionParticipant {
    @Override
    protected boolean match(DOMDocument document) {
        return true;
    }

    @Override
    protected void doFindDefinition(IDefinitionRequest request, List<LocationLink> locations, CancelChecker cancelChecker) {
        DOMNode node = request.getNode();
        if (!node.isText()) {
            return;
        }
        DOMDocument document = request.getXMLDocument();
        int offset = request.getOffset();
        XMLPositionUtility.EntityReferenceRange entityRange = XMLPositionUtility.selectEntityReference(offset, document);
        if (entityRange != null) {
            String entityName = entityRange.getName();
            Range range = entityRange.getRange();
            EntitiesDefinitionParticipant.searchInLocalEntities(entityName, range, document, locations, cancelChecker);
            EntitiesDefinitionParticipant.searchInExternalEntities(entityName, range, document, locations, request, cancelChecker);
        }
    }

    private static void searchInLocalEntities(String entityName, Range entityRange, DOMDocument document, List<LocationLink> locations, CancelChecker cancelChecker) {
        DOMDocumentType docType = document.getDoctype();
        if (docType == null) {
            return;
        }
        cancelChecker.checkCanceled();
        NamedNodeMap entities = docType.getEntities();
        for (int i = 0; i < entities.getLength(); ++i) {
            cancelChecker.checkCanceled();
            DTDEntityDecl entity = (DTDEntityDecl)entities.item(i);
            EntitiesDefinitionParticipant.fillEntityLocation(entity, entityName, entityRange, locations);
        }
    }

    private static void searchInExternalEntities(String entityName, Range entityRange, DOMDocument document, List<LocationLink> locations, IDefinitionRequest request, CancelChecker cancelChecker) {
        ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
        Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(document, null, false);
        for (CMDocument cmDocument : cmDocuments) {
            List<Entity> entities = cmDocument.getEntities();
            for (Entity entity : entities) {
                EntitiesDefinitionParticipant.fillEntityLocation((DTDEntityDecl)entity, entityName, entityRange, locations);
            }
        }
    }

    private static void fillEntityLocation(DTDEntityDecl entity, String entityName, Range entityRange, List<LocationLink> locations) {
        if (entityName.equals(entity.getName())) {
            DTDDeclParameter name = entity.getNameParameter();
            locations.add(XMLPositionUtility.createLocationLink(entityRange, name));
        }
    }
}

