/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.match.MatchContext;
import com.thaiopensource.relaxng.pattern.CMRelaxNGAttributeDeclarationCollector;
import com.thaiopensource.relaxng.pattern.CMRelaxNGDocument;
import com.thaiopensource.relaxng.pattern.CMRelaxNGElementDeclarationCollector;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternBuilder;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.PatternMatcher;
import com.thaiopensource.relaxng.pattern.RequiredElementsFunction;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import com.thaiopensource.relaxng.pattern.SimpleNameClass;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.sax.Context;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMRelaxNGElementDeclaration
implements CMElementDeclaration {
    private final CMRelaxNGDocument cmDocument;
    private final ElementPattern pattern;
    private Collection<CMElementDeclaration> elements;
    private Collection<CMAttributeDeclaration> attributes;
    private Set<Name> requiredElementNames;

    CMRelaxNGElementDeclaration(CMRelaxNGDocument document, ElementPattern pattern) {
        this.cmDocument = document;
        this.pattern = pattern;
    }

    public ElementPattern getPattern() {
        return this.pattern;
    }

    @Override
    public String getLocalName() {
        return this.getJingName().getLocalName();
    }

    @Override
    public String getNamespace() {
        return this.getJingName().getNamespaceUri();
    }

    @Override
    public String getPrefix(String namespaceURI) {
        DOMNode node = this.cmDocument.findNode(this.pattern.getLocator());
        if (node != null && node.isElement()) {
            return ((DOMElement)node).getPrefix(namespaceURI);
        }
        return null;
    }

    private Name getJingName() {
        NameClass nameClass = this.pattern.getNameClass();
        if (nameClass instanceof SimpleNameClass) {
            return ((SimpleNameClass)nameClass).getName();
        }
        return null;
    }

    @Override
    public Collection<CMAttributeDeclaration> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new CMRelaxNGAttributeDeclarationCollector(this, this.pattern.getContent()).getAttributes();
        }
        return this.attributes;
    }

    @Override
    public Collection<CMElementDeclaration> getElements() {
        if (this.elements == null) {
            this.elements = new CMRelaxNGElementDeclarationCollector(this.cmDocument, this.pattern.getContent()).getElements();
        }
        return this.elements;
    }

    @Override
    public Collection<CMElementDeclaration> getPossibleElements(DOMElement parentElement, int offset) {
        PatternMatcher matcher = new PatternMatcher((Pattern)this.pattern, new ValidatorPatternBuilder((PatternBuilder)new SchemaPatternBuilder()));
        matcher.matchStartDocument();
        Context context = new Context();
        Name n = CMRelaxNGElementDeclaration.createName(parentElement);
        matcher.matchStartTagOpen(n, n.getLocalName(), (MatchContext)context);
        if (parentElement.hasAttributes()) {
            List<DOMAttr> attributes = parentElement.getAttributeNodes();
            for (DOMAttr attr : attributes) {
                Name a = this.createName(attr);
                matcher.matchAttributeName(a, a.getLocalName(), (MatchContext)context);
                matcher.matchAttributeValue(attr.getValue(), a, a.getLocalName(), (MatchContext)context);
            }
        }
        matcher.matchStartTagClose(n, n.getLocalName(), (MatchContext)context);
        List<Name> names = CMRelaxNGElementDeclaration.toNames(parentElement, offset);
        for (Name name : names) {
            matcher.matchStartTagOpen(name, name.getLocalName(), (MatchContext)context);
            matcher.matchEndTag(name, name.getLocalName(), (MatchContext)context);
        }
        com.thaiopensource.relaxng.match.NameClass nc = matcher.possibleStartTagNames();
        Set allowed = nc.getIncludedNames();
        ArrayList<CMElementDeclaration> possibleElements = new ArrayList<CMElementDeclaration>();
        for (Name name : allowed) {
            CMElementDeclaration possible = this.findCMElement(name.getLocalName(), name.getNamespaceUri());
            possibleElements.add(possible);
        }
        return possibleElements;
    }

    private static List<Name> toNames(DOMElement parentElement, int offset) {
        if (parentElement == null || !parentElement.hasChildNodes()) {
            return Collections.emptyList();
        }
        ArrayList<Name> qNames = new ArrayList<Name>();
        NodeList children = parentElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)child;
            if (element.getEnd() > offset) break;
            if (!element.isClosed()) continue;
            qNames.add(CMRelaxNGElementDeclaration.createName(element));
        }
        return qNames;
    }

    private static Name createName(Element tag) {
        String namespace = tag.getNamespaceURI();
        return new Name(namespace == null ? "" : namespace, tag.getLocalName());
    }

    private Name createName(DOMAttr attr) {
        return new Name("", attr.getLocalName());
    }

    @Override
    public CMElementDeclaration findCMElement(String tag, String namespace) {
        for (CMElementDeclaration cmElement : this.getElements()) {
            if (!cmElement.getLocalName().equals(tag)) continue;
            return cmElement;
        }
        return null;
    }

    @Override
    public CMAttributeDeclaration findCMAttribute(String attributeName, String namespace) {
        for (CMAttributeDeclaration cmAttribute : this.getAttributes()) {
            if (!cmAttribute.getLocalName().equals(attributeName)) continue;
            return cmAttribute;
        }
        return null;
    }

    @Override
    public String getDocumentation(ISharedSettingsRequest request) {
        return this.cmDocument.getDocumentation(this.pattern.getLocator());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Collection<String> getEnumerationValues() {
        return Collections.emptyList();
    }

    @Override
    public String getTextDocumentation(String value, ISharedSettingsRequest request) {
        return null;
    }

    @Override
    public String getDocumentURI() {
        return this.pattern.getLocator().getSystemId();
    }

    @Override
    public boolean isStringType() {
        return false;
    }

    @Override
    public boolean isMixedContent() {
        return false;
    }

    @Override
    public boolean isOptional(String childElementName) {
        if (this.requiredElementNames == null) {
            RequiredElementsFunction elementsFunction = new RequiredElementsFunction();
            this.requiredElementNames = (Set)this.pattern.apply((PatternFunction)elementsFunction);
            for (Name name : this.requiredElementNames) {
                if (!childElementName.equals(name.getLocalName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isNillable() {
        return false;
    }

    void addElement(CMRelaxNGElementDeclaration element) {
        if (this.elements == null) {
            this.elements = new ArrayList<CMElementDeclaration>();
        }
        this.elements.add(element);
    }

    public CMRelaxNGDocument getCMDocument() {
        return this.cmDocument;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<element");
        result.append(" name=\"");
        result.append(this.getJingName().getLocalName());
        result.append("\"");
        result.append(" namespaceUri=\"");
        result.append(this.getJingName().getNamespaceUri());
        result.append("\"");
        result.append(" />");
        return result.toString();
    }
}

