/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.commands;

import java.net.URL;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.nogrammarconstraints.NoGrammarConstraintsCodeAction;
import org.eclipse.lemminx.services.IXMLDocumentProvider;
import org.eclipse.lemminx.services.extensions.commands.AbstractDOMDocumentCommandHandler;
import org.eclipse.lemminx.services.extensions.commands.ArgumentsUtils;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AssociateGrammarCommand
extends AbstractDOMDocumentCommandHandler {
    public static final String COMMAND_ID = "xml.associate.grammar.insert";

    public AssociateGrammarCommand(IXMLDocumentProvider documentProvider) {
        super(documentProvider);
    }

    @Override
    protected Object executeCommand(DOMDocument document, ExecuteCommandParams params, SharedSettings sharedSettings, CancelChecker cancelChecker) throws Exception {
        String documentURI = document.getDocumentURI();
        String fullPathGrammarURI = ArgumentsUtils.getArgAt(params, 1, String.class);
        String bindingType = ArgumentsUtils.getArgAt(params, 2, String.class);
        String grammarURI = AssociateGrammarCommand.getRelativeURI(fullPathGrammarURI, documentURI);
        boolean isXSD = DOMUtils.isXSD(fullPathGrammarURI);
        if (GrammarBindingType.STANDARD.getName().equals(bindingType)) {
            if (isXSD) {
                String targetNamespace = AssociateGrammarCommand.getTargetNamespace(fullPathGrammarURI);
                if (StringUtils.isEmpty(targetNamespace)) {
                    return NoGrammarConstraintsCodeAction.createXSINoNamespaceSchemaLocationEdit(grammarURI, document);
                }
                return NoGrammarConstraintsCodeAction.createXSISchemaLocationEdit(grammarURI, targetNamespace, document);
            }
            return NoGrammarConstraintsCodeAction.createDocTypeEdit(grammarURI, document, sharedSettings);
        }
        if (GrammarBindingType.XML_MODEL.getName().equals(bindingType)) {
            String targetNamespace = isXSD ? AssociateGrammarCommand.getTargetNamespace(fullPathGrammarURI) : null;
            return NoGrammarConstraintsCodeAction.createXmlModelEdit(grammarURI, targetNamespace, document, sharedSettings);
        }
        throw new UnknownBindingTypeException(bindingType);
    }

    private static String getRelativeURI(String fullPathGrammarURI, String documentURI) {
        try {
            Path grammarPath = FilesUtils.getPath(fullPathGrammarURI);
            Path documentPath = FilesUtils.getPath(documentURI);
            Path relativePath = documentPath.getParent().relativize(grammarPath);
            return relativePath.toString().replaceAll("\\\\", "/");
        }
        catch (Exception e) {
            return fullPathGrammarURI;
        }
    }

    private static String getTargetNamespace(String xsdURI) {
        TargetNamespaceHandler handler = new TargetNamespaceHandler();
        try {
            SAXParserFactory factory = DOMUtils.newSAXParserFactory();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new URL(xsdURI).openStream(), (DefaultHandler)handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler.getTargetNamespace();
    }

    private static class TargetNamespaceHandler
    extends DefaultHandler {
        private String targetNamespace;

        private TargetNamespaceHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            this.targetNamespace = attributes.getValue("targetNamespace");
            throw new SAXException();
        }

        public String getTargetNamespace() {
            return this.targetNamespace;
        }
    }

    public static class UnknownBindingTypeException
    extends Exception {
        private static final String MESSAGE = "Unknown binding type ''{0}''. Allowed values are " + Stream.of(GrammarBindingType.values()).map(GrammarBindingType::getName).collect(Collectors.joining(", ", "[", "]"));

        public UnknownBindingTypeException(String bindingType) {
            super(MessageFormat.format(MESSAGE, bindingType));
        }
    }

    public static enum GrammarBindingType {
        STANDARD("standard"),
        XML_MODEL("xml-model");

        private String name;

        private GrammarBindingType(String name) {
            this.name = name != null ? name : this.name();
        }

        public String getName() {
            return this.name;
        }
    }
}

