/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.diagnostics;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.RelaxNGErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.junit.jupiter.api.Test;

public class RelaxNGDiagnosticsTest
extends AbstractCacheBasedTest {
    @Test
    public void out_of_context_element() throws Exception {
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<TEI>\r\n\r\n</TEI>";
        XMLAssert.testDiagnosticsFor(xml, null, null, "src/test/resources/relaxng/test.xml", XMLAssert.d(1, 1, 4, (IXMLErrorCode)RelaxNGErrorCode.out_of_context_element));
    }

    @Test
    public void incomplete_element_required_elements_missing_expected() throws Exception {
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\" >\r\n   <teiHeader>\r\n      <fileDesc>\r\n         <titleStmt>\r\n            <title></title>\r\n         </titleStmt>\r\n         <publicationStmt></publicationStmt>\r\n         <sourceDesc></sourceDesc>\r\n      </fileDesc>\r\n   </teiHeader></TEI>";
        XMLAssert.testDiagnosticsFor(xml, null, null, "src/test/resources/relaxng/test.xml", XMLAssert.d(7, 10, 25, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_elements_missing_expected), XMLAssert.d(8, 10, 20, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_elements_missing_expected), XMLAssert.d(1, 1, 4, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_elements_missing_expected));
    }

    @Test
    public void invalid_attribute_name() throws Exception {
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\" XXXX=\"\" >\r\n</TEI>";
        XMLAssert.testDiagnosticsFor(xml, null, null, "src/test/resources/relaxng/test.xml", XMLAssert.d(1, 41, 45, (IXMLErrorCode)RelaxNGErrorCode.invalid_attribute_name), XMLAssert.d(1, 1, 4, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_element_missing));
    }

    @Test
    public void invalid_attribute_value() throws Exception {
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\" next=\"\" >\r\n</TEI>";
        XMLAssert.testDiagnosticsFor(xml, null, null, "src/test/resources/relaxng/test.xml", XMLAssert.d(1, 46, 48, (IXMLErrorCode)RelaxNGErrorCode.invalid_attribute_value), XMLAssert.d(1, 1, 4, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_element_missing));
    }

    @Test
    public void invalid_attribute_value_enum() throws Exception {
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\" >\r\n   <teiHeader cert=\"XXXX\" >\r\n      <fileDesc>\r\n      </fileDesc>\r\n   </teiHeader></TEI>";
        XMLAssert.testDiagnosticsFor(xml, null, null, "src/test/resources/relaxng/test.xml", XMLAssert.d(2, 19, 25, (IXMLErrorCode)RelaxNGErrorCode.invalid_attribute_value), XMLAssert.d(3, 7, 15, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_element_missing), XMLAssert.d(1, 1, 4, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_elements_missing_expected));
    }

    @Test
    public void multiple_invalid_attribute() throws Exception {
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\" \r\n    bad1=\"\"\r\n    ana=\"\" \r\n    bad2=\"\"  \r\n    version=\"\">\r\n</TEI>";
        XMLAssert.testDiagnosticsFor(xml, null, null, "src/test/resources/relaxng/test.xml", XMLAssert.d(2, 4, 8, (IXMLErrorCode)RelaxNGErrorCode.invalid_attribute_name), XMLAssert.d(3, 8, 10, (IXMLErrorCode)RelaxNGErrorCode.invalid_attribute_value), XMLAssert.d(4, 4, 8, (IXMLErrorCode)RelaxNGErrorCode.invalid_attribute_name), XMLAssert.d(5, 12, 14, (IXMLErrorCode)RelaxNGErrorCode.invalid_attribute_value), XMLAssert.d(1, 1, 4, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_element_missing));
    }

    @Test
    public void required_attributes_missing() throws Exception {
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader>\r\n\t\t<fileDesc>\r\n\t\t\t<titleStmt>\r\n\t\t\t\t<title>\r\n\t\t\t\t</title>\r\n\t\t\t</titleStmt>\r\n\t\t\t<publicationStmt>\r\n\t\t\t\t<ab></ab>\r\n\t\t\t</publicationStmt>\r\n\t\t\t<sourceDesc>\r\n\t\t\t\t<ab></ab>\r\n\t\t\t</sourceDesc>\r\n\t\t</fileDesc>\r\n\t\t<encodingDesc>\r\n\t\t\t<appInfo>\r\n\t\t\t\t<application bad=\"\">\r\n\t\t\t\t</application>\r\n\t\t\t</appInfo>\r\n\t\t</encodingDesc>\r\n\t</teiHeader>\r\n</TEI>";
        XMLAssert.testDiagnosticsFor(xml, null, null, "src/test/resources/relaxng/test.xml", XMLAssert.d(17, 17, 20, (IXMLErrorCode)RelaxNGErrorCode.invalid_attribute_name), XMLAssert.d(17, 5, 16, (IXMLErrorCode)RelaxNGErrorCode.required_attributes_missing), XMLAssert.d(17, 5, 16, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_elements_missing_expected), XMLAssert.d(1, 1, 4, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_elements_missing_expected));
    }
}

