/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.services.format.XMLFormatterDocumentNew;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lsp4j.TextEdit;

public class DOMCommentFormatter {
    private final XMLFormatterDocumentNew formatterDocument;

    public DOMCommentFormatter(XMLFormatterDocumentNew formatterDocument) {
        this.formatterDocument = formatterDocument;
    }

    public void formatComment(DOMComment commentNode, XMLFormattingConstraints parentConstraints, int startRange, int endRange, List<TextEdit> edits) {
        int leftWhitespaceOffset;
        if (this.isPreserveEmptyContent()) {
            return;
        }
        if (commentNode.getEnd() == commentNode.getEndContent()) {
            return;
        }
        String text = this.formatterDocument.getText();
        int availableLineWidth = parentConstraints.getAvailableLineWidth();
        int start = commentNode.getStart();
        int n = leftWhitespaceOffset = start > 0 ? start - 1 : 0;
        while (leftWhitespaceOffset > 0 && Character.isWhitespace(text.charAt(leftWhitespaceOffset))) {
            --leftWhitespaceOffset;
        }
        int preservedNewLines = this.getPreservedNewlines();
        boolean addLineSeparator = this.formatterDocument.hasLineBreak(leftWhitespaceOffset, start);
        int indentLevel = parentConstraints.getIndentLevel();
        int currentNewLineCount = XMLFormatterDocumentNew.getExistingNewLineCount(this.formatterDocument.getText(), start, this.formatterDocument.getLineDelimiter());
        if (currentNewLineCount > preservedNewLines && startRange < start) {
            this.replaceLeftSpacesWithIndentationWithMultiNewLines(indentLevel, 0, start, preservedNewLines + 1, edits);
            availableLineWidth = this.getMaxLineWidth() - this.getTabSize();
        } else if (addLineSeparator && startRange < start) {
            this.replaceLeftSpacesWithIndentation(indentLevel, leftWhitespaceOffset, start, addLineSeparator, edits);
            availableLineWidth = this.getMaxLineWidth() - this.getTabSize() * indentLevel;
        }
        int spaceStart = -1;
        int spaceEnd = -1;
        availableLineWidth -= 4;
        for (int i = commentNode.getStartContent(); i < commentNode.getEndContent(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                if (spaceStart == -1) {
                    spaceStart = i;
                    continue;
                }
                spaceEnd = i;
                continue;
            }
            spaceEnd = i;
            if (startRange != -1 && endRange != -1 && (startRange > spaceStart || endRange < spaceEnd)) {
                return;
            }
            int contentStart = i;
            while (i + 1 < commentNode.getEnd() && !Character.isWhitespace(text.charAt(i + 1))) {
                ++i;
            }
            int contentEnd = i;
            if ((availableLineWidth -= contentEnd + 1 - contentStart) <= 0 && spaceStart != -1) {
                this.replaceLeftSpacesWithIndentation(indentLevel, spaceStart, contentStart, true, edits);
                int indentSpaces = this.getTabSize() * indentLevel;
                availableLineWidth = this.getMaxLineWidth() - indentSpaces - (contentEnd + 1 - contentStart);
            } else if (this.isJoinCommentLines()) {
                this.replaceSpacesWithOneSpace(spaceStart, spaceEnd - 1, edits);
                --availableLineWidth;
            } else if (spaceStart != -1) {
                availableLineWidth -= spaceEnd - spaceStart;
            }
            spaceStart = -1;
            spaceEnd = -1;
        }
        if (this.isJoinCommentLines()) {
            this.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
            --availableLineWidth;
        }
    }

    private boolean isJoinCommentLines() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isJoinCommentLines();
    }

    private boolean isPreserveEmptyContent() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isPreserveEmptyContent();
    }

    private int getTabSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getTabSize();
    }

    private int getMaxLineWidth() {
        return this.formatterDocument.getMaxLineWidth();
    }

    private int getPreservedNewlines() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getPreservedNewlines();
    }

    private void replaceSpacesWithOneSpace(int spaceStart, int spaceEnd, List<TextEdit> edits) {
        this.formatterDocument.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int from, int to, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, from, to, addLineSeparator, edits);
    }

    private int replaceLeftSpacesWithIndentationWithMultiNewLines(int indentLevel, int leftLimit, int offset, int newLineCount, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentationWithMultiNewLines(indentLevel, leftLimit, offset, newLineCount, edits);
    }
}

