/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsi.participants;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.extensions.xsi.XSISchemaModel;
import org.eclipse.lemminx.extensions.xsi.settings.XSISchemaLocationSplit;
import org.eclipse.lemminx.services.extensions.format.IFormatterParticipant;
import org.eclipse.lemminx.services.format.XMLFormatterDocumentNew;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.eclipse.lsp4j.TextEdit;

public class XSIFormatterParticipant
implements IFormatterParticipant {
    @Override
    public boolean formatAttributeValue(String name, String valueWithoutQuote, Character quote, DOMAttr attr, XMLBuilder xml) {
        if (XSISchemaModel.isXSISchemaLocationAttr(name, attr)) {
            int lineFeed;
            XMLFormattingOptions formattingOptions = xml.getSharedSettings().getFormattingSettings();
            XSISchemaLocationSplit split = XSISchemaLocationSplit.getSplit(formattingOptions);
            if (split == XSISchemaLocationSplit.none) {
                return false;
            }
            int n = lineFeed = split == XSISchemaLocationSplit.onElement ? 1 : 2;
            if (quote != null) {
                xml.append(quote.charValue());
            }
            List<String> locations = XSIFormatterParticipant.getLocations(valueWithoutQuote);
            String indent = "";
            for (int i = 0; i < locations.size(); ++i) {
                if (i % lineFeed == 0) {
                    if (i == 0) {
                        indent = this.getCurrentLineIndent(xml, formattingOptions);
                    } else {
                        xml.linefeed();
                        xml.append(indent);
                    }
                } else {
                    xml.appendSpace();
                }
                xml.append(locations.get(i));
            }
            if (quote != null) {
                xml.append(quote.charValue());
            }
            return true;
        }
        return false;
    }

    private static List<String> getLocations(String value) {
        ArrayList<String> locations = new ArrayList<String>();
        int start = -1;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isWhitespace(c)) {
                if (start == -1) continue;
                locations.add(value.substring(start, i));
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            locations.add(value.substring(start, value.length()));
        }
        return locations;
    }

    public String getCurrentLineIndent(XMLBuilder xml, XMLFormattingOptions formattingOptions) {
        boolean insertSpaces = formattingOptions.isInsertSpaces();
        int tabSize = formattingOptions.getTabSize();
        int nbChars = 0;
        for (int i = xml.length() - 1; i >= 0 && xml.charAt(i) != '\r' && xml.charAt(i) != '\n'; --i) {
            if (!insertSpaces && xml.charAt(i) == '\t') {
                nbChars += tabSize;
                continue;
            }
            ++nbChars;
        }
        StringBuilder indent = new StringBuilder();
        if (insertSpaces || tabSize <= 0) {
            for (int i = 0; i < nbChars; ++i) {
                indent.append(" ");
            }
        } else {
            int i;
            int nbTabs = nbChars / tabSize;
            nbChars %= tabSize;
            for (i = 0; i < nbTabs; ++i) {
                indent.append("\t");
            }
            for (i = 0; i < nbChars; ++i) {
                indent.append(" ");
            }
        }
        return indent.toString();
    }

    @Override
    public boolean formatAttributeValue(DOMAttr attr, XMLFormatterDocumentNew formatterDocument, int indentLevel, XMLFormattingOptions formattingOptions, List<TextEdit> edits) {
        XSISchemaLocationSplit split = XSISchemaLocationSplit.getSplit(formattingOptions);
        if (split == XSISchemaLocationSplit.none || !XSISchemaModel.isXSISchemaLocationAttr(attr.getName(), attr)) {
            return false;
        }
        int firstContentOffset = XSIFormatterParticipant.getFirstContentOffset(attr.getOriginalValue());
        if (firstContentOffset == -1) {
            return false;
        }
        int attrValueStart = attr.getNodeAttrValue().getStart();
        formatterDocument.removeLeftSpaces(attrValueStart + 1, attrValueStart + firstContentOffset, edits);
        int tabSize = formattingOptions.getTabSize();
        int startOfLineOffset = formatterDocument.getLineAtOffset(attr.getOwnerElement().getStart());
        int indentSpaceOffset = formattingOptions.isSplitAttributes() ? attrValueStart + 1 - attr.getNodeAttrName().getStart() + formattingOptions.getSplitAttributesIndentSize() * tabSize : (formattingOptions.isPreserveAttributeLineBreaks() ? attrValueStart - formatterDocument.getOffsetWithPreserveLineBreaks(startOfLineOffset, attrValueStart, tabSize, formattingOptions.isInsertSpaces()) : formatterDocument.getNormalizedLength(startOfLineOffset, attrValueStart + 1) - startOfLineOffset);
        int lineFeed = split == XSISchemaLocationSplit.onElement ? 1 : 2;
        int locationNum = 1;
        String attrValue = attr.getOriginalValue();
        for (int i = firstContentOffset; i < attrValue.length(); ++i) {
            int from = formatterDocument.adjustOffsetWithLeftWhitespaces(attrValueStart, attrValueStart + i + 1);
            if (!Character.isWhitespace(attrValue.charAt(i)) || Character.isWhitespace(attrValue.charAt(i + 1)) || StringUtils.isQuote(attrValue.charAt(from - attrValueStart))) continue;
            if (locationNum % lineFeed == 0) {
                formatterDocument.replaceLeftSpacesWithIndentationWithOffsetSpaces(indentSpaceOffset, attrValueStart, attrValueStart + i + 1, true, edits);
            } else {
                formatterDocument.replaceLeftSpacesWithOneSpace(indentSpaceOffset, attrValueStart + i + 1, edits);
            }
            ++locationNum;
        }
        return true;
    }

    private static int getFirstContentOffset(String originalValue) {
        if (originalValue == null) {
            return -1;
        }
        for (int i = 1; i < originalValue.length(); ++i) {
            if (Character.isWhitespace(originalValue.charAt(i)) || StringUtils.isQuote(originalValue.charAt(i))) continue;
            return i;
        }
        return -1;
    }
}

