/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces.xmlmodel;

import org.apache.xerces.xni.XMLString;
import org.eclipse.lemminx.utils.DOMUtils;

public class XMLModelDeclaration {
    private int hrefOffset;
    private String href;
    private int typeOffset;
    private String type;
    private int schematypensOffset;
    private String schematypens;

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public int getHrefOffset() {
        return this.hrefOffset;
    }

    public void setHrefOffset(int hrefOffset) {
        this.hrefOffset = hrefOffset;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getTypeOffset() {
        return this.typeOffset;
    }

    public void setTypeOffset(int typeOffset) {
        this.typeOffset = typeOffset;
    }

    public String getSchematypens() {
        return this.schematypens;
    }

    public void setSchematypens(String schematypens) {
        this.schematypens = schematypens;
    }

    public int getSchematypensOffset() {
        return this.schematypensOffset;
    }

    public void setSchematypensOffset(int schematypensOffset) {
        this.schematypensOffset = schematypensOffset;
    }

    public static XMLModelDeclaration parse(XMLString data) {
        return XMLModelDeclaration.parse(data.ch, data.offset, data.length);
    }

    public static XMLModelDeclaration parse(char[] data, int offset, int length) {
        XMLModelDeclaration model = new XMLModelDeclaration();
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        State state = State.Content;
        char equals = '\"';
        block17: for (int i = offset; i < length; ++i) {
            char ch = data[i];
            switch (state) {
                case Content: {
                    if (Character.isWhitespace(ch)) continue block17;
                    name.append(ch);
                    state = State.AttName;
                    continue block17;
                }
                case AttName: {
                    if (Character.isWhitespace(ch)) {
                        state = State.AfterAttName;
                        continue block17;
                    }
                    if (ch == '=') {
                        state = State.AfterEquals;
                        continue block17;
                    }
                    name.append(ch);
                    continue block17;
                }
                case AfterAttName: {
                    if (ch != '=') continue block17;
                    state = State.AfterEquals;
                    continue block17;
                }
                case AfterEquals: {
                    if (ch != '\"' && ch != '\'') continue block17;
                    equals = ch;
                    state = State.AttValue;
                    continue block17;
                }
                case AttValue: {
                    if (ch == equals) {
                        state = State.Content;
                        switch (name.toString()) {
                            case "href": {
                                String href = value.toString();
                                model.setHrefOffset(i - href.length());
                                model.setHref(href);
                                break;
                            }
                            case "type": {
                                String type = value.toString();
                                model.setTypeOffset(i - type.length());
                                model.setType(type);
                                break;
                            }
                            case "schematypens": {
                                String schematypens = value.toString();
                                model.setSchematypensOffset(i - schematypens.length());
                                model.setSchematypens(schematypens);
                            }
                        }
                        name.setLength(0);
                        value.setLength(0);
                        continue block17;
                    }
                    value.append(ch);
                }
            }
        }
        return model;
    }

    public static boolean isApplicableForDTD(XMLModelDeclaration modelDeclaration) {
        String href = modelDeclaration.getHref();
        String type = modelDeclaration.getType();
        if (DOMUtils.isDTD(href)) {
            return type == null || "application/xml-dtd".equals(type);
        }
        return "application/xml-dtd".equals(type);
    }

    public static boolean isApplicableForXSD(XMLModelDeclaration modelDeclaration) {
        String href = modelDeclaration.getHref();
        String schematypens = modelDeclaration.getSchematypens();
        if (DOMUtils.isXSD(href)) {
            return schematypens == null || "http://www.w3.org/2001/XMLSchema".equals(schematypens);
        }
        return "http://www.w3.org/2001/XMLSchema".equals(schematypens);
    }

    public static boolean isApplicableForRelaxNG(XMLModelDeclaration modelDeclaration) {
        String href = modelDeclaration.getHref();
        String schematypens = modelDeclaration.getSchematypens();
        if (DOMUtils.isRelaxNG(href)) {
            return schematypens == null || "http://relaxng.org/ns/structure/1.0".equals(schematypens);
        }
        return "http://relaxng.org/ns/structure/1.0".equals(schematypens);
    }

    private static enum State {
        Content,
        AttName,
        AfterAttName,
        AfterEquals,
        AttValue;

    }
}

