/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class XMLModelDiagnosticsTest {
    @Test
    public void xmlModelWithBadDTD() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?> \r\n<?xml-model href=\"BAD.dtd\"?>\r\n<root><item /></root>";
        XMLModelDiagnosticsTest.testDiagnosticsFor(xml, XMLAssert.d(1, 17, 26, (IXMLErrorCode)DTDErrorCode.DTDNotFound));
    }

    @Test
    public void xmlModelWithDTD() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?> \r\n<?xml-model href=\"src/test/resources/dtd/web-app_2_3.dtd\"?>\r\n<web-app>\r\n\t<XXX></XXX>\r\n</web-app>";
        XMLModelDiagnosticsTest.testDiagnosticsFor(xml, XMLAssert.d(3, 2, 5, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED), XMLAssert.d(2, 1, 8, (IXMLErrorCode)DTDErrorCode.MSG_CONTENT_INVALID));
    }

    @Test
    public void xmlModelWithBadXSD() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?> \r\n<?xml-model href=\"BAD.xsd\"?>\r\n<root><item /></root>";
        XMLModelDiagnosticsTest.testDiagnosticsFor(xml, XMLAssert.d(1, 18, 25, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4), XMLAssert.d(2, 1, 5, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a));
    }

    @Test
    public void xmlModelWithXSD() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<?xml-model href=\"src/test/resources/xsd/tag.xsd\"?>\r\n<root>\r\n  <tag></tag>\r\n  <optional></optional>\r\n  <optional></optional>\r\n  <optional></optional>\r\n</root>";
        XMLModelDiagnosticsTest.testDiagnosticsFor(xml, XMLAssert.d(6, 3, 6, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_f));
    }

    @Test
    public void xmlModelWithXSDAndNamespace() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-model href=\"http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" >\r\n\t<bean>\r\n\t\tXXXXXXXXXXXXX\r\n\t</bean>\r\n</beans>";
        Diagnostic d = XMLAssert.d(4, 2, 4, 15, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_3, "Element 'bean' cannot contain text content.\nThe content type is defined as element-only.\n\nCode:");
        XMLModelDiagnosticsTest.testDiagnosticsFor(xml, d);
    }

    private static void testDiagnosticsFor(String xml, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, "src/test/resources/catalogs/catalog.xml", expected);
    }
}

