/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.contentmodel;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.datatypes.ObjectList;
import org.eclipse.lemminx.dom.parser.Constants;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XSDAnnotationModel {
    private final List<String> appInfo = new ArrayList<String>();
    private final List<String> documentation = new ArrayList<String>();

    private XSDAnnotationModel() {
    }

    public List<String> getAppInfo() {
        return this.appInfo;
    }

    public List<String> getDocumentation() {
        return this.documentation;
    }

    public static List<String> getDocumentation(XSObjectList annotations) {
        return XSDAnnotationModel.getDocumentation(annotations, null);
    }

    public static List<String> getDocumentation(XSObjectList annotations, String value) {
        if (annotations == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : annotations) {
            String docFromPattern;
            XSAnnotation annotation = XSDAnnotationModel.getXSAnnotation((XSObject)object, value);
            XSDAnnotationModel annotationModel = XSDAnnotationModel.load(annotation);
            if (annotationModel == null) continue;
            List<String> documentation = annotationModel.getDocumentation();
            if (documentation.size() > 0) {
                result.addAll(documentation);
                continue;
            }
            String annotationString = annotation.getAnnotationString();
            if (StringUtils.isEmpty(annotationString) || StringUtils.isEmpty(docFromPattern = XSDAnnotationModel.getDocumentation(annotationString))) continue;
            result.add(docFromPattern);
        }
        return result;
    }

    public static List<String> getAppInfo(XSObjectList annotations) {
        return XSDAnnotationModel.getAppInfo(annotations, null);
    }

    public static List<String> getAppInfo(XSObjectList annotations, String value) {
        if (annotations == null) {
            return Collections.emptyList();
        }
        ArrayList<String> appinfo = new ArrayList<String>();
        for (Object object : annotations) {
            XSAnnotation annotation = XSDAnnotationModel.getXSAnnotation((XSObject)object, value);
            XSDAnnotationModel annotationModel = XSDAnnotationModel.load(annotation);
            if (annotationModel == null) continue;
            appinfo.addAll(annotationModel.getAppInfo());
        }
        return appinfo;
    }

    public static String getPrefix(XSObjectList annotations) {
        return XSDAnnotationModel.getPrefix(annotations, null);
    }

    public static String getPrefix(XSObjectList annotations, String value) {
        if (annotations == null) {
            return "";
        }
        for (Object object : annotations) {
            XSAnnotation annotation = XSDAnnotationModel.getXSAnnotation((XSObject)object, value);
            String content = annotation.getAnnotationString();
            int index = content.indexOf(":");
            if (index == -1) continue;
            return content.substring(1, index);
        }
        return "";
    }

    public static XSDAnnotationModel load(XSAnnotation annotation) {
        try {
            SAXParserFactory factory = DOMUtils.newSAXParserFactory();
            SAXParser saxParser = factory.newSAXParser();
            XSAnnotationHandler handler = new XSAnnotationHandler();
            saxParser.parse(new InputSource(new StringReader(annotation.getAnnotationString())), (DefaultHandler)handler);
            return handler.getModel();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static XSAnnotation getXSAnnotation(XSObject annotation, String value) {
        if (annotation instanceof XSMultiValueFacet && value != null) {
            XSMultiValueFacet multiValueFacet = (XSMultiValueFacet)annotation;
            ObjectList enumerationValues = multiValueFacet.getEnumerationValues();
            XSObjectList annotationValues = multiValueFacet.getAnnotations();
            for (int i = 0; i < enumerationValues.getLength(); ++i) {
                Object enumValue = enumerationValues.get(i);
                String enumString = ((ValidatedInfo)enumValue).stringValue();
                if (!value.equals(enumString)) continue;
                return (XSAnnotation)annotationValues.get(i);
            }
        } else if (annotation instanceof XSAnnotation) {
            return (XSAnnotation)annotation;
        }
        return null;
    }

    public static String getDocumentation(String xml) {
        Matcher m = Constants.DOCUMENTATION_CONTENT.matcher(xml);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static class XSAnnotationHandler
    extends DefaultHandler {
        private static final String APPINFO_ELEMENT = "appinfo";
        private static final String DOCUMENTATION_ELEMENT = "documentation";
        private StringBuilder current;
        private final XSDAnnotationModel model = new XSDAnnotationModel();

        public XSDAnnotationModel getModel() {
            return this.model;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.endsWith(DOCUMENTATION_ELEMENT) || qName.endsWith(APPINFO_ELEMENT)) {
                this.current = new StringBuilder();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (this.current != null) {
                if (qName.endsWith(APPINFO_ELEMENT)) {
                    XSAnnotationHandler.addIfNonEmptyString(this.model.appInfo, StringUtils.normalizeSpace(this.current.toString()));
                } else if (qName.endsWith(DOCUMENTATION_ELEMENT)) {
                    XSAnnotationHandler.addIfNonEmptyString(this.model.documentation, StringUtils.normalizeSpace(this.current.toString()));
                }
                this.current = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.current != null) {
                this.current.append(ch, start, length);
            }
            super.characters(ch, start, length);
        }

        private static void addIfNonEmptyString(List<String> list, String str) {
            if (!StringUtils.isEmpty(str)) {
                list.add(str);
            }
        }
    }
}

