/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces.xmlmodel;

import org.apache.xerces.xni.XMLString;

public class XMLModelDeclaration {
    private int hrefOffset;
    private String href;

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public int getHrefOffset() {
        return this.hrefOffset;
    }

    public void setHrefOffset(int hrefOffset) {
        this.hrefOffset = hrefOffset;
    }

    public static XMLModelDeclaration parse(XMLString data) {
        return XMLModelDeclaration.parse(data.ch, data.offset, data.length);
    }

    public static XMLModelDeclaration parse(char[] data, int offset, int length) {
        XMLModelDeclaration model = new XMLModelDeclaration();
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        State state = State.Content;
        char equals = '\"';
        block13: for (int i = offset; i < length; ++i) {
            char ch = data[i];
            switch (state) {
                case Content: {
                    if (Character.isWhitespace(ch)) continue block13;
                    name.append(ch);
                    state = State.AttName;
                    continue block13;
                }
                case AttName: {
                    if (Character.isWhitespace(ch)) {
                        state = State.AfterAttName;
                        continue block13;
                    }
                    if (ch == '=') {
                        state = State.AfterEquals;
                        continue block13;
                    }
                    name.append(ch);
                    continue block13;
                }
                case AfterAttName: {
                    if (ch != '=') continue block13;
                    state = State.AfterEquals;
                    continue block13;
                }
                case AfterEquals: {
                    if (ch != '\"' && ch != '\'') continue block13;
                    equals = ch;
                    state = State.AttValue;
                    continue block13;
                }
                case AttValue: {
                    if (ch == equals) {
                        state = State.Content;
                        switch (name.toString()) {
                            case "href": {
                                String href = value.toString();
                                model.setHrefOffset(i - href.length());
                                model.setHref(href);
                            }
                        }
                        name.setLength(0);
                        value.setLength(0);
                        continue block13;
                    }
                    value.append(ch);
                }
            }
        }
        return model;
    }

    private static enum State {
        Content,
        AttName,
        AfterAttName,
        AfterEquals,
        AttValue;

    }
}

