/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.IOUtils;

public class DOMUtils {
    private static final Logger LOGGER = Logger.getLogger(DOMUtils.class.getName());
    private static final String XSD_EXTENSION = ".xsd";
    private static final String DTD_EXTENSION = ".dtd";
    private static final String ENT_EXTENSION = ".ent";
    private static final String MOD_EXTENSION = ".mod";
    private static final String HTTP_WWW_W3_ORG_2001_XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String URN_OASIS_NAMES_TC_ENTITY_XMLNS_XML_CATALOG_NS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";

    private DOMUtils() {
    }

    public static boolean isXSD(DOMDocument document) {
        if (document == null) {
            return false;
        }
        String uri = document.getDocumentURI();
        if (DOMUtils.isXSD(uri)) {
            return true;
        }
        return DOMUtils.checkRootNamespace(document, HTTP_WWW_W3_ORG_2001_XML_SCHEMA_NS);
    }

    public static boolean isXSD(String uri) {
        return uri != null && uri.endsWith(XSD_EXTENSION);
    }

    public static boolean isCatalog(DOMDocument document) {
        return DOMUtils.checkRootNamespace(document, URN_OASIS_NAMES_TC_ENTITY_XMLNS_XML_CATALOG_NS);
    }

    private static boolean checkRootNamespace(DOMDocument document, String namespace) {
        DOMElement documentElement = document.getDocumentElement();
        return documentElement != null && namespace.equals(documentElement.getNamespaceURI());
    }

    public static boolean isDTD(String uri) {
        return uri != null && (uri.endsWith(DTD_EXTENSION) || uri.endsWith(ENT_EXTENSION) || uri.endsWith(MOD_EXTENSION));
    }

    public static boolean containsTextOnly(DOMElement element) {
        return element.getChildNodes().getLength() == 1 && element.getFirstChild().isText();
    }

    public static DOMDocument loadDocument(String documentURI, URIResolverExtensionManager resolverExtensionManager) {
        try {
            return DOMParser.getInstance().parse(IOUtils.convertStreamToString(new URL(documentURI).openStream()), documentURI, resolverExtensionManager);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while loading XML Schema '" + documentURI + "'.", e);
            return null;
        }
    }
}

