/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import java.util.Arrays;
import org.eclipse.lemminx.settings.XMLExcludedSymbolFile;

public class XMLSymbolSettings {
    private transient XMLExcludedSymbolFile[] excludedFiles;
    private boolean enabled = true;
    private String[] excluded;
    private int maxItemsComputed;

    public XMLExcludedSymbolFile[] getExcludedFiles() {
        return this.excludedFiles;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String[] getExcluded() {
        return this.excluded;
    }

    public void setExcluded(String[] excluded) {
        XMLExcludedSymbolFile[] exclusions = new XMLExcludedSymbolFile[excluded.length];
        for (int i = 0; i < excluded.length; ++i) {
            exclusions[i] = new XMLExcludedSymbolFile(excluded[i]);
        }
        this.excludedFiles = exclusions;
    }

    public boolean isExcluded(String uri) {
        if (this.excludedFiles == null) {
            return false;
        }
        for (XMLExcludedSymbolFile excludedFile : this.excludedFiles) {
            if (!excludedFile.matches(uri)) continue;
            return true;
        }
        return false;
    }

    public int getMaxItemsComputed() {
        return this.maxItemsComputed;
    }

    public void setMaxItemsComputed(int maxItemsComputed) {
        this.maxItemsComputed = maxItemsComputed;
    }

    public void merge(XMLSymbolSettings newSettings) {
        this.setEnabled(newSettings.isEnabled());
        String[] newPatterns = newSettings.getExcluded();
        if (newPatterns != null) {
            String[] newPatternsCopy = Arrays.copyOf(newPatterns, newPatterns.length);
            this.setExcluded(newPatternsCopy);
        }
        this.setMaxItemsComputed(newSettings.getMaxItemsComputed());
    }
}

